package org.gcube.application.geoportal.model.gis;

import javax.persistence.Inheritance;
import javax.persistence.InheritanceType;
import javax.persistence.MappedSuperclass;

import org.gcube.application.geoportal.model.content.AssociatedContent;

import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.Setter;
import lombok.ToString;


@Getter
@Setter
@ToString(callSuper=true)
@EqualsAndHashCode(callSuper=true)
@MappedSuperclass
@Inheritance(strategy = InheritanceType.SINGLE_TABLE)
public abstract class SDILayerDescriptor extends AssociatedContent{

	//meta
	private String layerUUID;
	private Long layerID;
	
	//layer
	private String layerName;
	private String wmsLink;
	
	
	
	
}
