package org.gcube.application.geoportalcommon.shared.products.model;

import java.io.Serializable;
import java.util.List;

import org.gcube.application.geoportalcommon.shared.products.content.AssociatedContentDV;
import org.gcube.application.geoportalcommon.shared.products.content.WorkspaceContentDV;

/**
 * The Class AbstractRelazioneScavoDV.
 *
 * @author Francesco Mangiacrapa at ISTI-CNR francesco.mangiacrapa@isti.cnr.it
 * 
 *         Sep 24, 2021
 */
public class AbstractRelazioneScavoDV extends AssociatedContentDV implements Serializable {

	/**
	 * 
	 */
	private static final long serialVersionUID = 8768745863185590509L;

	/** The abstract section. */
	private String abstractSectionIta;

	private String abstractSectionEng;

	private List<WorkspaceContentDV> listWsContent;

	/**
	 * Instantiates a new abstract relazione scavo.
	 */
	public AbstractRelazioneScavoDV() {

	}

	/**
	 * Instantiates a new abstract relazione scavo DV.
	 *
	 * @param abstractSectionIta the abstract section ita
	 * @param abstractSectionEng the abstract section eng
	 */
	public AbstractRelazioneScavoDV(String abstractSectionIta, String abstractSectionEng) {
		super();
		this.abstractSectionIta = abstractSectionIta;
		this.abstractSectionEng = abstractSectionEng;
	}

	/**
	 * Gets the abstract section ita.
	 *
	 * @return the abstract section ita
	 */
	public String getAbstractSectionIta() {
		return abstractSectionIta;
	}

	/**
	 * Sets the abstract section ita.
	 *
	 * @param abstractSectionIta the new abstract section ita
	 */
	public void setAbstractSectionIta(String abstractSectionIta) {
		this.abstractSectionIta = abstractSectionIta;
	}

	/**
	 * Gets the abstract section eng.
	 *
	 * @return the abstract section eng
	 */
	public String getAbstractSectionEng() {
		return abstractSectionEng;
	}

	/**
	 * Sets the abstract section eng.
	 *
	 * @param abstractSectionEng the new abstract section eng
	 */
	public void setAbstractSectionEng(String abstractSectionEng) {
		this.abstractSectionEng = abstractSectionEng;
	}

	/**
	 * Gets the list ws content.
	 *
	 * @return the list ws content
	 */
	public List<WorkspaceContentDV> getListWsContent() {
		return listWsContent;
	}

	/**
	 * Sets the list ws content.
	 *
	 * @param listWsContent the new list ws content
	 */
	public void setListWsContent(List<WorkspaceContentDV> listWsContent) {
		this.listWsContent = listWsContent;
	}

	/**
	 * To string.
	 *
	 * @return the string
	 */
	@Override
	public String toString() {
		StringBuilder builder = new StringBuilder();
		builder.append("AbstractRelazioneScavoDV [abstractSectionIta=");
		builder.append(abstractSectionIta);
		builder.append(", abstractSectionEng=");
		builder.append(abstractSectionEng);
		builder.append(", listWsContent=");
		builder.append(listWsContent);
		builder.append("]");
		return builder.toString();
	}

}
