package org.gcube.application.geoportalcommon.shared.config;

import java.io.Serializable;
import java.util.List;

import org.gcube.application.geoportalcommon.shared.ItemField;


/**
 * The Class ItemFieldsConfig.
 *
 * @author Francesco Mangiacrapa at ISTI-CNR francesco.mangiacrapa@isti.cnr.it
 * 
 * Dec 20, 2021
 */
public class ItemFieldsConfig implements Serializable {

	/**
	 * 
	 */
	private static final long serialVersionUID = 5396430840723300173L;
	private List<ItemField> listItemFieldsConfig = null;

	/**
	 * Instantiates a new item fields config.
	 */
	public ItemFieldsConfig() {
	}

	/**
	 * Instantiates a new item fields config.
	 *
	 * @param listItemFieldsConfig the list item fields config
	 */
	public ItemFieldsConfig(List<ItemField> listItemFieldsConfig) {
		super();
		this.listItemFieldsConfig = listItemFieldsConfig;
	}

	/**
	 * Gets the list item fields config.
	 *
	 * @return the list item fields config
	 */
	public List<ItemField> getListItemFieldsConfig() {
		return listItemFieldsConfig;
	}

	/**
	 * Sets the list item fields config.
	 *
	 * @param listItemFieldsConfig the new list item fields config
	 */
	public void setListItemFieldsConfig(List<ItemField> listItemFieldsConfig) {
		this.listItemFieldsConfig = listItemFieldsConfig;
	}

	/**
	 * To string.
	 *
	 * @return the string
	 */
	@Override
	public String toString() {
		StringBuilder builder = new StringBuilder();
		builder.append("ItemFieldsConfig [listItemFieldsConfig=");
		builder.append(listItemFieldsConfig);
		builder.append("]");
		return builder.toString();
	}

}
