package org.gcube.application.geoportalcommon.shared.products.model;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/**
 * The Class ValidationReportDV.
 *
 * @author Francesco Mangiacrapa at ISTI-CNR francesco.mangiacrapa@isti.cnr.it
 * 
 *         Sep 13, 2021
 */
public class ValidationReportDV implements Serializable {

	/**
	 * 
	 */
	private static final long serialVersionUID = -4579856308279187824L;

	/**
	 * The Enum ValidationStatus.
	 *
	 * @author Francesco Mangiacrapa at ISTI-CNR francesco.mangiacrapa@isti.cnr.it
	 * 
	 *         Sep 13, 2021
	 */
	public static enum ValidationStatus {
		PASSED("OK"), ERROR("Error"), WARNING("Warning");

		private String label;

		private ValidationStatus(String label) {
			this.label = label;
		}

		public String getLabel() {
			return label;
		}
	}

	private String objectName;
	private ValidationStatus status;
	private List<String> errorMessages = new ArrayList<String>();
	private List<String> warningMessages = new ArrayList<String>();
	private String asJSONString;

	/**
	 * Instantiates a new validation report DV.
	 */
	public ValidationReportDV() {

	}

	/**
	 * Instantiates a new validation report DV.
	 *
	 * @param objectName      the object name
	 * @param status          the status
	 * @param errorMessages   the error messages
	 * @param warningMessages the warning messages
	 * @param asJSONString    the as JSON string
	 */
	public ValidationReportDV(String objectName, ValidationStatus status, List<String> errorMessages,
			List<String> warningMessages, String asJSONString) {
		super();
		this.objectName = objectName;
		this.status = status;
		this.errorMessages = errorMessages;
		this.warningMessages = warningMessages;
		this.asJSONString = asJSONString;
	}

	/**
	 * Gets the object name.
	 *
	 * @return the object name
	 */
	public String getObjectName() {
		return objectName;
	}

	/**
	 * Gets the status.
	 *
	 * @return the status
	 */
	public ValidationStatus getStatus() {
		return status;
	}

	/**
	 * Gets the error messages.
	 *
	 * @return the error messages
	 */
	public List<String> getErrorMessages() {
		return errorMessages;
	}

	/**
	 * Gets the warning messages.
	 *
	 * @return the warning messages
	 */
	public List<String> getWarningMessages() {
		return warningMessages;
	}

	/**
	 * Gets the as JSON string.
	 *
	 * @return the as JSON string
	 */
	public String getAsJSONString() {
		return asJSONString;
	}

	/**
	 * Sets the object name.
	 *
	 * @param objectName the new object name
	 */
	public void setObjectName(String objectName) {
		this.objectName = objectName;
	}

	/**
	 * Sets the status.
	 *
	 * @param status the new status
	 */
	public void setStatus(ValidationStatus status) {
		this.status = status;
	}

	/**
	 * Sets the error messages.
	 *
	 * @param errorMessages the new error messages
	 */
	public void setErrorMessages(List<String> errorMessages) {
		this.errorMessages = errorMessages;
	}

	/**
	 * Sets the warning messages.
	 *
	 * @param warningMessages the new warning messages
	 */
	public void setWarningMessages(List<String> warningMessages) {
		this.warningMessages = warningMessages;
	}

	/**
	 * Sets the as JSON string.
	 *
	 * @param asJSONString the new as JSON string
	 */
	public void setAsJSONString(String asJSONString) {
		this.asJSONString = asJSONString;
	}

	/**
	 * To string.
	 *
	 * @return the string
	 */
	@Override
	public String toString() {
		StringBuilder builder = new StringBuilder();
		builder.append("ValidationReportDV [objectName=");
		builder.append(objectName);
		builder.append(", status=");
		builder.append(status);
		builder.append(", errorMessages=");
		builder.append(errorMessages);
		builder.append(", warningMessages=");
		builder.append(warningMessages);
		builder.append(", asJSONString=");
		builder.append(asJSONString);
		builder.append("]");
		return builder.toString();
	}

}
