package org.gcube.application.geoportalcommon.shared.products;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

import org.gcube.application.geoportalcommon.shared.products.content.OtherContentDV;
import org.gcube.application.geoportalcommon.shared.products.model.AbstractRelazioneScavoDV;
import org.gcube.application.geoportalcommon.shared.products.model.LayerConcessioneDV;
import org.gcube.application.geoportalcommon.shared.products.model.RelazioneScavoDV;
import org.gcube.application.geoportalcommon.shared.products.model.UploadedImageDV;
import org.gcube.application.geoportalcommon.shared.products.model.ValidationReportDV;

/**
 * The Class ConcessioneDV.
 *
 * @author Francesco Mangiacrapa at ISTI-CNR (francesco.mangiacrapa@isti.cnr.it)
 * 
 *         Nov 4, 2020
 */
public class ConcessioneDV extends BaseConcessioneDV implements Serializable {

	/**
	 * 
	 */
	private static final long serialVersionUID = 1387327199157005059L;

	/** The descrizione contenuto. */
	private String descrizioneContenuto;

	/** The contributore. */
	private String contributore;

	/** The titolari. */
	private List<String> titolari;

	/** The responsabile. */
	private String responsabile;

	/** The editore. */
	private String editore;

	/** The fonti finanziamento. */
	private List<String> fontiFinanziamento;

	/** The soggetto. */
	private List<String> soggetto;

	/** The risorse correlate. */
	private List<String> risorseCorrelate;

	/** The data inizio progetto. */
	private Date dataInizioProgetto;

	/** The data fine progetto. */
	private Date dataFineProgetto;

	/** The titolare licenza. */
	private List<String> titolariLicenza;

	/** The titolare copyright. */
	private List<String> titolariCopyright;

	/** The parole chiave libere. */
	private List<String> paroleChiaveLibere;

	/** The parole chiave ICCD. */
	private List<String> paroleChiaveICCD;

	/** The centroid lat. */
	private Double centroidLat;

	/** The centroid long. */
	private Double centroidLong;

	/** The relazione scavo. */
	private AbstractRelazioneScavoDV abstractRelazioneScavo;

	/** The relazione scavo. */
	private RelazioneScavoDV relazioneScavo;

	/** The immagini rappresentative. */
	private List<UploadedImageDV> immaginiRappresentative = new ArrayList<UploadedImageDV>();

	/** The posizionamento scavo. */
	private LayerConcessioneDV posizionamentoScavo;

	/** The piante fine scavo. */
	private List<LayerConcessioneDV> pianteFineScavo = new ArrayList<LayerConcessioneDV>();

	/** The generic content. */
	private List<OtherContentDV> genericContent = new ArrayList<OtherContentDV>();

	private ValidationReportDV validationReport = null;

	/**
	 * Instantiates a new concessione.
	 */
	public ConcessioneDV() {

	}

	/**
	 * Gets the descrizione contenuto.
	 *
	 * @return the descrizione contenuto
	 */
	public String getDescrizioneContenuto() {
		return descrizioneContenuto;
	}

	/**
	 * Sets the descrizione contenuto.
	 *
	 * @param descrizioneContenuto the new descrizione contenuto
	 */
	public void setDescrizioneContenuto(String descrizioneContenuto) {
		this.descrizioneContenuto = descrizioneContenuto;
	}

	/**
	 * Gets the contributore.
	 *
	 * @return the contributore
	 */
	public String getContributore() {
		return contributore;
	}

	/**
	 * Sets the contributore.
	 *
	 * @param contributore the new contributore
	 */
	public void setContributore(String contributore) {
		this.contributore = contributore;
	}

	/**
	 * Gets the titolari.
	 *
	 * @return the titolari
	 */
	public List<String> getTitolari() {
		return titolari;
	}

	/**
	 * Sets the titolari.
	 *
	 * @param titolari the new titolari
	 */
	public void setTitolari(List<String> titolari) {
		this.titolari = titolari;
	}

	/**
	 * Gets the responsabile.
	 *
	 * @return the responsabile
	 */
	public String getResponsabile() {
		return responsabile;
	}

	/**
	 * Sets the responsabile.
	 *
	 * @param responsabile the new responsabile
	 */
	public void setResponsabile(String responsabile) {
		this.responsabile = responsabile;
	}

	/**
	 * Gets the editore.
	 *
	 * @return the editore
	 */
	public String getEditore() {
		return editore;
	}

	/**
	 * Sets the editore.
	 *
	 * @param editore the new editore
	 */
	public void setEditore(String editore) {
		this.editore = editore;
	}

	/**
	 * Gets the fonti finanziamento.
	 *
	 * @return the fonti finanziamento
	 */
	public List<String> getFontiFinanziamento() {
		return fontiFinanziamento;
	}

	/**
	 * Sets the fonti finanziamento.
	 *
	 * @param fontiFinanziamento the new fonti finanziamento
	 */
	public void setFontiFinanziamento(List<String> fontiFinanziamento) {
		this.fontiFinanziamento = fontiFinanziamento;
	}

	/**
	 * Gets the soggetto.
	 *
	 * @return the soggetto
	 */
	public List<String> getSoggetto() {
		return soggetto;
	}

	/**
	 * Sets the soggetto.
	 *
	 * @param soggetto the new soggetto
	 */
	public void setSoggetto(List<String> soggetto) {
		this.soggetto = soggetto;
	}

	/**
	 * Gets the risorse correlate.
	 *
	 * @return the risorse correlate
	 */
	public List<String> getRisorseCorrelate() {
		return risorseCorrelate;
	}

	/**
	 * Sets the risorse correlate.
	 *
	 * @param risorseCorrelate the new risorse correlate
	 */
	public void setRisorseCorrelate(List<String> risorseCorrelate) {
		this.risorseCorrelate = risorseCorrelate;
	}

	/**
	 * Gets the data inizio progetto.
	 *
	 * @return the data inizio progetto
	 */
	public Date getDataInizioProgetto() {
		return dataInizioProgetto;
	}

	/**
	 * Sets the data inizio progetto.
	 *
	 * @param dataInizioProgetto the new data inizio progetto
	 */
	public void setDataInizioProgetto(Date dataInizioProgetto) {
		this.dataInizioProgetto = dataInizioProgetto;
	}

	/**
	 * Gets the data fine progetto.
	 *
	 * @return the data fine progetto
	 */
	public Date getDataFineProgetto() {
		return dataFineProgetto;
	}

	/**
	 * Sets the data fine progetto.
	 *
	 * @param date the new data fine progetto
	 */
	public void setDataFineProgetto(Date date) {
		this.dataFineProgetto = date;
	}

	/**
	 * Gets the titolari licenza.
	 *
	 * @return the titolari licenza
	 */
	public List<String> getTitolariLicenza() {
		return titolariLicenza;
	}

	/**
	 * Sets the titolari licenza.
	 *
	 * @param titolariLicenza the new titolari licenza
	 */
	public void setTitolariLicenza(List<String> titolariLicenza) {
		this.titolariLicenza = titolariLicenza;
	}

	/**
	 * Gets the titolari copyright.
	 *
	 * @return the titolari copyright
	 */
	public List<String> getTitolariCopyright() {
		return titolariCopyright;
	}

	/**
	 * Sets the titolari copyright.
	 *
	 * @param titolariCopyright the new titolari copyright
	 */
	public void setTitolariCopyright(List<String> titolariCopyright) {
		this.titolariCopyright = titolariCopyright;
	}

	/**
	 * Gets the parole chiave libere.
	 *
	 * @return the parole chiave libere
	 */
	public List<String> getParoleChiaveLibere() {
		return paroleChiaveLibere;
	}

	/**
	 * Sets the parole chiave libere.
	 *
	 * @param paroleChiaveLibere the new parole chiave libere
	 */
	public void setParoleChiaveLibere(List<String> paroleChiaveLibere) {
		this.paroleChiaveLibere = paroleChiaveLibere;
	}

	/**
	 * Gets the parole chiave ICCD.
	 *
	 * @return the parole chiave ICCD
	 */
	public List<String> getParoleChiaveICCD() {
		return paroleChiaveICCD;
	}

	/**
	 * Sets the parole chiave ICCD.
	 *
	 * @param paroleChiaveICCD the new parole chiave ICCD
	 */
	public void setParoleChiaveICCD(List<String> paroleChiaveICCD) {
		this.paroleChiaveICCD = paroleChiaveICCD;
	}

	/**
	 * Gets the centroid lat.
	 *
	 * @return the centroid lat
	 */
	public Double getCentroidLat() {
		return centroidLat;
	}

	/**
	 * Sets the centroid lat.
	 *
	 * @param centroidLat the new centroid lat
	 */
	public void setCentroidLat(Double centroidLat) {
		this.centroidLat = centroidLat;
	}

	/**
	 * Gets the centroid long.
	 *
	 * @return the centroid long
	 */
	public Double getCentroidLong() {
		return centroidLong;
	}

	/**
	 * Sets the centroid long.
	 *
	 * @param centroidLong the new centroid long
	 */
	public void setCentroidLong(Double centroidLong) {
		this.centroidLong = centroidLong;
	}

	/**
	 * Gets the relazione scavo.
	 *
	 * @return the relazione scavo
	 */
	public RelazioneScavoDV getRelazioneScavo() {
		return relazioneScavo;
	}

	/**
	 * Sets the relazione scavo.
	 *
	 * @param relazioneScavo the new relazione scavo
	 */
	public void setRelazioneScavo(RelazioneScavoDV relazioneScavo) {
		this.relazioneScavo = relazioneScavo;
	}

	/**
	 * Gets the immagini rappresentative.
	 *
	 * @return the immagini rappresentative
	 */
	public List<UploadedImageDV> getImmaginiRappresentative() {
		return immaginiRappresentative;
	}

	/**
	 * Sets the immagini rappresentative.
	 *
	 * @param immaginiRappresentative the new immagini rappresentative
	 */
	public void setImmaginiRappresentative(List<UploadedImageDV> immaginiRappresentative) {
		this.immaginiRappresentative = immaginiRappresentative;
	}

	/**
	 * Gets the posizionamento scavo.
	 *
	 * @return the posizionamento scavo
	 */
	public LayerConcessioneDV getPosizionamentoScavo() {
		return posizionamentoScavo;
	}

	/**
	 * Sets the posizionamento scavo.
	 *
	 * @param posizionamentoScavo the new posizionamento scavo
	 */
	public void setPosizionamentoScavo(LayerConcessioneDV posizionamentoScavo) {
		this.posizionamentoScavo = posizionamentoScavo;
	}

	/**
	 * Gets the piante fine scavo.
	 *
	 * @return the piante fine scavo
	 */
	public List<LayerConcessioneDV> getPianteFineScavo() {
		return pianteFineScavo;
	}

	/**
	 * Sets the piante fine scavo.
	 *
	 * @param pianteFineScavo the new piante fine scavo
	 */
	public void setPianteFineScavo(List<LayerConcessioneDV> pianteFineScavo) {
		this.pianteFineScavo = pianteFineScavo;
	}

	/**
	 * Gets the generic content.
	 *
	 * @return the generic content
	 */
	public List<OtherContentDV> getGenericContent() {
		return genericContent;
	}

	/**
	 * Sets the generic content.
	 *
	 * @param genericContent the new generic content
	 */
	public void setGenericContent(List<OtherContentDV> genericContent) {
		this.genericContent = genericContent;
	}

	/**
	 * Gets the abstract relazione scavo.
	 *
	 * @return the abstract relazione scavo
	 */
	public AbstractRelazioneScavoDV getAbstractRelazioneScavo() {
		return abstractRelazioneScavo;
	}

	/**
	 * Sets the abstract relazione scavo.
	 *
	 * @param abstractRelazioneScavo the new abstract relazione scavo
	 */
	public void setAbstractRelazioneScavo(AbstractRelazioneScavoDV abstractRelazioneScavo) {
		this.abstractRelazioneScavo = abstractRelazioneScavo;
	}

	/**
	 * Gets the validation report.
	 *
	 * @return the validation report
	 */
	public ValidationReportDV getValidationReport() {
		return validationReport;
	}

	/**
	 * Sets the validation report.
	 *
	 * @param validationReport the new validation report
	 */
	public void setValidationReport(ValidationReportDV validationReport) {
		this.validationReport = validationReport;
	}

	/**
	 * To string.
	 *
	 * @return the string
	 */
	@Override
	public String toString() {
		StringBuilder builder = new StringBuilder();
		builder.append("ConcessioneDV [descrizioneContenuto=");
		builder.append(descrizioneContenuto);
		builder.append(", contributore=");
		builder.append(contributore);
		builder.append(", titolari=");
		builder.append(titolari);
		builder.append(", responsabile=");
		builder.append(responsabile);
		builder.append(", editore=");
		builder.append(editore);
		builder.append(", fontiFinanziamento=");
		builder.append(fontiFinanziamento);
		builder.append(", soggetto=");
		builder.append(soggetto);
		builder.append(", risorseCorrelate=");
		builder.append(risorseCorrelate);
		builder.append(", dataInizioProgetto=");
		builder.append(dataInizioProgetto);
		builder.append(", dataFineProgetto=");
		builder.append(dataFineProgetto);
		builder.append(", titolariLicenza=");
		builder.append(titolariLicenza);
		builder.append(", titolariCopyright=");
		builder.append(titolariCopyright);
		builder.append(", paroleChiaveLibere=");
		builder.append(paroleChiaveLibere);
		builder.append(", paroleChiaveICCD=");
		builder.append(paroleChiaveICCD);
		builder.append(", centroidLat=");
		builder.append(centroidLat);
		builder.append(", centroidLong=");
		builder.append(centroidLong);
		builder.append(", abstractRelazioneScavo=");
		builder.append(abstractRelazioneScavo);
		builder.append(", relazioneScavo=");
		builder.append(relazioneScavo);
		builder.append(", immaginiRappresentative=");
		builder.append(immaginiRappresentative);
		builder.append(", posizionamentoScavo=");
		builder.append(posizionamentoScavo);
		builder.append(", pianteFineScavo=");
		builder.append(pianteFineScavo);
		builder.append(", genericContent=");
		builder.append(genericContent);
		builder.append("]");
		return builder.toString();
	}

}
