/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.application.geoportalcommon;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Arrays;
import org.gcube.application.geoportalcommon.GeoNaDataViewerProfileReader;
import org.gcube.application.geoportalcommon.shared.GeoNaDataViewerProfile;
import org.gcube.application.geoportalcommon.shared.GeoNaItemRef;
import org.gcube.application.geoportalcommon.shared.PublicLink;
import org.gcube.portlets.user.urlshortener.UrlShortener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GeoportalCommon {
    private static final Logger LOG = LoggerFactory.getLogger(GeoportalCommon.class);

    public GeoNaItemRef getPublicLinksFor(GeoNaItemRef item) throws Exception {
        LOG.info("getPublicLinksFor called for: " + item);
        try {
            if (item == null) {
                throw new Exception("Bad request, the item is null");
            }
            if (item.getItemId() == null) {
                throw new Exception("Bad request, the item id is null");
            }
            if (item.getItemType() == null) {
                throw new Exception("Bad request, the item type is null");
            }
            GeoNaDataViewerProfile geonaDataProfile = this.getGeoNaDataViewProfile("geoportal-data-viewer-app");
            String link = String.format("%s?%s=%s&%s=%s", geonaDataProfile.getRestrictedPortletURL(), "gid", item.getItemId(), "git", item.getItemType());
            String shortUrl = this.getShortUrl(link);
            item.setRestrictedLink(new PublicLink(link, shortUrl));
            link = String.format("%s?%s=%s&%s=%s", geonaDataProfile.getOpenPortletURL(), "gid", item.getItemId(), "git", item.getItemType());
            shortUrl = this.getShortUrl(link);
            item.setOpenLink(new PublicLink(link, shortUrl));
            LOG.info("returning: " + item);
            return item;
        }
        catch (Exception e) {
            LOG.error("Error on getPublicLinksFor for: " + item, (Throwable)e);
            throw new Exception("Share link not available for this item. Try later or contact the support. Error: " + e.getMessage());
        }
    }

    public GeoNaDataViewerProfile getGeoNaDataViewProfile(String appID) throws Exception {
        LOG.info("getGeoNaDataViewProfile called for: " + appID);
        if (appID == null || appID.isEmpty()) {
            appID = "geoportal-data-viewer-app";
        }
        LOG.info("using AppId: " + appID);
        GeoNaDataViewerProfileReader gdvp = new GeoNaDataViewerProfileReader(appID);
        GeoNaDataViewerProfile profile = gdvp.readProfileFromInfrastrucure();
        LOG.info("Returning profile: " + profile);
        return profile;
    }

    public String getShortUrl(String longUrl) throws Exception {
        LOG.info("getShortUrl called for " + longUrl);
        if (longUrl == null) {
            return longUrl;
        }
        UrlShortener shortener = new UrlShortener();
        try {
            if (shortener != null && shortener.isAvailable()) {
                String toShort = longUrl;
                String[] splitted = toShort.split("\\?");
                LOG.debug("Splitted long URL is: " + Arrays.asList(splitted));
                String link = toShort;
                if (splitted.length > 1) {
                    LOG.debug("Query string detected, encoding it...");
                    String encodedQuery = splitted[1];
                    try {
                        encodedQuery = URLEncoder.encode(splitted[1], "UTF-8");
                    }
                    catch (UnsupportedEncodingException e) {
                        e.printStackTrace();
                    }
                    LOG.debug("encodedQuery is: " + encodedQuery);
                    link = String.format("%s?%s", splitted[0], encodedQuery);
                }
                return shortener.shorten(link);
            }
            return longUrl;
        }
        catch (Exception e) {
            LOG.error("Error on shortening the longURL " + longUrl, (Throwable)e);
            return null;
        }
    }
}

