/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.application.geoportal.common.utils;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.UUID;
import org.gcube.application.geoportal.common.rest.TempFile;
import org.gcube.application.geoportal.common.utils.ContextUtils;
import org.gcube.contentmanagement.blobstorage.service.IClient;
import org.gcube.contentmanagement.blobstorage.transport.backend.RemoteBackendException;
import org.gcube.contentmanager.storageclient.wrapper.AccessType;
import org.gcube.contentmanager.storageclient.wrapper.MemoryType;
import org.gcube.contentmanager.storageclient.wrapper.StorageClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StorageUtils {
    private static final Logger log = LoggerFactory.getLogger(StorageUtils.class);
    private IClient client = StorageUtils.getClient();

    private static final IClient getClient() {
        return new StorageClient("Application", "GeoPortal", ContextUtils.getCurrentCaller(), AccessType.SHARED, MemoryType.VOLATILE).getClient();
    }

    public void forceClose() {
    }

    public TempFile putOntoStorage(InputStream source, String filename) throws RemoteBackendException, FileNotFoundException {
        log.debug("Uploading source " + filename);
        String id = this.client.put(true).LFile(source).RFile(StorageUtils.getUniqueString());
        return new TempFile(id, filename);
    }

    public TempFile putOntoStorage(File source, String filename) throws RemoteBackendException, FileNotFoundException {
        if (source.exists() && source.canRead()) {
            return this.putOntoStorage(new FileInputStream(source), filename);
        }
        throw new FileNotFoundException("Unable to read " + source.getAbsolutePath() + " (" + filename + ")");
    }

    public TempFile[] putOntoStorage(File ... source) throws RemoteBackendException, FileNotFoundException {
        TempFile[] toReturn = new TempFile[source.length];
        for (int i = 0; i < source.length; ++i) {
            toReturn[i] = this.putOntoStorage(source[i], source[i].getName());
        }
        return toReturn;
    }

    public TempFile putOntoStorage(String sourcePath, String filename) throws RemoteBackendException, FileNotFoundException {
        return this.putOntoStorage(new File(sourcePath), filename);
    }

    public void removeById(String id) {
        this.client.remove().RFile(id);
    }

    public String getURL(String id) {
        return this.client.getHttpsUrl().RFile(id);
    }

    public void exists(String id) {
        this.client.exist().RFile(id);
    }

    public static final String getUniqueString() {
        return UUID.randomUUID().toString();
    }
}

