package org.gcube.application.geoportal.common.model.rest;

import java.util.List;

import javax.xml.bind.annotation.XmlRootElement;

import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;
import org.gcube.application.geoportal.common.faults.InvalidRequestException;
import org.gcube.application.geoportal.common.model.legacy.Concessione;
import org.gcube.application.geoportal.common.rest.TempFile;

@XmlRootElement
@Data
@AllArgsConstructor
@NoArgsConstructor
public class AddSectionToConcessioneRequest {

	private String destinationPath;
	private List<TempFile> streams;


	public void validate()throws InvalidRequestException {
		Concessione.Paths.validate(destinationPath);
		if(streams==null || streams.isEmpty()) throw new InvalidRequestException("No Temp File declared");
		for(TempFile t : streams) t.validate();
	}
}
