package org.gcube.application.geoportal.common.model;

import java.util.Collection;
import java.util.Map;
import java.util.Set;

import javax.json.JsonArray;
import javax.json.JsonNumber;
import javax.json.JsonObject;
import javax.json.JsonString;
import javax.json.JsonValue;

import lombok.AllArgsConstructor;
import lombok.Getter;
import lombok.NoArgsConstructor;

@AllArgsConstructor
@NoArgsConstructor
public class BasicJSONObject implements JsonObject {

	@Getter
	private JsonObject theObject;
	
	public String toJson() {
		return getTheObject().toString();
	}
	
	
	@Override
	public int size() {
		return getTheObject().size();
	}

	@Override
	public boolean isEmpty() {
		return getTheObject().isEmpty();
	}

	@Override
	public boolean containsKey(Object key) {
		return getTheObject().containsKey(key);
	}

	@Override
	public boolean containsValue(Object value) {
		return getTheObject().containsValue(value);
	}

	@Override
	public JsonValue get(Object key) {
		return getTheObject().get(key);
	}

	@Override
	public JsonValue put(String key, JsonValue value) {
		return getTheObject().put(key, value);
	}

	@Override
	public JsonValue remove(Object key) {
		return getTheObject().remove(key);
	}

	@Override
	public void putAll(Map<? extends String, ? extends JsonValue> m) {
		getTheObject().putAll(m);
	}

	@Override
	public void clear() {
		getTheObject().clear();
	}

	@Override
	public Set<String> keySet() {
		return getTheObject().keySet();
	}

	@Override
	public Collection<JsonValue> values() {
		return getTheObject().values();
	}

	@Override
	public Set<Entry<String, JsonValue>> entrySet() {
		return getTheObject().entrySet();
	}

	@Override
	public JsonArray getJsonArray(String name) {
		return getTheObject().getJsonArray(name);
	}

	@Override
	public JsonObject getJsonObject(String name) {
		return getTheObject().getJsonObject(name);
	}

	@Override
	public JsonNumber getJsonNumber(String name) {
		return getTheObject().getJsonNumber(name);
	}

	@Override
	public JsonString getJsonString(String name) {
		return getTheObject().getJsonString(name);
	}

	@Override
	public String getString(String name) {
		return getTheObject().getString(name);
	}

	@Override
	public String getString(String name, String defaultValue) {
		return getTheObject().getString(name, defaultValue);
	}

	@Override
	public int getInt(String name) {
		return getTheObject().getInt(name);
	}

	@Override
	public int getInt(String name, int defaultValue) {
		return getTheObject().getInt(name, defaultValue);
	}

	@Override
	public boolean getBoolean(String name) {
		return getTheObject().getBoolean(name);
	}

	@Override
	public boolean getBoolean(String name, boolean defaultValue) {
		return getTheObject().getBoolean(name, defaultValue);
	}

	@Override
	public boolean isNull(String name) {
		return getTheObject().isNull(name);
	}

	@Override
	public ValueType getValueType() {
		return getTheObject().getValueType();
	}

}
