/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.application.geoportal.client;

import java.io.IOException;
import java.rmi.RemoteException;
import java.util.Iterator;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.Response;
import lombok.NonNull;
import org.bson.Document;
import org.gcube.application.geoportal.client.ResponseCommons;
import org.gcube.application.geoportal.client.utils.Serialization;
import org.gcube.application.geoportal.common.faults.InvalidRequestException;
import org.gcube.application.geoportal.common.model.configuration.Configuration;
import org.gcube.application.geoportal.common.model.document.Project;
import org.gcube.application.geoportal.common.model.document.access.Access;
import org.gcube.application.geoportal.common.model.document.relationships.RelationshipNavigationObject;
import org.gcube.application.geoportal.common.model.rest.CreateRelationshipRequest;
import org.gcube.application.geoportal.common.model.rest.DeleteRelationshipRequest;
import org.gcube.application.geoportal.common.model.rest.PerformStepRequest;
import org.gcube.application.geoportal.common.model.rest.QueryRequest;
import org.gcube.application.geoportal.common.model.rest.RegisterFileSetRequest;
import org.gcube.application.geoportal.common.rest.Projects;
import org.gcube.common.clients.Call;
import org.gcube.common.clients.delegates.ProxyDelegate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultDocumentsClient<T extends Project>
implements Projects<T> {
    private static final Logger log = LoggerFactory.getLogger(DefaultDocumentsClient.class);
    @NonNull
    protected final ProxyDelegate<WebTarget> delegate;
    @NonNull
    protected final String profileID;
    @NonNull
    protected final Class<T> managedClass;

    public Class<T> getManagedClass() {
        return this.managedClass;
    }

    public T createNew(Document toCreate) throws RemoteException {
        try {
            log.debug("Creating Profiled Document (class {}, useCaseDescriptor {}) with content {}\u00a0", new Object[]{this.getManagedClass(), this.profileID, toCreate});
            Call call = endpoint -> (Project)ResponseCommons.check(endpoint.path(this.profileID).request(new String[]{"application/json"}).post(Entity.entity((Object)toCreate, (String)"application/json")), this.getManagedClass());
            Project toReturn = (Project)this.delegate.make(call);
            log.info("Registered {} profiled {}\u00a0", (Object)toReturn.getId(), (Object)this.profileID);
            return (T)toReturn;
        }
        catch (RemoteException e) {
            log.error("Unexpected error ", (Throwable)e);
            throw e;
        }
        catch (Exception e) {
            log.error("Unexpected error ", (Throwable)e);
            throw new RemoteException("Unexpected Error", e);
        }
    }

    public void deleteById(String id) throws RemoteException {
        this.deleteById(id, false);
    }

    public void deleteById(String id, Boolean force) throws RemoteException {
        try {
            log.debug("Deleting ID {}\u00a0 useCaseDescriptor {}\u00a0 force {}\u00a0", new Object[]{id, this.profileID, force});
            Call call = endpoint -> (Project)ResponseCommons.check(endpoint.path(this.profileID).path(id).queryParam("force", new Object[]{force}).request(new String[]{"application/json"}).delete(), null);
            this.delegate.make(call);
            log.info("Deleted ID {}\u00a0 useCaseDescriptor {}\u00a0 force {}\u00a0", new Object[]{id, this.profileID, force});
        }
        catch (RemoteException e) {
            log.error("Unexpected error ", (Throwable)e);
            throw e;
        }
        catch (Exception e) {
            log.error("Unexpected error ", (Throwable)e);
            throw new RemoteException("Unexpected Error", e);
        }
    }

    public T getById(String id) throws RemoteException {
        try {
            log.info("Loading Document ID {}\u00a0(class {}, useCaseDescriptor {})", new Object[]{id, this.getManagedClass(), this.profileID});
            Call call = endpoint -> (Project)ResponseCommons.check(endpoint.path(this.profileID).path(id).request(new String[]{"application/json"}).get(), this.getManagedClass());
            return (T)((Project)this.delegate.make(call));
        }
        catch (RemoteException e) {
            log.error("Unexpected error ", (Throwable)e);
            throw e;
        }
        catch (Exception e) {
            log.error("Unexpected error ", (Throwable)e);
            throw new RemoteException("Unexpected Error", e);
        }
    }

    public Configuration getConfiguration() throws RemoteException {
        try {
            log.info("Loading Configuration for useCaseDescriptor {}", (Object)this.profileID);
            Call call = endpoint -> ResponseCommons.check(endpoint.path(this.profileID).path("configuration").request(new String[]{"application/json"}).get(), Configuration.class);
            return (Configuration)this.delegate.make(call);
        }
        catch (RemoteException e) {
            log.error("Unexpected error ", (Throwable)e);
            throw e;
        }
        catch (Exception e) {
            log.error("Unexpected error ", (Throwable)e);
            throw new RemoteException("Unexpected Error", e);
        }
    }

    public Iterator<T> query(QueryRequest request) throws RemoteException {
        return this.queryForClass(request, this.getManagedClass());
    }

    public <C> Iterator<C> queryForClass(QueryRequest request, Class<C> clazz) throws RemoteException {
        String jsonString = this.queryForJSON(request);
        log.debug("Deserializing query Result as {}\u00a0", clazz);
        try {
            return Serialization.readCollection(jsonString, clazz);
        }
        catch (IOException e) {
            log.error("Unable to deserialize result as " + clazz, (Throwable)e);
            log.debug("Query request was {} ", (Object)request);
            log.debug("Query result was {} ", (Object)jsonString);
            throw new RemoteException("Invalid format for submitted query");
        }
    }

    public String queryForJSON(QueryRequest request) throws RemoteException {
        try {
            log.debug("Querying useCaseDescriptor {}\u00a0 for {}", (Object)this.profileID, (Object)request);
            Call call = endpoint -> ResponseCommons.check(endpoint.path(this.profileID).path("query").request(new String[]{"application/json"}).post(Entity.entity((Object)request, (String)"application/json")), String.class);
            return (String)this.delegate.make(call);
        }
        catch (RemoteException e) {
            log.error("Unexpected error ", (Throwable)e);
            throw e;
        }
        catch (Exception e) {
            log.error("Unexpected error ", (Throwable)e);
            throw new RemoteException("Unexpected Error", e);
        }
    }

    public T performStep(String id, PerformStepRequest request) throws RemoteException {
        try {
            log.debug("Executing step on {} (class {}, useCaseDescriptor {}) with request {}\u00a0", new Object[]{id, this.getManagedClass(), this.profileID, request});
            Call call = endpoint -> (Project)ResponseCommons.check(endpoint.path(this.profileID).path("step").path(id).request(new String[]{"application/json"}).post(Entity.entity((Object)request, (String)"application/json")), this.getManagedClass());
            Project toReturn = (Project)this.delegate.make(call);
            log.info("Executed STEP {} on {} [useCaseDescriptor {}, class {}]\u00a0", new Object[]{request.getStepID(), id, this.profileID, this.getManagedClass()});
            return (T)toReturn;
        }
        catch (RemoteException e) {
            log.error("Unexpected error ", (Throwable)e);
            throw e;
        }
        catch (Exception e) {
            log.error("Unexpected error ", (Throwable)e);
            throw new RemoteException("Unexpected Error", e);
        }
    }

    public T registerFileSet(String id, RegisterFileSetRequest req) throws RemoteException, InvalidRequestException {
        try {
            log.debug("Registering FileSet on {} (class {}, useCaseDescriptor {}) with request {}\u00a0", new Object[]{id, this.getManagedClass(), this.profileID, req});
            req.validate();
            Call call = endpoint -> (Project)ResponseCommons.check(endpoint.path(this.profileID).path("registerFiles").path(id).request(new String[]{"application/json"}).post(Entity.entity((Object)req, (String)"application/json")), this.getManagedClass());
            Project toReturn = (Project)this.delegate.make(call);
            log.info("Registered FileSet on {} [useCaseDescriptor {}, class {}]\u00a0 with {}", new Object[]{id, this.profileID, this.getManagedClass(), req});
            return (T)toReturn;
        }
        catch (InvalidRequestException e) {
            log.error("Invalid Request ", (Throwable)e);
            throw e;
        }
        catch (RemoteException e) {
            log.error("Unexpected error ", (Throwable)e);
            throw e;
        }
        catch (Exception e) {
            log.error("Unexpected error ", (Throwable)e);
            throw new RemoteException("Unexpected Error", e);
        }
    }

    public T deleteFileSet(String id, String path, Boolean force, Boolean ignoreErrors) throws RemoteException {
        try {
            log.debug("Deleting Fileset for ID {}\u00a0 [useCaseDescriptor {}\u00a0 , class {}] at {} (force {}\u00a0) (ignoreErrors {}\u00a0)", new Object[]{id, this.profileID, this.getManagedClass(), path, force, ignoreErrors});
            Call call = endpoint -> (Project)ResponseCommons.check(endpoint.path(this.profileID).path("deleteFiles").path(id).queryParam("force", new Object[]{force}).queryParam("ignore_errors", new Object[]{ignoreErrors}).request(new String[]{"application/json"}).post(Entity.entity((Object)path, (String)"application/json")), this.getManagedClass());
            Project toReturn = (Project)this.delegate.make(call);
            log.info("Deleted ID {}\u00a0 useCaseDescriptor {}\u00a0 force {}\u00a0", new Object[]{id, this.profileID, force});
            return (T)toReturn;
        }
        catch (RemoteException e) {
            log.error("Unexpected error ", (Throwable)e);
            throw e;
        }
        catch (Exception e) {
            log.error("Unexpected error ", (Throwable)e);
            throw new RemoteException("Unexpected Error", e);
        }
    }

    public T forceUnlock(String id) throws RemoteException {
        try {
            log.warn("Force Unlock of {} [useCaseDescriptor {} , class {}]", new Object[]{id, this.profileID, this.getManagedClass()});
            Call call = endpoint -> (Project)ResponseCommons.check(endpoint.path(this.profileID).path("forceUnlock").path(id).request(new String[]{"application/json"}).put(Entity.json((Object)"")), this.getManagedClass());
            Project toReturn = (Project)this.delegate.make(call);
            log.info("Unlocked ID {} useCaseDescriptor {}", (Object)id, (Object)this.profileID);
            return (T)toReturn;
        }
        catch (RemoteException e) {
            log.error("Unexpected error ", (Throwable)e);
            throw e;
        }
        catch (Exception e) {
            log.error("Unexpected error ", (Throwable)e);
            throw new RemoteException("Unexpected Error", e);
        }
    }

    public T setAccessPolicy(String id, Access toSet) throws RemoteException {
        try {
            log.info("Setting Access of {} [useCaseDescriptor {} , class {}] as {}", new Object[]{id, this.profileID, this.getManagedClass(), toSet});
            Call call = endpoint -> (Project)ResponseCommons.check(endpoint.path(this.profileID).path("setAccess").path(id).request(new String[]{"application/json"}).put(Entity.json((Object)toSet)), this.getManagedClass());
            Project toReturn = (Project)this.delegate.make(call);
            log.debug("Updated Access of ID {} useCaseDescriptor {}", (Object)id, (Object)this.profileID);
            return (T)toReturn;
        }
        catch (RemoteException e) {
            log.error("Unexpected error ", (Throwable)e);
            throw e;
        }
        catch (Exception e) {
            log.error("Unexpected error ", (Throwable)e);
            throw new RemoteException("Unexpected Error", e);
        }
    }

    public T updateDocument(String id, Document updatedDocument) throws RemoteException {
        try {
            log.debug("Updating {} [useCaseDescriptor {} , class {}] with ", new Object[]{id, this.profileID, this.getManagedClass(), updatedDocument});
            Call call = endpoint -> (Project)ResponseCommons.check(endpoint.path(this.profileID).path(id).request(new String[]{"application/json"}).put(Entity.entity((Object)updatedDocument, (String)"application/json")), this.getManagedClass());
            Project toReturn = (Project)this.delegate.make(call);
            log.info("Updated ID {} useCaseDescriptor {}", (Object)id, (Object)this.profileID);
            return (T)toReturn;
        }
        catch (RemoteException e) {
            log.error("Unexpected error ", (Throwable)e);
            throw e;
        }
        catch (Exception e) {
            log.error("Unexpected error ", (Throwable)e);
            throw new RemoteException("Unexpected Error", e);
        }
    }

    public T patchDocument(String id, String path, Document updatedDocument) throws RemoteException {
        try {
            log.debug("Patching {} [useCaseDescriptor {} , class {}] with ", new Object[]{id, this.profileID, this.getManagedClass(), updatedDocument});
            Call call = endpoint -> {
                WebTarget webTarget = endpoint.path(this.profileID).path(id);
                webTarget.queryParam("path", new Object[]{path});
                webTarget.property("jersey.config.client.httpUrlConnection.setMethodWorkaround", (Object)true);
                Response response = webTarget.request(new String[]{"application/json"}).method("PATCH", Entity.entity((Object)updatedDocument, (String)"application/json"));
                return (Project)ResponseCommons.check(response, this.getManagedClass());
            };
            Project toReturn = (Project)this.delegate.make(call);
            log.info("Updated ID {} useCaseDescriptor {}", (Object)id, (Object)this.profileID);
            return (T)toReturn;
        }
        catch (RemoteException e) {
            log.error("Unexpected error ", (Throwable)e);
            throw e;
        }
        catch (Exception e) {
            log.error("Unexpected error ", (Throwable)e);
            throw new RemoteException("Unexpected Error", e);
        }
    }

    public Project setRelation(CreateRelationshipRequest request) throws RemoteException {
        try {
            log.debug("Setting relationship {}:{} --{}--> {}:{}", new Object[]{this.profileID, request.getProjectId(), request.getRelationshipId(), request.getTargetUCD(), request.getTargetId()});
            Call call = endpoint -> (Project)ResponseCommons.check(endpoint.path(this.profileID).path("relationship").path(request.getProjectId()).path(request.getRelationshipId()).queryParam("target_id", new Object[]{request.getTargetId()}).queryParam("target_ucd", new Object[]{request.getTargetUCD()}).request(new String[]{"application/json"}).put(Entity.json((Object)"")), this.getManagedClass());
            Project toReturn = (Project)this.delegate.make(call);
            log.info("Set relationship {}:{} --{}--> {}:{}", new Object[]{this.profileID, request.getProjectId(), request.getRelationshipId(), request.getTargetUCD(), request.getTargetId()});
            return toReturn;
        }
        catch (RemoteException e) {
            log.error("Unexpected error ", (Throwable)e);
            throw e;
        }
        catch (Exception e) {
            log.error("Unexpected error ", (Throwable)e);
            throw new RemoteException("Unexpected Error", e);
        }
    }

    public Project deleteRelation(DeleteRelationshipRequest request) throws RemoteException {
        try {
            log.debug("Deleting relationship {}:{} --{}--> {}:{}", new Object[]{this.profileID, request.getProjectId(), request.getRelationshipId(), request.getTargetUCD(), request.getTargetId()});
            Call call = endpoint -> (Project)ResponseCommons.check(endpoint.path(this.profileID).path("relationship").path(request.getProjectId()).path(request.getRelationshipId()).queryParam("target_id", new Object[]{request.getTargetId()}).queryParam("target_ucd", new Object[]{request.getTargetUCD()}).request(new String[]{"application/json"}).delete(), this.getManagedClass());
            Project toReturn = (Project)this.delegate.make(call);
            log.info("Deleted relationship {}:{} --{}--> {}:{}", new Object[]{this.profileID, request.getProjectId(), request.getRelationshipId(), request.getTargetUCD(), request.getTargetId()});
            return toReturn;
        }
        catch (RemoteException e) {
            log.error("Unexpected error ", (Throwable)e);
            throw e;
        }
        catch (Exception e) {
            log.error("Unexpected error ", (Throwable)e);
            throw new RemoteException("Unexpected Error", e);
        }
    }

    public Iterator<RelationshipNavigationObject> getRelationshipChain(String id, String relationId) throws RemoteException {
        return this.getRelationshipChain(id, relationId, null);
    }

    public Iterator<RelationshipNavigationObject> getRelationshipChain(String id, String relationId, Boolean deep) throws RemoteException {
        try {
            log.debug("Get relationship chain ID {} for {} [useCaseDescriptor {} , class {}]", new Object[]{relationId, id, this.profileID, this.getManagedClass()});
            Call call = endpoint -> {
                WebTarget target = endpoint.path(this.profileID).path("relationship").path(id).path(relationId);
                if (deep != null) {
                    target = target.queryParam("deep", new Object[]{deep});
                }
                String jsonChain = ResponseCommons.check(target.request(new String[]{"application/json"}).get(), String.class);
                return Serialization.readCollection(jsonChain, RelationshipNavigationObject.class);
            };
            return (Iterator)this.delegate.make(call);
        }
        catch (RemoteException e) {
            log.error("Unexpected error ", (Throwable)e);
            throw e;
        }
        catch (Exception e) {
            log.error("Unexpected error ", (Throwable)e);
            throw new RemoteException("Unexpected Error", e);
        }
    }

    public DefaultDocumentsClient(@NonNull ProxyDelegate<WebTarget> delegate, @NonNull String profileID, @NonNull Class<T> managedClass) {
        if (delegate == null) {
            throw new NullPointerException("delegate is marked @NonNull but is null");
        }
        if (profileID == null) {
            throw new NullPointerException("profileID is marked @NonNull but is null");
        }
        if (managedClass == null) {
            throw new NullPointerException("managedClass is marked @NonNull but is null");
        }
        this.delegate = delegate;
        this.profileID = profileID;
        this.managedClass = managedClass;
    }
}

