package org.gcube.application.geoportal.client.legacy;

import java.io.FileNotFoundException;
import java.util.ArrayList;

import javax.ws.rs.client.WebTarget;

import org.gcube.application.geoportal.client.DefaultMongoConcessioni;
import org.gcube.application.geoportal.common.model.legacy.Concessione;
import org.gcube.application.geoportal.common.model.legacy.Concessione.Paths;
import org.gcube.application.geoportal.common.model.legacy.InputStreamDescriptor;
import org.gcube.application.geoportal.common.model.legacy.LayerConcessione;
import org.gcube.application.geoportal.common.model.legacy.RelazioneScavo;
import org.gcube.application.geoportal.common.model.legacy.UploadedImage;
import org.gcube.application.geoportal.common.model.rest.AddSectionToConcessioneRequest;
import org.gcube.application.geoportal.common.rest.TempFile;
import org.gcube.application.geoportal.common.utils.StorageUtils;
import org.gcube.common.clients.delegates.ProxyDelegate;
import org.gcube.contentmanagement.blobstorage.transport.backend.RemoteBackendException;


public class StatefulMongoConcessioni extends DefaultMongoConcessioni implements ConcessioniManagerI{

	
	
	public StatefulMongoConcessioni(ProxyDelegate<WebTarget> delegate) {
		super(delegate);
	}

	private Concessione currentC=null;
	private StorageUtils storage=new StorageUtils();


	// Override methods to handle state
	@Override
	public Concessione createNew(Concessione c) throws Exception {
		currentC=super.createNew(c);
		return currentC;
	}

	@Override
	public Concessione getById(String id) throws Exception {
		currentC= super.getById(id);
		return currentC;
	}

	@Override
	public Concessione publish() throws Exception {
		if(currentC==null) throw new Exception("Invalid operation : current Concessione is null.");
		currentC=super.publish(currentC.getMongo_id());
		return currentC;
	}

	
	@Override
	public void delete() throws Exception {
		if(currentC==null) throw new Exception("Invalid operation : current Concessione is null.");
		super.deleteById(currentC.getMongo_id());
		currentC=null;
	}

	@Override
	public Concessione addImmagineRappresentativa(UploadedImage toAdd, TempFile f) throws Exception {
		if(currentC==null) throw new Exception("Invalid operation : current Concessione is null.");
		if(currentC.getImmaginiRappresentative()==null) currentC.setImmaginiRappresentative(new ArrayList<UploadedImage>());
		currentC.getImmaginiRappresentative().add(toAdd);
		currentC=replace(currentC);
		
		
		currentC=super.registerFile(currentC.getMongo_id(), 
				request(Paths.imgByIndex(currentC.getImmaginiRappresentative().size()-1),f));
		return currentC;
	}

	@Override
	public Concessione addPiantaFineScavo(LayerConcessione toAdd, TempFile... files) throws Exception {
		if(currentC==null) throw new Exception("Invalid operation : current Concessione is null.");
		if(currentC.getPianteFineScavo()==null) currentC.setPianteFineScavo(new ArrayList<>());
		currentC.getPianteFineScavo().add(toAdd);
		currentC=replace(currentC);
		
		
		currentC=super.registerFile(currentC.getMongo_id(), 
				request(Paths.piantaByIndex(currentC.getPianteFineScavo().size()-1),files));
		return currentC;
	}

	@Override
	public Concessione setPosizionamento(LayerConcessione toSet, TempFile... files) throws Exception {
		if(currentC==null) throw new Exception("Invalid operation : current Concessione is null.");
		currentC.setPosizionamentoScavo(toSet);
		currentC=replace(currentC);
		
		
		currentC=super.registerFile(currentC.getMongo_id(), 
				request(Paths.POSIZIONAMENTO,files));
		return currentC;
	}

	@Override
	public Concessione setRelazioneScavo(RelazioneScavo toSet, TempFile f) throws Exception {
		if(currentC==null) throw new Exception("Invalid operation : current Concessione is null.");
		currentC.setRelazioneScavo(toSet);
		currentC=replace(currentC);
		
		
		currentC=super.registerFile(currentC.getMongo_id(), 
				request(Paths.RELAZIONE,f));
		return currentC;
	}



	@Override
	public Concessione addImmagineRappresentativa(UploadedImage toAdd, InputStreamDescriptor f) throws Exception {
		return addImmagineRappresentativa(toAdd,asTemp(f));
	}

	@Override
	public Concessione addPiantaFineScavo(LayerConcessione toAdd, InputStreamDescriptor... files) throws Exception {
		return addPiantaFineScavo(toAdd, asTemp(files));
	}

	@Override
	public Concessione setPosizionamento(LayerConcessione toSet, InputStreamDescriptor... files) throws Exception {
		return setPosizionamento(toSet,asTemp(files));
	}

	@Override
	public Concessione setRelazioneScavo(RelazioneScavo toSet, InputStreamDescriptor f) throws Exception {
		return setRelazioneScavo(toSet,asTemp(f));
	}





	protected static AddSectionToConcessioneRequest request(String path, TempFile...files) {
		AddSectionToConcessioneRequest req=new AddSectionToConcessioneRequest();
		req.setDestinationPath(path);
		req.setStreams(new ArrayList<TempFile>());
		for(TempFile f:files)
			req.getStreams().add(f);
		return req;
	}

	protected TempFile asTemp(InputStreamDescriptor descriptor) throws RemoteBackendException, FileNotFoundException {
		return storage.putOntoStorage(descriptor.getStream(), descriptor.getFilename());
	}

	protected TempFile[] asTemp(InputStreamDescriptor... descriptors) throws RemoteBackendException, FileNotFoundException {
		ArrayList<TempFile> toReturn=new ArrayList<TempFile>();
		for(InputStreamDescriptor desc:descriptors)
			toReturn.add(storage.putOntoStorage(desc.getStream(), desc.getFilename()));
		return toReturn.toArray(new TempFile[toReturn.size()]);
	}
}
