package org.gcube.application.geoportal.client.legacy;

import static  org.gcube.application.geoportal.client.GeoportalAbstractPlugin.concessioni;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;

import javax.json.Json;
import javax.json.JsonArray;

import org.gcube.application.geoportal.common.model.legacy.Concessione;
import org.gcube.application.geoportal.common.rest.ConcessioniI;

import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectReader;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;

import lombok.extern.slf4j.Slf4j;

@Slf4j
public class ConcessioniManager {

	private static ObjectMapper mapper = new ObjectMapper();

	private static ObjectReader concessioniReader=mapper.readerFor(Concessione.class);
	private static ObjectReader collectionReader=mapper.readerFor(Collection.class);
	
	static {
		mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES,false);
		mapper.configure(SerializationFeature.WRITE_EMPTY_JSON_ARRAYS, false);
		mapper.setSerializationInclusion(Include.NON_NULL);
		//		mapper.configure(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS, false);
		mapper.registerModule(new JavaTimeModule());
		mapper.configure(SerializationFeature.INDENT_OUTPUT, true);
	}

	private ConcessioniI service;
	
	public ConcessioniManager() {
		service=concessioni().build();
	}
	
	public Concessione getById(String id) throws Exception {
		log.info("Reading by ID "+id);
		try {
			String result=service.readById(id);
			log.debug("Reading json object : "+result);
			return concessioniReader.readValue(result);
		} catch (IOException e) {
			e.printStackTrace();
			throw e;
		} catch (Exception e) {
			e.printStackTrace();
			throw e;
		}
	}

	public static String toJson(Object obj) throws JsonProcessingException {
		return mapper.writeValueAsString(obj);
	}
	
	
	public ArrayList<Concessione> getList() throws Exception{
		log.info("Getting list");
		try {
			String result=service.getAll();
			log.debug("Reading json object : "+result);
			JsonArray array=Json.createReader(new ByteArrayInputStream(result.getBytes(StandardCharsets.UTF_8))).readArray();
			ArrayList<Concessione> toReturn=new ArrayList<Concessione>();
			for(int i=0;i<array.size();i++)
				toReturn.add(concessioniReader.readValue(array.get(i).toString()));
			return toReturn;
		} catch (IOException e) {
			e.printStackTrace();
			throw e;
		} catch (Exception e) {
			e.printStackTrace();
			throw e;
		}
	}

}
