/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.application.reporting.component;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.gcube.application.reporting.Property;
import org.gcube.application.reporting.component.AbstractComponent;
import org.gcube.application.reporting.component.Box;
import org.gcube.application.reporting.component.interfaces.IsMedia;
import org.gcube.application.reporting.component.interfaces.IsSequentiable;
import org.gcube.application.reporting.component.interfaces.ReportComponent;
import org.gcube.application.reporting.component.type.ReportComponentType;
import org.gcube.portlets.d4sreporting.common.shared.Attribute;
import org.gcube.portlets.d4sreporting.common.shared.AttributeArea;
import org.gcube.portlets.d4sreporting.common.shared.BasicComponent;
import org.gcube.portlets.d4sreporting.common.shared.ComponentType;

public class BoxesArea
extends AbstractComponent
implements IsSequentiable,
IsMedia {
    private String name;
    private List<Box> values;
    boolean multiSelectionEnabled;

    public BoxesArea(String name, List<Box> values, boolean allowMultiselection) {
        this.name = name;
        this.values = values;
        this.multiSelectionEnabled = allowMultiselection;
        this.setProperties(new Property("display", "block"));
    }

    public boolean isMultiSelectionEnabled() {
        return this.multiSelectionEnabled;
    }

    @Override
    public ReportComponentType getType() {
        return ReportComponentType.BOXAREA;
    }

    @Override
    public boolean hasChildren() {
        return true;
    }

    @Override
    public List<ReportComponent> getChildren() {
        ArrayList<ReportComponent> toReturn = new ArrayList<ReportComponent>();
        toReturn.addAll(this.values);
        return toReturn;
    }

    @Override
    public String getStringValue() {
        return this.name;
    }

    @Override
    public BasicComponent getModelComponent() {
        ArrayList<Attribute> toCreate = new ArrayList<Attribute>();
        for (Box attr : this.values) {
            Attribute toAdd = new Attribute(attr.getName(), attr.isSelected());
            toAdd.setOptionalValue(attr.getId());
            toCreate.add(toAdd);
        }
        Attribute defaultAttr = new Attribute("Not applicable", Boolean.valueOf(false));
        toCreate.add(defaultAttr);
        ComponentType type = this.multiSelectionEnabled ? ComponentType.ATTRIBUTE_MULTI : ComponentType.ATTRIBUTE_UNIQUE;
        BasicComponent bc = new BasicComponent(0, 0, 700, 35, 1, type, "", (Serializable)new AttributeArea(this.name, toCreate), false, false, this.convertProperties());
        bc.setId(this.getId());
        return bc;
    }

    public String toString() {
        return "BoxesArea [name=" + this.name + ", values=" + this.values + ", multiSelectionEnabled=" + this.multiSelectionEnabled + "]";
    }
}

