package org.gcube.application.reporting.component;

import java.util.List;

import org.gcube.application.reporting.component.type.ReportComponentType;
import org.gcube.portlets.d4sreporting.common.shared.BasicComponent;

public class Box extends AbstractComponent {
	/**
	 * 	
	 */
	private String name;
	/**
	 * 
	 */
	private Boolean selected;
	
	private Boolean isMultiSelectionAllowed;
	
	public Box(String name, Boolean selected) {
		this.name = name;
		this.selected = selected;
	}

	public Box(String id, String name, Boolean selected, Boolean isMultiSelectionAllowed) {
		super();
		setId(id);
		this.name = name;
		this.selected = selected;
		this.isMultiSelectionAllowed = isMultiSelectionAllowed;
	}
	
	public Box(String name, Boolean selected, Boolean isMultiSelectionAllowed) {
		super();
		this.name = name;
		this.selected = selected;
		this.isMultiSelectionAllowed = isMultiSelectionAllowed;
	}
	
	public String getName() {
		return name;
	}

	public Boolean isSelected() {
		return selected;
	}

	@Override
	public ReportComponentType getType() {
		return isMultiSelectionAllowed ? ReportComponentType.CHECKBOX : ReportComponentType.RADIOBUTTON;
	}
	@Override
	public boolean hasChildren() {
		return false;
	}
	@Override
	public List<ReportComponent> getChildren() {
		return null;
	}
	@Override
	public String getStringValue() {
		return ""+selected;
	}

	@Override
	public BasicComponent getModelComponent() {
		// TODO Auto-generated method stub
		return null;
	}
}
