/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.application.reporting.persistence;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.UUID;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;
import org.apache.commons.io.IOUtils;
import org.gcube.portlets.d4sreporting.common.shared.BasicComponent;
import org.gcube.portlets.d4sreporting.common.shared.BasicSection;
import org.gcube.portlets.d4sreporting.common.shared.ComponentType;
import org.gcube.portlets.d4sreporting.common.shared.Model;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PersistenceManager {
    private static final Logger _log = LoggerFactory.getLogger(PersistenceManager.class);

    public static boolean writeModel(Model model) {
        try {
            File tempDir = File.createTempFile(UUID.randomUUID().toString(), "");
            tempDir.delete();
            tempDir.mkdir();
            File temp = new File(tempDir + File.separator + model.getTemplateName() + ".d4st");
            return PersistenceManager.writeModel(model, temp);
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
    }

    public static boolean writeModel(Model model, File modelInstanceFile) {
        model.setCurrPage(1);
        FileOutputStream fos = null;
        ObjectOutputStream out = null;
        try {
            fos = new FileOutputStream(modelInstanceFile);
            out = new ObjectOutputStream(fos);
            out.writeObject(model);
            out.close();
            _log.trace("Trying to zip folder: " + modelInstanceFile.getParent());
            String folderToZip = modelInstanceFile.getParent();
            String outZip = String.valueOf(modelInstanceFile.getParent()) + ".d4sR";
            PersistenceManager.zipDir(outZip, folderToZip);
            _log.trace("gCube Modeler Model Instance Persisted: " + outZip);
            return true;
        }
        catch (IOException ex) {
            ex.printStackTrace();
            return false;
        }
    }

    public static Model readModel(String pathToModel) {
        Model toRead = null;
        FileInputStream fis = null;
        ObjectInputStream in = null;
        try {
            fis = new FileInputStream(pathToModel);
            in = new ObjectInputStream(fis);
            toRead = (Model)in.readObject();
            in.close();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        _log.debug("Scanning model instance with id: " + toRead.getUniqueID());
        int i = 1;
        for (BasicSection sec : toRead.getSections()) {
            _log.debug("Section " + i);
            for (BasicComponent bc : sec.getComponents()) {
                if (bc.getType() == ComponentType.FAKE_TEXTAREA) continue;
                _log.debug(bc.getType() + "-" + bc.getPossibleContent());
            }
            ++i;
        }
        return toRead;
    }

    public static void zipDir(String zipFileName, String dir) throws IOException {
        File dirObj = new File(dir);
        if (!dirObj.isDirectory()) {
            _log.error(String.valueOf(dir) + " is not a directory");
            System.exit(1);
        }
        ZipOutputStream out = new ZipOutputStream(new FileOutputStream(zipFileName));
        System.out.println("Creating : " + zipFileName);
        PersistenceManager.addDir(dirObj, out);
        out.close();
    }

    private static void addDir(File dirObj, ZipOutputStream out) throws IOException {
        File[] files = dirObj.listFiles();
        byte[] tmpBuf = new byte[1024];
        int i = 0;
        while (i < files.length) {
            if (files[i].isDirectory()) {
                PersistenceManager.addDir(files[i], out);
            } else {
                int len;
                FileInputStream in = new FileInputStream(files[i].getAbsolutePath());
                _log.trace(" Adding: " + files[i].getAbsolutePath());
                String filename = files[i].getName();
                out.putNextEntry(new ZipEntry(filename));
                while ((len = in.read(tmpBuf)) > 0) {
                    out.write(tmpBuf, 0, len);
                }
                out.closeEntry();
                in.close();
            }
            ++i;
        }
    }

    public static void unzipArchive(File archive, File outputDir) {
        try {
            ZipFile zipfile = new ZipFile(archive);
            Enumeration<? extends ZipEntry> e = zipfile.entries();
            while (e.hasMoreElements()) {
                ZipEntry entry = e.nextElement();
                PersistenceManager.unzipEntry(zipfile, entry, outputDir);
            }
        }
        catch (Exception e) {
            _log.error("Error while extracting file " + archive);
        }
    }

    private static void unzipEntry(ZipFile zipfile, ZipEntry entry, File outputDir) throws IOException {
        if (entry.isDirectory()) {
            PersistenceManager.createDir(new File(outputDir, entry.getName()));
            return;
        }
        File outputFile = new File(outputDir, entry.getName());
        if (!outputFile.getParentFile().exists()) {
            PersistenceManager.createDir(outputFile.getParentFile());
        }
        _log.trace("Extracting: " + entry);
        BufferedInputStream inputStream = new BufferedInputStream(zipfile.getInputStream(entry));
        BufferedOutputStream outputStream = new BufferedOutputStream(new FileOutputStream(outputFile));
        try {
            IOUtils.copy((InputStream)inputStream, (OutputStream)outputStream);
        }
        finally {
            outputStream.close();
            inputStream.close();
        }
    }

    private static void createDir(File dir) {
        _log.trace("Creating dir " + dir.getName());
        if (!dir.mkdirs()) {
            throw new RuntimeException("Can not create dir " + dir);
        }
    }
}

