package org.gcube.application.reporting.reference;

import java.util.ArrayList;
import java.util.List;

import org.gcube.portlets.d4sreporting.common.shared.Tuple;
import org.gcube.portlets.d4sreporting.common.shared.Metadata;

/**
 * 
 * @author Massimiliano Assante, ISTI-CNR - massimiliano.assante@isti.cnr.it
 * an abstraction over {@link Tuple} 
 */
public class DBTableRow {
	
	private String identifier;
	private ArrayList<Metadata> metadata;
	private int level;
	
	/**
	 * 
	 * @param identifier the identifier ia a String value that identifies the DBTableRow
	 * @param metadata the metadata (attribute, value) to show once selected
	 */
	public DBTableRow(String identifier, ArrayList<Metadata> metadata) {
		super();
		this.identifier = identifier;
		this.metadata = metadata;
		this.level = 2;
	}
	
	/**
	 * 
	 * @param metadata the metadata (attribute, value) to show once selected
	 */
	public DBTableRow(ArrayList<Metadata> metadata) {
		this(metadata.get(0).getValue(), metadata);
	}

	public String getIdentifier() {
		return identifier;
	}

	public void setIdentifier(String identifier) {
		this.identifier = identifier;
	}

	public List<Metadata> getMetadata() {
		return metadata;
	}

	public void setMetadata(ArrayList<Metadata> metadata) {
		this.metadata = metadata;
	}

	public int getHeadingLevel() {
		return level;
	}

	public void setHeadingLevel(int level) {
		this.level = level;
	}

	
	
}
