package org.gcube.application.reporting;

import java.util.ArrayList;
import java.util.List;

import org.gcube.application.reporting.reference.DBTableRow;
import org.gcube.portlets.d4sreporting.common.shared.Attribute;
import org.gcube.portlets.d4sreporting.common.shared.Tuple;


public interface Modeler {
	/**
	 * add an empty fillable title
	 * @return true if the operation is performed with success, false otherwise
	 */
	boolean addTitle();
	/**
	 * 
	 * @param content the content you want to show in the title
	 * @param isReadonly tells wether the user can edit the content ot not
	 * @return true if the operation is performed with success, false otherwise
	 */
	boolean addTitle(String content, boolean isReadonly);
	/**
	 * add an empty fillable heading
	 * @param level of the heading
	 * @return true if the operation is performed with success, false otherwise
	 * @throws IllegalArgumentException if the heading is not [1, 5]
	 */
	boolean addHeading(int level) throws IllegalArgumentException;
	/**
	 * add an heading with a non editable content
	 * @param level of the heading
	 * @param content the content you want to show in the heading
	 * @return true if the operation is performed with success, false otherwise
	 * @throws IllegalArgumentException if the heading is not [1, 5]
	 */
	boolean addHeading(int level, String content) throws IllegalArgumentException;
	/**
	 * 
	 * @param level of the heading
	 * @param content the content you want to show in the heading
	 * @param isReadonly tells wether the user can edit the content ot not
	 * @return true if the operation is performed with success, false otherwise
	 * @throws IllegalArgumentException if the heading is not [1, 5]
	 */
	boolean addHeading(int level, String content, boolean isReadonly) throws IllegalArgumentException;
	/**
	 * add an empty fillable text input
	 * @return true if the operation is performed with success, false otherwise
	 */
	boolean addTextInput();
	/**
	 * add a text input with some pre entered text
	 * @param content the content you want to show in the textbox
	 * @return true if the operation is performed with success, false otherwise
	 */
	boolean addTextInput(String content);
	/**
	 * add text input
	 * @param content the content you want to show in the textbox
	 * @param isReadonly tells wether the user can edit the content ot not
	 * @return true if the operation is performed with success, false otherwise
	 */
	boolean addTextInput(String content, boolean isReadonly);
	/**
	 * add an instruction
	 * @param content the content you want to show in the instruction
	 * @return true if the operation is performed with success, false otherwise
	 */
	boolean addInstruction(String content);
	/**
	 * Add a attribute component to the model instance, allow to specify if is editable or not
	 * @param type the type of the component
	 * @param payload the payload, a text if is a heading or body, an encoded base64 string if an image and so on
	 * @param isEditable allow the component to be edited or not
	 */ 
	boolean addAttributeComponent(String attrName, ArrayList<Attribute> values, boolean allowMultiselection) ;
	/**
	 * add the references
	 * @param list of @see {@link Tuple} 
	 * @return true if the operation is performed with success, false otherwise
	 */
	boolean addReference(List<DBTableRow> dBTableRows);
	/**
	 * add the possibility to enter text, table or images in the report
	 * @return
	 */
	boolean addMedia();
	/**
	 * add a section, every add will point to this new section
	 * @return the index of the new section
	 */
	int nextSection();

}
