/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.application.reporting;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.Vector;
import org.gcube.application.reporting.Modeler;
import org.gcube.application.reporting.reference.DBTableRow;
import org.gcube.portlets.d4sreporting.common.shared.Attribute;
import org.gcube.portlets.d4sreporting.common.shared.AttributeArea;
import org.gcube.portlets.d4sreporting.common.shared.BasicComponent;
import org.gcube.portlets.d4sreporting.common.shared.BasicSection;
import org.gcube.portlets.d4sreporting.common.shared.ComponentType;
import org.gcube.portlets.d4sreporting.common.shared.Metadata;
import org.gcube.portlets.d4sreporting.common.shared.Model;
import org.gcube.portlets.d4sreporting.common.shared.Tuple;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ReportsModeler
implements Modeler {
    private static final Logger _log = LoggerFactory.getLogger(ReportsModeler.class);
    public static final int TEMPLATE_WIDTH = 750;
    public static final int TEMPLATE_HEIGHT = 1000;
    public static final String DEFAULT_NAME = "no-name";
    private static final int MARGIN_LEFT = 0;
    private static final int MARGIN_RIGHT = 0;
    private static final int MARGIN_TOP = 0;
    private static final int MARGIN_BOTTOM = 0;
    private static final int COLUMN_WIDTH = 0;
    private static final int COMP_WIDTH = 700;
    private static final int COMP_HEIGHT = 35;
    private int currSection = 1;
    private Model model;

    public ReportsModeler(String id, String name, String author, Date dateCreated, Date lastEdit, String lastEditorId) {
        this.model = new Model(id, author, dateCreated, lastEdit, lastEditorId, name, 0, 1, 0, 0, 0, 0, 1000, 750, new Vector(), 1, new LinkedList());
        this.initialize();
    }

    @Override
    public boolean addTitle() {
        this.addTitle("", false);
        return false;
    }

    @Override
    public boolean addTitle(String content, boolean isReadonly) {
        BasicComponent bc = new BasicComponent(0, 0, 700, 35, 1, ComponentType.TITLE, "", (Serializable)((Object)content), false, isReadonly, new ArrayList());
        this.addComponentToSection(bc);
        return true;
    }

    @Override
    public boolean addHeading(int level) {
        return this.addHeading(level, "", false);
    }

    @Override
    public boolean addHeading(int level, String content) {
        return this.addHeading(level, content, true);
    }

    @Override
    public boolean addHeading(int level, String content, boolean isReadonly) {
        this.addComponentToSection(this.getHeading(level, content, isReadonly));
        return true;
    }

    private BasicComponent getHeading(int level, String content, boolean isReadonly) {
        ComponentType type;
        switch (level) {
            case 1: {
                type = ComponentType.HEADING_1;
                break;
            }
            case 2: {
                type = ComponentType.HEADING_2;
                break;
            }
            case 3: {
                type = ComponentType.HEADING_3;
                break;
            }
            case 4: {
                type = ComponentType.HEADING_4;
                break;
            }
            case 5: {
                type = ComponentType.HEADING_5;
                break;
            }
            default: {
                throw new IllegalArgumentException("Only heading level between 1 and 5 are supported");
            }
        }
        return new BasicComponent(0, 0, 700, 35, 1, type, "", (Serializable)((Object)content), false, isReadonly, new ArrayList());
    }

    @Override
    public boolean addTextInput() {
        this.addTextInput("", false);
        return false;
    }

    @Override
    public boolean addTextInput(String content) {
        this.addComponentToSection(this.getTextInput(content, false));
        return true;
    }

    @Override
    public boolean addTextInput(String content, boolean isReadonly) {
        this.addComponentToSection(this.getTextInput(content, isReadonly));
        return true;
    }

    private BasicComponent getTextInput(String content, boolean isReadonly) {
        return new BasicComponent(0, 0, 700, 35, 1, ComponentType.BODY_NOT_FORMATTED, "", (Serializable)((Object)content), false, isReadonly, new ArrayList());
    }

    private BasicComponent getSequenceDelimiter() {
        return new BasicComponent(0, 0, 700, 10, 1, ComponentType.REPEAT_SEQUENCE_DELIMITER, "", (Serializable)((Object)""), false, false, new ArrayList());
    }

    @Override
    public boolean addInstruction(String content) {
        BasicComponent bc = new BasicComponent(0, 0, 700, 35, 1, ComponentType.INSTRUCTION, "", (Serializable)((Object)content), false, false, new ArrayList());
        this.addComponentToSection(bc);
        return true;
    }

    @Override
    public boolean addReference(List<DBTableRow> list) {
        ArrayList<Tuple> msL = new ArrayList<Tuple>();
        for (DBTableRow dBTableRow : list) {
            ArrayList<BasicComponent> groupedComponents = new ArrayList<BasicComponent>();
            groupedComponents.add(this.getSequenceDelimiter());
            for (Metadata md : dBTableRow.getMetadata()) {
                groupedComponents.add(this.getHeading(dBTableRow.getHeadingLevel(), md.getAttribute(), true));
                groupedComponents.add(this.getTextInput(md.getValue(), true));
            }
            groupedComponents.add(this.getSequenceDelimiter());
            msL.add(new Tuple(dBTableRow.getIdentifier(), groupedComponents));
        }
        BasicComponent toAdd = new BasicComponent(0, 0, 700, 35, 1, ComponentType.TUPLE, "", msL, false, true, new ArrayList());
        this.addComponentToSection(toAdd);
        return true;
    }

    @Override
    public boolean addAttributeComponent(String attrName, ArrayList<Attribute> values, boolean allowMultiselection) {
        ComponentType type = allowMultiselection ? ComponentType.ATTRIBUTE_MULTI : ComponentType.ATTRIBUTE_UNIQUE;
        BasicComponent bc = new BasicComponent(0, 0, 700, 35, 1, type, "", (Serializable)new AttributeArea(attrName, values), false, false, new ArrayList());
        this.addComponentToSection(bc);
        return true;
    }

    @Override
    public boolean addMedia() {
        BasicComponent toAdd = new BasicComponent(0, 0, 700, 35, 1, ComponentType.BODY_TABLE_IMAGE, "", null, false, true, new ArrayList());
        this.addComponentToSection(toAdd);
        return true;
    }

    @Override
    public int nextSection() {
        ++this.currSection;
        this.model.setTotalPages(this.currSection);
        return this.model.getTotalPages();
    }

    private boolean addComponentToSection(BasicComponent bc) {
        BasicSection bs;
        if (this.model.getSections().isEmpty()) {
            bs = new BasicSection();
            this.model.getSections().add(bs);
        }
        if (this.currSection == this.model.getSections().size() + 1) {
            bs = new BasicSection();
            this.model.getSections().add(bs);
        }
        if (this.currSection == this.model.getSections().size()) {
            bs = (BasicSection)this.model.getSections().get(this.currSection - 1);
            bs.getComponents().add(bc);
            return true;
        }
        return false;
    }

    public Model getReportInstance() throws Exception {
        if (this.model.getSections().isEmpty()) {
            throw new Exception("The report is empty, has no sections.");
        }
        return this.model;
    }

    private void initialize() {
        BasicComponent bc = new BasicComponent(0, 0, 700, 35, 1, ComponentType.FAKE_TEXTAREA, "", (Serializable)((Object)""), false, false, new ArrayList());
        this.addComponentToSection(bc);
    }
}

