/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.spd.gbifplugin.search;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import org.gcube.data.spd.gbifplugin.search.ProductKey;
import org.gcube.data.spd.gbifplugin.search.query.QueryCondition;
import org.gcube.data.spd.model.Condition;
import org.gcube.data.spd.model.Coordinate;
import org.gcube.data.spd.model.products.DataProvider;
import org.gcube.data.spd.model.products.DataSet;

public class Utils {
    protected static List<QueryCondition> elaborateConditions(Condition[] properties) throws Exception {
        ArrayList<QueryCondition> queryConditions = new ArrayList<QueryCondition>();
        block4: for (Condition prop : properties) {
            switch (prop.getType()) {
                case COORDINATE: {
                    Coordinate coord = (Coordinate)prop.getValue();
                    queryConditions.addAll(Utils.getCoordinateConditions(coord, prop));
                    continue block4;
                }
                case DATE: {
                    Calendar date = (Calendar)prop.getValue();
                    queryConditions.addAll(Utils.getDateCondition(date, prop));
                }
            }
        }
        return queryConditions;
    }

    public static ProductKey elaborateProductsKey(String id) {
        ArrayList<QueryCondition> queryConditions = new ArrayList<QueryCondition>();
        String[] splitString = id.split("\\|\\|");
        DataSet dataset = Utils.getDataSetFromString(splitString[0]);
        queryConditions.add(QueryCondition.cond("datasetKey", dataset.getId()));
        queryConditions.add(QueryCondition.cond("taxonKey", splitString[1]));
        if (splitString.length > 2) {
            for (int i = 2; i <= splitString.length; ++i) {
                String[] equalSplit = splitString[i].split("=");
                queryConditions.add(QueryCondition.cond(equalSplit[0], equalSplit[1]));
            }
        }
        return new ProductKey(queryConditions, dataset);
    }

    protected static String createProductsKey(String dataResourceKey, String taxonKey, List<QueryCondition> queryConditions) {
        StringBuilder conditionTransformer = new StringBuilder();
        for (QueryCondition cond : queryConditions) {
            conditionTransformer.append("||").append(cond.getKey()).append("=").append(cond.getValue());
        }
        return dataResourceKey + "||" + taxonKey + conditionTransformer.toString();
    }

    public static List<QueryCondition> getCoordinateConditions(Coordinate coordinate, Condition prop) {
        ArrayList<QueryCondition> conditions = new ArrayList<QueryCondition>();
        switch (prop.getOp()) {
            case EQ: {
                conditions.add(QueryCondition.cond("decimalLatitiude", coordinate.getLatitude() + ""));
                conditions.add(QueryCondition.cond("decimalLongitude", coordinate.getLongitude() + ""));
                break;
            }
            case GT: {
                conditions.add(QueryCondition.cond("decimalLatitiude", coordinate.getLatitude() + 0.01 + ",90"));
                conditions.add(QueryCondition.cond("decimalLongitude", coordinate.getLongitude() + 0.01 + ",180"));
                break;
            }
            case GE: {
                conditions.add(QueryCondition.cond("decimalLatitiude", coordinate.getLatitude() + ",90"));
                conditions.add(QueryCondition.cond("decimalLongitude", coordinate.getLongitude() + ",180"));
                break;
            }
            case LT: {
                conditions.add(QueryCondition.cond("decimalLatitiude", "-90," + (coordinate.getLatitude() + 0.01)));
                conditions.add(QueryCondition.cond("decimalLongitude", "-180," + (coordinate.getLongitude() + 0.01)));
                break;
            }
            case LE: {
                conditions.add(QueryCondition.cond("decimalLatitiude", "-90," + coordinate.getLatitude()));
                conditions.add(QueryCondition.cond("decimalLongitude", "-180," + coordinate.getLongitude()));
                break;
            }
        }
        return conditions;
    }

    public static List<QueryCondition> getDateCondition(Calendar date, Condition prop) {
        ArrayList<QueryCondition> conditions = new ArrayList<QueryCondition>();
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
        Calendar newDate = date;
        Calendar now = Calendar.getInstance();
        switch (prop.getOp()) {
            case EQ: {
                conditions.add(QueryCondition.cond("eventDate", dateFormat.format(date.getTime())));
                break;
            }
            case GT: {
                newDate.add(5, -1);
                conditions.add(QueryCondition.cond("eventDate", dateFormat.format(date.getTime()) + "," + dateFormat.format(now.getTime())));
                break;
            }
            case GE: {
                conditions.add(QueryCondition.cond("eventDate", dateFormat.format(date.getTime()) + "," + dateFormat.format(now.getTime())));
                break;
            }
            case LT: {
                newDate.add(5, 1);
                conditions.add(QueryCondition.cond("eventDate", "1000-01-01," + dateFormat.format(now.getTime())));
                break;
            }
            case LE: {
                conditions.add(QueryCondition.cond("eventDate", "1000-01-01," + dateFormat.format(now.getTime())));
                break;
            }
        }
        return conditions;
    }

    protected static String getDataSetAsString(DataSet dataset) {
        StringBuilder datasetAsString = new StringBuilder(dataset.getId()).append("^^").append(dataset.getName()).append("^^").append(dataset.getCitation()).append("^^").append(dataset.getDataProvider().getId()).append("^^").append(dataset.getDataProvider().getName());
        return datasetAsString.toString();
    }

    protected static DataSet getDataSetFromString(String datasetString) {
        String[] splittedDataset = datasetString.split("\\^\\^");
        DataSet dataset = new DataSet(splittedDataset[0]);
        dataset.setName(splittedDataset[1]);
        dataset.setCitation(splittedDataset[2]);
        DataProvider dataProvider = new DataProvider(splittedDataset[3]);
        dataProvider.setName(splittedDataset[4]);
        dataset.setDataProvider(dataProvider);
        return dataset;
    }
}

