/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.spd.gbifplugin.search;

import java.text.SimpleDateFormat;
import java.util.Calendar;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.events.XMLEvent;
import org.gcube.data.spd.plugin.fwk.Coordinate;
import org.gcube.data.spd.plugin.fwk.Property;

public class Utils {
    protected static String elaborateProps(Property[] properties) throws Exception {
        StringBuilder props = new StringBuilder();
        block6: for (Property prop : properties) {
            switch (prop.getProp()) {
                case CoordinateFrom: {
                    Coordinate coordFrom = (Coordinate)prop.getValue();
                    props.append("&minlatitude=" + coordFrom.getLatitude());
                    props.append("&");
                    props.append("minlongitude=" + coordFrom.getLongitude());
                    continue block6;
                }
                case CoordinateTo: {
                    Coordinate coordTo = (Coordinate)prop.getValue();
                    props.append("&maxlatitude=" + coordTo.getLatitude());
                    props.append("&");
                    props.append("maxlongitude=" + coordTo.getLongitude());
                    continue block6;
                }
                case DateFrom: {
                    Calendar dateFrom = (Calendar)prop.getValue();
                    SimpleDateFormat dfFrom = new SimpleDateFormat("yyyy-MM-dd");
                    props.append("&startdate=" + dfFrom.format(dateFrom.getTime()));
                    continue block6;
                }
                case DateTo: {
                    Calendar dateTo = (Calendar)prop.getValue();
                    SimpleDateFormat dfdfTo = new SimpleDateFormat("yyyy-MM-dd");
                    props.append("&enddate=" + dfdfTo.format(dateTo.getTime()));
                    continue block6;
                }
            }
        }
        return props.toString();
    }

    protected static String elaborateProductsKey(String id) {
        String[] splitString = id.split("\\|\\|");
        String toReturn = "scientificname=" + splitString[0] + "&dataproviderkey=" + splitString[1] + "&dataresourcekey=" + splitString[2] + "&taxonconceptkey=" + splitString[3];
        if (splitString.length > 4) {
            toReturn = toReturn + splitString[4];
        }
        return toReturn;
    }

    protected static String createProductsKey(String scientificName, String dataProviderKey, String dataResourceKey, String taxonConceptKey, String properties) {
        return scientificName + "||" + dataProviderKey + "||" + dataResourceKey + "||" + taxonConceptKey + "||" + properties;
    }

    protected static boolean checkStartElement(XMLEvent event, String tagName) {
        return event.getEventType() == 1 && event.asStartElement().getName().getLocalPart().equals(tagName);
    }

    protected static boolean checkEndElement(XMLEvent event, String tagName) {
        return event.getEventType() == 2 && event.asEndElement().getName().getLocalPart().equals(tagName);
    }

    protected static String readCharacters(XMLEventReader eventReader) throws Exception {
        String characters = "";
        XMLEvent event = eventReader.nextEvent();
        while (eventReader.hasNext() && event.isCharacters()) {
            characters = characters + event.asCharacters().getData() + " ";
            event = eventReader.nextEvent();
        }
        return characters.trim();
    }
}

