/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.application.speciesmanager.gbifplugin;

import java.util.Collections;
import java.util.Set;
import org.gcube.application.speciesmanager.gbifplugin.capabilities.OccurrencesCapabilityImpl;
import org.gcube.application.speciesmanager.gbifplugin.search.GBIFSearch;
import org.gcube.application.speciesmanager.stubs.model.ResultItem;
import org.gcube.application.speciesmanager.stubs.pluginhelper.AbstractPlugin;
import org.gcube.application.speciesmanager.stubs.pluginhelper.Capabilities;
import org.gcube.application.speciesmanager.stubs.pluginhelper.Property;
import org.gcube.application.speciesmanager.stubs.pluginhelper.SearchTypes;
import org.gcube.application.speciesmanager.stubs.pluginhelper.capabilities.OccurrencesCapability;
import org.gcube.application.speciesmanager.stubs.pluginhelper.writers.ObjectWriter;
import org.gcube.common.core.resources.GCUBERuntimeResource;
import org.gcube.common.core.resources.runtime.AccessPoint;
import org.gcube.common.core.utils.logging.GCUBELog;

public class Plugin
extends AbstractPlugin {
    private GCUBELog logger = new GCUBELog(Plugin.class);
    private OccurrencesCapability occurrencesCapability;
    private String baseURL;

    public void initialize(GCUBERuntimeResource resource) throws Exception {
        this.occurrencesCapability = new OccurrencesCapabilityImpl();
        this.baseURL = ((AccessPoint)resource.getAccessPoints().get(0)).getEndpoint();
        super.initialize(resource);
    }

    public Set<SearchTypes> getSupportedSearch() {
        return Collections.singleton(SearchTypes.ScientificName);
    }

    public Set<Capabilities> getSupportedCapabilities() {
        return Collections.singleton(Capabilities.Occurences);
    }

    public OccurrencesCapability getOccurrencesInterface() {
        return this.occurrencesCapability;
    }

    public String getRepositoryName() {
        return "GBIF";
    }

    public String getDescription() {
        return "A plugin for GBIF interaction";
    }

    public void searchByCommonName(String word, ObjectWriter<ResultItem> writer, Property ... properties) {
    }

    public void searchByScientificName(String word, ObjectWriter<ResultItem> writer, Property ... properties) {
        this.logger.debug((Object)"starting the search for gbifPlugin");
        try {
            new GBIFSearch(this.baseURL, word, properties).search(writer);
        }
        catch (Exception e) {
            this.logger.debug((Object)"searchByScientificName failed", (Throwable)e);
        }
    }
}

