/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.application.enm.service.concurrent;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Map;
import java.util.PriorityQueue;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.gcube.application.enm.common.xml.status.StatusType;
import org.gcube.application.enm.service.GenericJob;
import org.gcube.application.enm.service.concurrent.FIFOEntry;
import org.gcube.application.enm.service.conn.JobUpdate;
import org.gcube.application.enm.service.conn.PersistenceClient;
import org.gcube.application.enm.service.conn.StorageClientUtil;
import org.gcube.common.core.utils.logging.GCUBELog;
import org.gcube.contentmanagement.blobstorage.service.IClient;

public class JobMonitor {
    protected GCUBELog logger = new GCUBELog(JobMonitor.class);
    private PriorityQueue<FIFOEntry<GenericJob>> pendingJobs = new PriorityQueue();
    private ConcurrentMap<UUID, GenericJob> jobsMap = null;
    private final Lock mutex = new ReentrantLock();
    private final Condition hasPendingJobsCondition = this.mutex.newCondition();
    private final PersistenceClient persistenceClient = new PersistenceClient();
    private static JobMonitor instance;

    public static JobMonitor get() {
        if (instance == null) {
            instance = new JobMonitor();
        }
        return instance;
    }

    private JobMonitor() {
        this.logger.trace((Object)"Constructor...");
    }

    public void init(ConcurrentMap<UUID, GenericJob> jobsMap) throws IllegalArgumentException {
        block9: {
            this.mutex.lock();
            try {
                if (this.jobsMap == null) {
                    this.jobsMap = jobsMap;
                    if (this.jobsMap != null) {
                        for (Map.Entry entry : this.jobsMap.entrySet()) {
                            GenericJob job = (GenericJob)entry.getValue();
                            StatusType status = job.getStatus().getStatus();
                            switch (status) {
                                case PENDING: 
                                case EXECUTING: {
                                    this.pendingJobs.add(new FIFOEntry<GenericJob>(job));
                                    break;
                                }
                            }
                        }
                    }
                    break block9;
                }
                throw new IllegalArgumentException("A jobs map was already initialized");
            }
            finally {
                this.mutex.unlock();
            }
        }
    }

    public int numPendingJobs() {
        this.mutex.lock();
        try {
            int n = this.pendingJobs.size();
            return n;
        }
        finally {
            this.mutex.unlock();
        }
    }

    public GenericJob nextPendingJob() {
        this.mutex.lock();
        try {
            while (this.pendingJobs.isEmpty()) {
                this.hasPendingJobsCondition.await();
            }
            GenericJob genericJob = this.pendingJobs.poll().getEntry();
            return genericJob;
        }
        catch (InterruptedException e) {
            return null;
        }
        finally {
            this.mutex.unlock();
        }
    }

    public void schedulePendingJob(GenericJob job) {
        this.mutex.lock();
        try {
            FIFOEntry<GenericJob> fifoEntry = new FIFOEntry<GenericJob>(job);
            if (!this.pendingJobs.contains(fifoEntry) && this.pendingJobs.offer(fifoEntry)) {
                this.hasPendingJobsCondition.signalAll();
            }
        }
        finally {
            this.mutex.unlock();
        }
    }

    public boolean registerNewJob(GenericJob job) {
        this.mutex.lock();
        try {
            boolean registered = false;
            GenericJob previous = this.jobsMap.putIfAbsent(job.getUUID(), job);
            if (previous == null) {
                try {
                    this.logger.trace((Object)"write job into persistence dir");
                    this.persistenceClient.write(job);
                    registered = true;
                }
                catch (IOException e) {
                    this.logger.error((Object)("Failed to save job '" + job.getUUID().toString() + "' to the persistent storage: " + e.getLocalizedMessage()));
                }
            } else {
                registered = false;
                this.logger.error((Object)("Job UUID collision! Offending id: '" + job.getUUID().toString() + "'"));
            }
            boolean bl = registered;
            return bl;
        }
        finally {
            this.mutex.unlock();
        }
    }

    public GenericJob getJob(UUID uuid) {
        this.mutex.lock();
        try {
            String credentials;
            GenericJob job = null;
            if (uuid != null && (job = (GenericJob)this.jobsMap.get(uuid)) == null && (job = this.persistenceClient.read(credentials = this.persistenceClient.findCredentials(uuid), uuid)) != null) {
                this.jobsMap.put(uuid, job);
            }
            GenericJob genericJob = job;
            return genericJob;
        }
        catch (Exception e) {
            this.logger.error((Object)("Failed to load job '" + uuid.toString() + "': " + e.getLocalizedMessage()));
            return null;
        }
        finally {
            this.mutex.unlock();
        }
    }

    public void cancelJob(UUID uuid) {
        block7: {
            this.mutex.lock();
            try {
                GenericJob job = this.getJob(uuid);
                if (job == null) break block7;
                StatusType status = job.getStatus().getStatus();
                switch (status) {
                    case PENDING: 
                    case EXECUTING: {
                        job.cancel();
                        FIFOEntry<GenericJob> fifoEntry = new FIFOEntry<GenericJob>(job);
                        if (!this.pendingJobs.contains(fifoEntry) && this.pendingJobs.offer(fifoEntry)) {
                            this.hasPendingJobsCondition.signalAll();
                        }
                        break;
                    }
                    default: {
                        this.logger.trace((Object)("Ignoring cancel request for the job '" + job.getUUID().toString() + "' that already finished with the status: " + status.toString()));
                        break;
                    }
                }
            }
            finally {
                this.mutex.unlock();
            }
        }
    }

    public void updateJob(GenericJob job, JobUpdate updates) {
        this.mutex.lock();
        try {
            try {
                this.persistenceClient.write(job, updates);
            }
            catch (IOException e) {
                this.logger.error((Object)("Failed to save experiment '" + job.getUUID().toString() + "': " + e.getLocalizedMessage()));
            }
        }
        finally {
            this.mutex.unlock();
        }
    }

    public void removeJob(UUID uuid) {
        block10: {
            this.mutex.lock();
            try {
                try {
                    GenericJob job = null;
                    String credentials = null;
                    if (uuid != null && (job = (GenericJob)this.jobsMap.get(uuid)) == null) {
                        credentials = this.persistenceClient.findCredentials(uuid);
                        job = this.persistenceClient.read(credentials, uuid);
                    }
                    if (job == null) break block10;
                    this.jobsMap.remove(uuid);
                    FIFOEntry<GenericJob> fifoEntry = new FIFOEntry<GenericJob>(job);
                    if (this.pendingJobs.contains(fifoEntry)) {
                        ArrayList<FIFOEntry<GenericJob>> list = new ArrayList<FIFOEntry<GenericJob>>();
                        while (!this.pendingJobs.isEmpty()) {
                            FIFOEntry<GenericJob> item = this.pendingJobs.poll();
                            if (item.equals(fifoEntry)) continue;
                            list.add(item);
                        }
                        this.pendingJobs.addAll(list);
                    }
                    this.persistenceClient.delete(job);
                    try {
                        IClient storageClient = StorageClientUtil.client();
                        storageClient.removeDir().RDir(StorageClientUtil.experimentBaseDir(job.getRequest().getCredentials(), job.getUUID()));
                    }
                    catch (Exception e) {
                        this.logger.error((Object)("Failed to delete experiment '" + job.getUUID().toString() + "' from the storage service: " + e.getLocalizedMessage()));
                    }
                    this.hasPendingJobsCondition.signalAll();
                }
                catch (Exception e) {
                    this.logger.error((Object)("Failed to delete job '" + uuid.toString() + "': " + e.getLocalizedMessage()));
                    this.mutex.unlock();
                }
            }
            finally {
                this.mutex.unlock();
            }
        }
    }

    public void clean() {
        this.mutex.lock();
        try {
            Set keySet = this.jobsMap.keySet();
            for (UUID key : keySet) {
                GenericJob job = (GenericJob)this.jobsMap.get(key);
                switch (job.getStatus().getStatus()) {
                    case PENDING: 
                    case EXECUTING: {
                        break;
                    }
                    default: {
                        this.jobsMap.remove(key, job);
                        this.logger.trace((Object)("Job '" + key + "' was taken off the map"));
                    }
                }
            }
        }
        finally {
            this.mutex.unlock();
        }
    }
}

