/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.application.enm.service;

import java.lang.reflect.Constructor;
import java.util.UUID;
import org.gcube.application.enm.common.xml.logs.ExperimentLogs;
import org.gcube.application.enm.common.xml.request.ExperimentRequest;
import org.gcube.application.enm.common.xml.results.ExperimentResults;
import org.gcube.application.enm.common.xml.status.ExperimentStatus;
import org.gcube.application.enm.service.ExecutionResource;
import org.gcube.application.enm.service.GenericJob;
import org.gcube.common.core.utils.logging.GCUBELog;

public class PluginLoader {
    protected GCUBELog logger = new GCUBELog(PluginLoader.class);

    public PluginLoader() {
        this.logger.trace((Object)"Constructor...");
    }

    public GenericJob getNewJobInstance(UUID uuid, ExperimentRequest request, String pluginName) {
        GenericJob instance = null;
        try {
            Class[] argsTypes = new Class[]{UUID.class, ExperimentRequest.class};
            Class<?> clazz = Class.forName(pluginName);
            Constructor<?> cons = clazz.getConstructor(argsTypes);
            Object[] args = new Object[]{uuid, request};
            instance = (GenericJob)cons.newInstance(args);
            this.logger.trace((Object)("Plugin successfully loaded: " + pluginName));
        }
        catch (Exception e) {
            this.logger.error((Object)("Failed to load job plugin: " + e.getLocalizedMessage()));
        }
        return instance;
    }

    public GenericJob getNewJobInstance(UUID uuid, ExperimentRequest request, ExperimentStatus status, ExperimentResults results, ExperimentLogs logs, String pluginName) {
        GenericJob instance = null;
        try {
            Class[] argsTypes = new Class[]{UUID.class, ExperimentRequest.class, ExperimentStatus.class, ExperimentResults.class, ExperimentLogs.class};
            Class<?> clazz = Class.forName(pluginName);
            Constructor<?> cons = clazz.getConstructor(argsTypes);
            Object[] args = new Object[]{uuid, request, status, results, logs};
            instance = (GenericJob)cons.newInstance(args);
            this.logger.trace((Object)("Plugin successfully loaded: " + pluginName));
        }
        catch (Exception e) {
            this.logger.error((Object)("Failed to load job plugin: " + e.getLocalizedMessage() + (e.getCause() != null ? ". Cause: " + e.getCause().getLocalizedMessage() : "")));
        }
        return instance;
    }

    public ExecutionResource getNewExecutionResourceInstance(String pluginName) {
        ExecutionResource instance = null;
        try {
            Class[] argsTypes = new Class[]{};
            Class<?> clazz = Class.forName(pluginName);
            Constructor<?> cons = clazz.getConstructor(argsTypes);
            Object[] args = new Object[]{};
            instance = (ExecutionResource)cons.newInstance(args);
            this.logger.trace((Object)("Plugin successfully loaded: " + pluginName));
        }
        catch (Exception e) {
            this.logger.error((Object)("Failed to load execution resource plugin: " + e.getLocalizedMessage()));
        }
        return instance;
    }
}

