/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.application.cms.sdi.model;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.bson.Document;
import org.gcube.application.geoportal.common.model.document.filesets.sdi.GCubeSDILayer;
import org.gcube.application.geoportal.common.model.document.filesets.sdi.GeoServerPlatform;

public class GCubeSDILayerBuilder {
    public static final String EPSG_4326 = "EPSG:4326";
    public static final String WGS84_FULL = "GEOGCS[\"WGS 84\", DATUM[\"World Geodetic System 1984\", SPHEROID[\"WGS 84\", 6378137.0, 298.257223563, AUTHORITY[\"EPSG\",\"7030\"]],AUTHORITY[\"EPSG\",\"6326\"]], PRIMEM[\"Greenwich\", 0.0, AUTHORITY[\"EPSG\",\"8901\"]],  UNIT[\"degree\", 0.017453292519943295],AXIS[\"Geodetic longitude\", EAST],  AXIS[\"Geodetic latitude\", NORTH],  AUTHORITY[\"EPSG\",\"4326\"]]";
    GCubeSDILayer theObject = new GCubeSDILayer();
    GeoServerPlatform platformInfo = new GeoServerPlatform();
    GCubeSDILayer.BBOX bbox = GCubeSDILayer.BBOX.WORLD;
    Map<OGC_TYPE, Document> ogcLinks = new HashMap<OGC_TYPE, Document>();

    public GCubeSDILayerBuilder() {
        this.platformInfo.put("_type", (Object)"Geoserver");
    }

    public GCubeSDILayer getLayer() {
        this.theObject.put("_platformInfo", Collections.singleton(this.platformInfo));
        this.theObject.put("_bbox", (Object)this.bbox);
        this.prepareOGCLinks();
        Document finalLinkDocument = new Document();
        this.ogcLinks.forEach((type, document) -> finalLinkDocument.putAll((Map)document));
        this.theObject.put("_ogcLinks", (Object)finalLinkDocument);
        return this.theObject;
    }

    public GCubeSDILayerBuilder setWorkspace(String ws) {
        this.platformInfo.put("workspace", (Object)ws);
        return this;
    }

    public GCubeSDILayerBuilder setHost(String ws) {
        this.platformInfo.put("_host", (Object)ws);
        return this;
    }

    public GCubeSDILayerBuilder setEngineVersion(String ws) {
        this.platformInfo.put("_engineVersion", (Object)ws);
        return this;
    }

    public GCubeSDILayerBuilder setLayerName(String ws) {
        this.platformInfo.put("layerName", (Object)ws);
        return this;
    }

    public GCubeSDILayerBuilder setPersistencePath(String ws) {
        this.platformInfo.put("persistencePath", (Object)ws);
        return this;
    }

    public GCubeSDILayerBuilder setStoreName(String ws) {
        this.platformInfo.put("storeName", (Object)ws);
        return this;
    }

    public GCubeSDILayerBuilder setFiles(List<String> ws) {
        this.platformInfo.put("files", ws);
        return this;
    }

    private void prepareOGCLinks() {
        if (!this.ogcLinks.containsKey((Object)OGC_TYPE.wms)) {
            this.addLink(OGC_TYPE.wms, String.format("https://%1$s/geoserver/%2$s/wms?service=WMS&version=1.1.0&request=GetMap&layers=%2$s:%3$s&styles=&bbox=%4$f,%5$f,%6$f,%7$f&srs=%8$s&format=application/openlayers&width=%9$d&height=%10$d", this.platformInfo.getHost(), this.platformInfo.getWorkspace(), this.platformInfo.getLayerName(), this.bbox.getMinX(), this.bbox.getMinY(), this.bbox.getMaxX(), this.bbox.getMaxY(), EPSG_4326, 400, 400));
        }
    }

    public GCubeSDILayerBuilder addLink(OGC_TYPE type, String link) {
        this.ogcLinks.put(type, new Document(type.name(), (Object)link));
        return this;
    }

    public GCubeSDILayerBuilder setBBOX(Double maxX, Double minX, Double maxY, Double minY, Double maxZ, Double minZ) {
        this.bbox = new GCubeSDILayer.BBOX(maxX, minX, maxY, minY, maxZ, minZ);
        return this;
    }

    public GeoServerPlatform getPlatformInfo() {
        return this.platformInfo;
    }

    public GCubeSDILayer.BBOX getBbox() {
        return this.bbox;
    }

    public Map<OGC_TYPE, Document> getOgcLinks() {
        return this.ogcLinks;
    }

    public static enum OGC_TYPE {
        wms,
        wfs,
        wcs,
        csw;

    }
}

