/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.application.cms.notifications.manage;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.gcube.application.cms.implementations.utils.UserUtils;
import org.gcube.application.cms.notifications.NotificationGenericConstants;
import org.gcube.application.cms.notifications.config.NotificationFor;
import org.gcube.application.cms.notifications.config.NotificationWhen;
import org.gcube.application.cms.notifications.config.SubscribeNotificationEvent;
import org.gcube.application.cms.notifications.manage.NotifyToSocial;
import org.gcube.application.cms.notifications.manage.mapping.MappingToCatalogue;
import org.gcube.application.cms.notifications.social.SocialClients;
import org.gcube.application.cms.notifications.substitutor.NMessagesPlaceholdersSubstitutorUtil;
import org.gcube.application.cms.notifications.substitutor.SubstitutorPlaceholdersMap;
import org.gcube.application.cms.plugins.events.ItemObserved;
import org.gcube.application.geoportal.common.model.document.Project;
import org.gcube.application.geoportal.common.model.document.accounting.User;
import org.gcube.application.geoportal.common.model.document.lifecycle.LifecycleInformation;
import org.gcube.social_networking.socialnetworking.model.beans.catalogue.CatalogueEventType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ManageDoActionNotification {
    private static final Logger log = LoggerFactory.getLogger(ManageDoActionNotification.class);
    private List<SubscribeNotificationEvent> listSubscribedNotification;
    private ItemObserved<Project> itemObserved;
    private NMessagesPlaceholdersSubstitutorUtil nMPlaceholdersS;

    public ManageDoActionNotification(ItemObserved<Project> itemObserved, NMessagesPlaceholdersSubstitutorUtil nMPlaceholdersSUtil, List<SubscribeNotificationEvent> filterList) {
        this.listSubscribedNotification = filterList;
        this.nMPlaceholdersS = nMPlaceholdersSUtil;
        this.itemObserved = itemObserved;
        SubstitutorPlaceholdersMap placeholderMapValues = new SubstitutorPlaceholdersMap();
        placeholderMapValues.putProjectId(itemObserved.getProjectId());
        LinkedHashMap docAsMap = itemObserved.getDocumentEntries(1);
        String projectName = docAsMap.size() > 0 ? docAsMap.values().stream().findFirst().get() + "" : itemObserved.getProjectId();
        placeholderMapValues.putProjectName(projectName);
        placeholderMapValues.putUserCaller(itemObserved.getUserCaller().getUsername());
        try {
            placeholderMapValues.putItemCreator(itemObserved.getProject().getInfo().getCreationInfo().getUser().getUsername());
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.nMPlaceholdersS.setPlaceholderMapValues(placeholderMapValues);
    }

    public void manage() {
        log.debug("manage called...");
        if (this.listSubscribedNotification == null || this.listSubscribedNotification.isEmpty()) {
            return;
        }
        for (SubscribeNotificationEvent subscribeNotificationEvent : this.listSubscribedNotification) {
            List<NotificationFor> listNotificationFor = subscribeNotificationEvent.getNotificationFor();
            LifecycleInformation lInfo = this.itemObserved.getProject().getLifecycleInformation();
            String itemPhase = lInfo.getPhase();
            String lastInvokedStep = lInfo.getLastInvokedStep();
            log.debug("ItemObserved phase is: {}, lastInvokedStep is: {}", (Object)itemPhase, (Object)lastInvokedStep);
            for (NotificationFor notificationFor : listNotificationFor) {
                List<NotificationWhen> notificationsCompliantToPhase = ManageDoActionNotification.matchNotificationsAccordingItemStatus(notificationFor, itemPhase, lastInvokedStep);
                if (notificationsCompliantToPhase == null || notificationsCompliantToPhase.size() <= 0) continue;
                List<User> notifyUsers = this.getListUserCompliantToRoles(notificationFor, this.itemObserved, false);
                CatalogueEventType catalogueEventType = MappingToCatalogue.toCatalogueEventType(itemPhase, lastInvokedStep);
                if (notifyUsers.size() <= 0) continue;
                log.info("Users compliant to role are: {}", (Object)notifyUsers.size());
                if (log.isDebugEnabled()) {
                    notifyUsers.stream().forEach(u -> log.debug("notifying user: " + u));
                }
                try {
                    NotifyToSocial mnu = new NotifyToSocial(this.itemObserved, notificationsCompliantToPhase, this.nMPlaceholdersS, notifyUsers, catalogueEventType);
                    mnu.sendNotification();
                }
                catch (Exception e) {
                    log.error("Error occurred when send notify: ", (Throwable)e);
                }
            }
        }
    }

    public static List<NotificationWhen> matchNotificationsAccordingItemStatus(NotificationFor notificationFor, String itemPhase, String lastInvokedStep) {
        log.info("Filtering notifications according to item status [phase: {}, lastInvokedStep: {}]", (Object)itemPhase, (Object)lastInvokedStep);
        ArrayList<NotificationWhen> filteredList = new ArrayList<NotificationWhen>();
        int i = 0;
        for (NotificationWhen notificationWhen : notificationFor.getWhen()) {
            log.debug(++i + ") notificationWhen target phases: {} and last_invoked_step: {}", notificationWhen.getTarget_phase(), (Object)notificationWhen.getLast_invoked_step());
            if (notificationWhen.getTarget_phase().contains(itemPhase) || notificationWhen.getTarget_phase().contains(NotificationGenericConstants.CUSTOM_TARGET_PHASE.Any.name())) {
                log.debug("target phase: {} - matched", (Object)itemPhase);
                String lastInvokedStepConfig = notificationWhen.getLast_invoked_step().trim();
                log.debug("last_invoked_step read in config is {}", (Object)lastInvokedStepConfig);
                if (lastInvokedStepConfig == null) {
                    log.debug("last_invoked_step is null or empty - {} matched", (Object)lastInvokedStep);
                    filteredList.add(notificationWhen);
                    continue;
                }
                if (lastInvokedStepConfig.contentEquals(lastInvokedStep)) {
                    log.debug("last_invoked_step: {} - matched", (Object)lastInvokedStep);
                    filteredList.add(notificationWhen);
                    continue;
                }
                log.debug("last_invoked_step {} - NOT matched", (Object)lastInvokedStep);
                continue;
            }
            log.debug("target phase: {} - NOT matched", (Object)itemPhase);
        }
        log.info("returning filtered list with {} object {} (if 0 returned no notifications is sent)", (Object)filteredList.size(), (Object)NotificationWhen.class.getSimpleName());
        return filteredList;
    }

    public List<User> getListUserCompliantToRoles(NotificationFor notificationFor, ItemObserved<Project> itemObserved, boolean ignoreUserCaller) {
        log.debug("getListUserCompliantToRoles called for scope: {}, ignore user caller: {}", (Object)itemObserved.getContext(), (Object)ignoreUserCaller);
        List<String> notifyUserWithRoles = notificationFor.getRoles();
        ArrayList<User> notifyUsers = new ArrayList<User>();
        String anyRole = NotificationGenericConstants.CUSTOM_USER_ROLES.Any.name();
        SocialClients socialClients = new SocialClients();
        User userCaller = itemObserved.getUserCaller();
        if (notifyUserWithRoles.contains(anyRole)) {
            try {
                List<String> listUsername = socialClients.getUsernamesByScope();
                notifyUsers.addAll(listUsername.stream().map(username -> new User(username, null)).collect(Collectors.toList()));
                if (ignoreUserCaller) {
                    notifyUsers.removeIf(u -> u.equals((Object)userCaller));
                }
            }
            catch (Exception e) {
                log.error("Error on reading users from scope {}: ", (Object)UserUtils.getCurrent().getContext(), (Object)e);
            }
            log.info("returning {} users for role {}", (Object)notifyUsers.size(), (Object)anyRole);
            return notifyUsers;
        }
        for (String role : notifyUserWithRoles) {
            String itemCreatorRole;
            if (role.compareTo(itemCreatorRole = NotificationGenericConstants.CUSTOM_USER_ROLES.Item_Creator.name()) == 0) {
                try {
                    String creatorUsername = itemObserved.getProject().getInfo().getCreationInfo().getUser().getUsername();
                    notifyUsers.add(new User(creatorUsername, (Set)Stream.of(role).collect(Collectors.toCollection(HashSet::new))));
                    log.info("added {} user for role {}", (Object)notifyUsers.size(), (Object)role);
                }
                catch (Exception e) {
                    log.error("Error on reading user {} from scope {}: ", new Object[]{itemCreatorRole, UserUtils.getCurrent().getContext(), e});
                }
                continue;
            }
            try {
                List<String> listUsernameForRole = socialClients.getUsernamesByRole(role);
                notifyUsers.addAll(listUsernameForRole.stream().map(username -> new User(username, (Set)Stream.of(role).collect(Collectors.toCollection(HashSet::new)))).collect(Collectors.toList()));
                if (ignoreUserCaller) {
                    notifyUsers.removeIf(u -> u.equals((Object)userCaller));
                }
                log.info("added {} users for role {}", (Object)notifyUsers.size(), (Object)role);
            }
            catch (Exception e) {
                log.error("Error on reading users from scope {}: ", (Object)UserUtils.getCurrent().getContext(), (Object)e);
            }
        }
        log.info("returing {} users to be notified: ", (Object)notifyUsers.size());
        return notifyUsers;
    }
}

