/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.application.cms.notifications.social;

import java.util.ArrayList;
import java.util.List;
import org.gcube.portal.databook.shared.Post;
import org.gcube.social_networking.social_networking_client_library.MessageClient;
import org.gcube.social_networking.social_networking_client_library.NotificationClient;
import org.gcube.social_networking.social_networking_client_library.PostClient;
import org.gcube.social_networking.social_networking_client_library.UserClient;
import org.gcube.social_networking.socialnetworking.model.beans.MessageInputBean;
import org.gcube.social_networking.socialnetworking.model.beans.PostInputBean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SocialClients {
    private static final Logger log = LoggerFactory.getLogger(SocialClients.class);
    private PostClient postClient;
    private MessageClient messagesClient;
    private UserClient userClient;
    private NotificationClient notificationClient;

    public SocialClients() {
        try {
            this.postClient = new PostClient();
        }
        catch (Exception e) {
            log.error("Error on instacing {}: ", (Object)PostClient.class.getSimpleName(), (Object)e);
        }
        try {
            this.messagesClient = new MessageClient();
        }
        catch (Exception e) {
            log.error("Error on instacing {}: ", (Object)MessageClient.class.getSimpleName(), (Object)e);
        }
        try {
            this.userClient = new UserClient();
        }
        catch (Exception e) {
            log.error("Error on instacing {}: ", (Object)UserClient.class.getSimpleName(), (Object)e);
        }
        try {
            this.notificationClient = new NotificationClient();
        }
        catch (Exception e) {
            log.error("Error on instacing {}: ", (Object)NotificationClient.class.getSimpleName(), (Object)e);
        }
    }

    public List<String> getUsernamesByRole(String roleName) throws Exception {
        return new ArrayList<String>(this.userClient.getAllUsernamesByRole(roleName));
    }

    public List<String> getUsernamesByScope() throws Exception {
        return new ArrayList<String>(this.userClient.getAllUsernamesContext());
    }

    public String writeMessage(MessageInputBean msg) throws Exception {
        return this.messagesClient.writeMessage(msg);
    }

    public Post writeUserPost(PostInputBean toWrite) {
        return this.postClient.writeUserPost(toWrite);
    }

    public static Logger getLog() {
        return log;
    }

    public PostClient getPostClient() {
        return this.postClient;
    }

    public MessageClient getMessagesClient() {
        return this.messagesClient;
    }

    public UserClient getUserClient() {
        return this.userClient;
    }

    public NotificationClient getNotificationClient() {
        return this.notificationClient;
    }
}

