package org.gcube.application.cms.custom.gna.concessioni.model;

import org.bson.BsonDocument;
import org.bson.BsonString;
import org.bson.BsonValue;
import org.bson.Document;
import org.gcube.application.geoportal.common.model.document.Access;
import org.gcube.application.geoportal.common.model.document.AccessPolicy;
import org.gcube.application.geoportal.common.model.document.ProfiledDocument;
import org.gcube.application.geoportal.common.model.document.RegisteredFileSet;
import org.gcube.application.geoportal.common.model.legacy.AbstractRelazione;
import org.gcube.application.geoportal.common.model.legacy.report.Check;
import org.gcube.application.geoportal.common.model.legacy.report.ConstraintCheck;

import java.util.List;


public class ProfiledConcessione extends ProfiledDocument {

        public static final String NOME="nome";
        //Introduzione (descrizione del progetto)
         public final static String INTRODUZIONE = "introduzione";
        //Descrizione del contenuto
         public final static String DSCRIZIONE_CONTENUTO ="descrizioneContenuto";
        //Autori
         public final static String AUTHORS= "authors";
        //Soggetto che materialmente invia i dati.
         public final static String CONTRIBUTORE ="contributore";

        //Indicare il nome del titolare/i dei dati contenuti nel dataset e/o per sue specifiche parti.
         public final static String TITOLARI="titolari";

         public final static String RESPONSABILE="responsabile";
         public final static String EDITORS ="editore";

         public final static String FONTI_FINANZIAMENTO="fontiFinanziamento";
        //Research Excavation; Archaeology  (valori di default)
         public final static String SOGGETTO="soggetto";

        //Referenze bibliografiche, DOI (se esistenti) di risorse correlate all’indagine in oggetto
         public final static String RISORSE_CORRELATE="risorseCorrelate";

         public final static String DATA_INZIO_PROGETTO="dataInizioProgetto";
         public final static String DATA_FINE_PROGETTO="dataFineProgetto";

         public final static String TITOLARE_LICENZA="titolareLicenza";
         public final static String TITOLARE_COPYRIGHT="titolareCopyright";

         public final static String PAROLE_CHIAVE_LIBERE="paroleChiaveLibere";
         public final static String PAREOLE_CHIAVE_ICCD="paroleChiaveICCD";

         public final static String RELAZIONE_SCAVO="relazioneScavo";
         public final static String ABSTRACT_RELAZIONE ="abstractRelazione";
         public final static String IMMAGINI_RAPPRESENTATIVE="immaginiRappresentative";
         public final static String POSIZIONAMENTO_SCAVO = "posizionamentoScavo";
         public final static String PIANTE_FINE_SCAVO = "pianteFineScavo";
         public final static String GENERIC_CONTENT= "genericContent";

         public static class Sections{
             public static final String TITOLO="titolo";
         } 
         public static class Relazione{

             public static final String RESPONSABILI=  "responsabili";

         }

    @Override
    public void setDefaults() {
        Document doc=this.getTheDocument();
        doc.putIfAbsent(SOGGETTO,new String[]{"Research Excavation","Archaeology"});

        doc.putIfAbsent(DSCRIZIONE_CONTENUTO,"Relazione di fine scavo e relativo abstract; selezione di immagini rappresentative;"
                + " posizionamento topografico dell'area indagata, pianta di fine scavo.");

        // Super Section
        this.getInfo().getAccess().setLicense(
                ConstraintCheck.defaultFor(getInfo().getAccess().getLicense(), "CC0-1.0").evaluate());


        //RELAZIONE
        doc.putIfAbsent(RELAZIONE_SCAVO,new RegisteredFileSet());
        Document rel=doc.get(RELAZIONE_SCAVO,Document.class);
        rel.putIfAbsent(Sections.TITOLO,doc.getString(NOME)+" relazione di scavo");
        rel.putIfAbsent(SOGGETTO,doc.get(SOGGETTO));
        rel.putIfAbsent(RegisteredFileSet.CREATION_INFO,this.getInfo().getCreationInfo());
        rel.putIfAbsent(RegisteredFileSet.ACCESS,this.getInfo().getAccess());
        Access relAccess=rel.get(RegisteredFileSet.ACCESS,Access.class);
        relAccess.setLicense(ConstraintCheck.defaultFor(relAccess.getLicense(),"CC-BY-4.0").evaluate());
        relAccess.setPolicy(ConstraintCheck.defaultFor(relAccess.getPolicy(), AccessPolicy.OPEN).evaluate());

        //ABSTRACT Relazione
        doc.putIfAbsent(ABSTRACT_RELAZIONE,new RegisteredFileSet());
        Document abs=doc.get(ABSTRACT_RELAZIONE,Document.class);
        abs.putIfAbsent(Sections.TITOLO,doc.getString(NOME)+" abstract relazione di scavo");
        abs.putIfAbsent(RegisteredFileSet.CREATION_INFO,this.getInfo().getCreationInfo());
        abs.putIfAbsent(RegisteredFileSet.ACCESS,this.getInfo().getAccess());
        Access absAccess=rel.get(RegisteredFileSet.ACCESS,Access.class);
        absAccess.setLicense(ConstraintCheck.defaultFor(absAccess.getLicense(),"CC-BY-4.0").evaluate());
        absAccess.setPolicy(ConstraintCheck.defaultFor(absAccess.getPolicy(), AccessPolicy.OPEN).evaluate());

        //IMMAGINI RAPPRESENTATIVE


//        if(doc.containsKey(IMMAGINI_RAPPRESENTATIVE)) {
//            for (BsonValue bsonValue : doc.toBsonDocument(null, null).
//                    getArray(IMMAGINI_RAPPRESENTATIVE)) {
//                BsonDocument imgDocument = bsonValue.asDocument();
//                imgDocument.putIfAbsent(SOGGETTO,new BsonString(doc.getString(SOGGETTO));
//                imgDocument.putIfAbsent(RegisteredFileSet.CREATION_INFO,new BsonDocument(this.getInfo().getCreationInfo());
//                imgDocument.putIfAbsent(RegisteredFileSet.ACCESS,this.getInfo().getAccess());
//                Access absAccess=rel.get(RegisteredFileSet.ACCESS,Access.class);
//                absAccess.setLicense(ConstraintCheck.defaultFor(absAccess.getLicense(),"CC-BY-4.0").evaluate());
//                absAccess.setPolicy(ConstraintCheck.defaultFor(absAccess.getPolicy(), AccessPolicy.OPEN).evaluate());
//            }
//        }
    }
}
