/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.application.cms.concessioni.plugins;

import com.vdurmont.semver4j.Semver;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.bson.Document;
import org.gcube.application.cms.custom.gna.concessioni.model.ProfiledConcessione;
import org.gcube.application.cms.implementations.ImplementationProvider;
import org.gcube.application.cms.implementations.ProjectAccess;
import org.gcube.application.cms.plugins.LifecycleManager;
import org.gcube.application.cms.plugins.faults.IndexingException;
import org.gcube.application.cms.plugins.implementations.Default3PhaseManager;
import org.gcube.application.cms.plugins.reports.EventExecutionReport;
import org.gcube.application.cms.plugins.reports.Report;
import org.gcube.application.cms.plugins.requests.EventExecutionRequest;
import org.gcube.application.cms.plugins.requests.IndexDocumentRequest;
import org.gcube.application.cms.serialization.Serialization;
import org.gcube.application.geoportal.common.model.JSONPathWrapper;
import org.gcube.application.geoportal.common.model.document.Project;
import org.gcube.application.geoportal.common.model.document.access.Access;
import org.gcube.application.geoportal.common.model.document.access.AccessPolicy;
import org.gcube.application.geoportal.common.model.document.relationships.RelationshipNavigationObject;
import org.gcube.application.geoportal.common.model.legacy.report.ConstraintCheck;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConcessioniLifeCycleManager
extends Default3PhaseManager
implements LifecycleManager {
    private static final Logger log = LoggerFactory.getLogger(ConcessioniLifeCycleManager.class);
    private static final String FOLLOWS = "follows";
    private static final String PRECEDES = "precedes";

    public ConcessioniLifeCycleManager() {
        this.DESCRIPTOR.setId("GNA-CONCESSIONI-LC");
        this.DESCRIPTOR.setDescription("GNA Concessioni. This plugin supports custom lifecycle management for the GNA Concessioni UseCase.");
        this.DESCRIPTOR.setVersion(new Semver("1.0.0"));
    }

    public EventExecutionReport setDefault(EventExecutionReport currentReport) {
        EventExecutionReport report = super.setDefault(currentReport);
        try {
            report.setResultingDocument(ConcessioniLifeCycleManager.setDefaults(((EventExecutionRequest)report.getTheRequest()).getDocument()).getTheDocument());
        }
        catch (Throwable t) {
            log.error("Unable to evaluate defaults for concessione " + ((EventExecutionRequest)currentReport.getTheRequest()).getDocument().getId(), t);
            log.debug("Object was {} ", (Object)((EventExecutionRequest)report.getTheRequest()).getDocument());
            report.setStatus(Report.Status.ERROR);
            report.getMessages().add("Unable to evaluate defaults : " + t.getMessage());
        }
        return report;
    }

    static final Project setDefaults(Project document) throws IOException {
        int i;
        log.info("Concessione ID {}, setting defaults..", (Object)document.getId());
        log.debug("Full concessione is {}", (Object)document);
        ProfiledConcessione c = (ProfiledConcessione)Serialization.convert((Object)document, ProfiledConcessione.class);
        Document doc = c.getTheDocument();
        doc.putIfAbsent((Object)"soggetto", (Object)new String[]{"Research Excavation", "Archaeology"});
        doc.putIfAbsent((Object)"descrizioneContenuto", (Object)"Relazione di fine scavo e relativo abstract; selezione di immagini rappresentative; posizionamento topografico dell'area indagata, pianta di fine scavo.");
        c.getInfo().getAccess().setLicense((String)ConstraintCheck.defaultFor((Object)c.getInfo().getAccess().getLicense(), (Object)"CC0-1.0").evaluate());
        Document rel = doc.containsKey((Object)"relazioneScavo") ? (Document)Serialization.convert((Object)doc.get((Object)"relazioneScavo"), Document.class) : new Document();
        log.debug("Concessione {}, managing relazione {}", (Object)document.getId(), (Object)rel);
        rel.putIfAbsent((Object)"titolo", (Object)(doc.getString((Object)"nome") + " relazione di scavo"));
        rel.putIfAbsent((Object)"soggetto", doc.get((Object)"soggetto"));
        rel.putIfAbsent((Object)"_creationInfo", (Object)c.getInfo().getCreationInfo());
        rel.putIfAbsent((Object)"_access", (Object)c.getInfo().getAccess());
        Access relAccess = (Access)Serialization.convert((Object)rel.get((Object)"_access"), Access.class);
        relAccess.setLicense((String)ConstraintCheck.defaultFor((Object)relAccess.getLicense(), (Object)"CC-BY-4.0").evaluate());
        relAccess.setPolicy((AccessPolicy)ConstraintCheck.defaultFor((Object)relAccess.getPolicy(), (Object)AccessPolicy.OPEN).evaluate());
        rel.put("_access", (Object)relAccess);
        doc.put("relazioneScavo", (Object)rel);
        Document abs = doc.containsKey((Object)"abstractRelazione") ? (Document)Serialization.convert((Object)doc.get((Object)"abstractRelazione"), Document.class) : new Document();
        log.debug("Concessione {}, managing abstract relazione {}", (Object)document.getId(), (Object)abs);
        abs.putIfAbsent((Object)"titolo", (Object)(doc.getString((Object)"nome") + " abstract relazione di scavo"));
        abs.putIfAbsent((Object)"_creationInfo", (Object)c.getInfo().getCreationInfo());
        abs.putIfAbsent((Object)"_access", (Object)c.getInfo().getAccess());
        Access absAccess = (Access)Serialization.convert((Object)abs.get((Object)"_access"), Access.class);
        absAccess.setLicense((String)ConstraintCheck.defaultFor((Object)absAccess.getLicense(), (Object)"CC-BY-4.0").evaluate());
        absAccess.setPolicy((AccessPolicy)ConstraintCheck.defaultFor((Object)absAccess.getPolicy(), (Object)AccessPolicy.OPEN).evaluate());
        abs.put("_access", (Object)absAccess);
        doc.put("abstractRelazione", (Object)abs);
        if (doc.containsKey((Object)"posizionamentoScavo")) {
            Document pos = (Document)Serialization.convert((Object)doc.get((Object)"posizionamentoScavo"), Document.class);
            log.debug("Concessione {}, managing posizionamento scavo {}", (Object)document.getId(), (Object)pos);
            pos.putIfAbsent((Object)"titolo", (Object)(doc.getString((Object)"nome") + " posizionamento scavo"));
            pos.putIfAbsent((Object)"abstractSection", (Object)"Posizionamento topografico georeferenziato dell\u2019area interessata dalle indagini");
            pos.putIfAbsent((Object)"topicCategory", (Object)"Society");
            pos.putIfAbsent((Object)"subTopic", (Object)"Archeology");
            pos.putIfAbsent((Object)"paroleChiaveLibere", doc.get((Object)"paroleChiaveLibere"));
            pos.putIfAbsent((Object)"paroleChiaveICCD", doc.get((Object)"paroleChiaveICCD"));
            pos.put("responsabile", doc.get((Object)"responsabile"));
            pos.putIfAbsent((Object)"_creationInfo", (Object)c.getInfo().getCreationInfo());
            pos.putIfAbsent((Object)"_access", (Object)c.getInfo().getAccess());
            Access posAccess = (Access)Serialization.convert((Object)rel.get((Object)"_access"), Access.class);
            posAccess.setLicense((String)ConstraintCheck.defaultFor((Object)posAccess.getLicense(), (Object)"CC-BY-4.0").evaluate());
            posAccess.setPolicy((AccessPolicy)ConstraintCheck.defaultFor((Object)posAccess.getPolicy(), (Object)AccessPolicy.OPEN).evaluate());
            pos.put("_access", (Object)posAccess);
            doc.put("posizionamentoScavo", (Object)pos);
        }
        JSONPathWrapper wrapper = new JSONPathWrapper(Serialization.write((Object)doc));
        if (doc.containsKey((Object)"immaginiRappresentative")) {
            List imgs = (List)wrapper.getByPath("$.immaginiRappresentative", List.class).get(0);
            log.debug("Concessione {}, found imgs {}", (Object)document.getId(), (Object)imgs.size());
            for (i = 0; i < imgs.size(); ++i) {
                Document imgDoc = Serialization.asDocument(imgs.get(i));
                imgDoc.putIfAbsent((Object)"soggetto", doc.get((Object)"soggetto"));
                imgDoc.putIfAbsent((Object)"_creationInfo", (Object)c.getInfo().getCreationInfo());
                imgDoc.putIfAbsent((Object)"_access", (Object)c.getInfo().getAccess());
                Access imgAccess = (Access)Serialization.convert((Object)imgDoc.get((Object)"_access"), Access.class);
                imgAccess.setLicense((String)ConstraintCheck.defaultFor((Object)imgAccess.getLicense(), (Object)"CC-BY-4.0").evaluate());
                imgAccess.setPolicy((AccessPolicy)ConstraintCheck.defaultFor((Object)imgAccess.getPolicy(), (Object)AccessPolicy.OPEN).evaluate());
                imgDoc.put("_access", (Object)imgAccess);
                wrapper.setElement("$.immaginiRappresentative[" + i + "]", (Object)imgDoc);
            }
        }
        if (doc.containsKey((Object)"pianteFineScavo")) {
            List piante = (List)wrapper.getByPath("$.pianteFineScavo", List.class).get(0);
            log.debug("Concessione {}, found piante {}", (Object)document.getId(), (Object)piante.size());
            for (i = 0; i < piante.size(); ++i) {
                Document piantaDoc = Serialization.asDocument(piante.get(i));
                log.debug("Concessione {}, managing pianta {}", (Object)document.getId(), (Object)piantaDoc);
                piantaDoc.putIfAbsent((Object)"titolo", (Object)(doc.getString((Object)"nome") + " pianta fine scavo"));
                piantaDoc.putIfAbsent((Object)"abstractSection", (Object)"Planimetria georeferenziata dell'area indagata al termine delle attivit\u00e0");
                piantaDoc.putIfAbsent((Object)"topicCategory", (Object)"Society");
                piantaDoc.putIfAbsent((Object)"subTopic", (Object)"Archeology");
                piantaDoc.putIfAbsent((Object)"paroleChiaveLibere", doc.get((Object)"paroleChiaveLibere"));
                piantaDoc.putIfAbsent((Object)"paroleChiaveICCD", doc.get((Object)"paroleChiaveICCD"));
                piantaDoc.put("responsabile", doc.get((Object)"responsabile"));
                piantaDoc.putIfAbsent((Object)"_creationInfo", (Object)c.getInfo().getCreationInfo());
                piantaDoc.putIfAbsent((Object)"_access", (Object)c.getInfo().getAccess());
                Access posAccess = (Access)Serialization.convert((Object)rel.get((Object)"_access"), Access.class);
                posAccess.setLicense((String)ConstraintCheck.defaultFor((Object)posAccess.getLicense(), (Object)"CC-BY-4.0").evaluate());
                posAccess.setPolicy((AccessPolicy)ConstraintCheck.defaultFor((Object)posAccess.getPolicy(), (Object)AccessPolicy.OPEN).evaluate());
                piantaDoc.put("_access", (Object)posAccess);
                wrapper.setElement("$.pianteFineScavo[" + i + "]", (Object)piantaDoc);
            }
        }
        c.setTheDocument((Document)Serialization.read((String)wrapper.getValueCTX().jsonString(), Document.class));
        return c;
    }

    protected Document evaluateAdditionalIndexParameters(IndexDocumentRequest request) throws IndexingException {
        Document toReturn = super.evaluateAdditionalIndexParameters(request);
        if (toReturn == null) {
            toReturn = new Document();
        }
        Project indexingProject = request.getDocument();
        log.info("Evaluating Last ID in relationship chain. Current Concessione ID is {}", (Object)indexingProject.getId());
        try {
            ArrayList<Project> projects = new ArrayList<Project>();
            ProjectAccess access = (ProjectAccess)ImplementationProvider.get().getProvidedObjectByClass(ProjectAccess.class);
            projects.add(indexingProject);
            if (!indexingProject.getRelationshipsByName(PRECEDES).isEmpty()) {
                ConcessioniLifeCycleManager.scanRelation(projects, (RelationshipNavigationObject)access.getRelations(indexingProject.getProfileID(), indexingProject.getId(), PRECEDES, Boolean.valueOf(true)).get(0), false);
            }
            if (!indexingProject.getRelationshipsByName(FOLLOWS).isEmpty()) {
                ConcessioniLifeCycleManager.scanRelation(projects, (RelationshipNavigationObject)access.getRelations(indexingProject.getProfileID(), indexingProject.getId(), FOLLOWS, Boolean.valueOf(true)).get(0), false);
            }
            log.debug("Produced full chain [size : {}] from {}, evaluating last available for PHASE {} ", new Object[]{projects.size(), indexingProject.getId(), indexingProject.getLifecycleInformation().getPhase()});
            ArrayList<String> toDisplayId = new ArrayList<String>();
            ArrayList<String> toHideIds = new ArrayList<String>();
            log.trace("Checking from LAST.. ");
            for (int i = projects.size() - 1; i >= 0; --i) {
                Project p = (Project)projects.get(i);
                log.debug("Currently checking {} : {}", (Object)p.getId(), p.getTheDocument().get((Object)"nome"));
                if (!toDisplayId.isEmpty()) {
                    toHideIds.add(p.getId());
                    continue;
                }
                if (p.getId().equals(indexingProject.getId())) {
                    toDisplayId.add(p.getId());
                } else {
                    switch (indexingProject.getLifecycleInformation().getPhase()) {
                        case "Pending Approval": {
                            if (!p.getLifecycleInformation().getPhase().equals("Pending Approval") && !p.getLifecycleInformation().getPhase().equals("Published")) break;
                            toDisplayId.add(p.getId());
                            break;
                        }
                        case "Published": {
                            if (!p.getLifecycleInformation().getPhase().equals("Published")) break;
                            toDisplayId.add(p.getId());
                        }
                    }
                }
                if (!toDisplayId.isEmpty()) {
                    log.debug("Found last concessioni candidate for displaying. ID {}, PHASE {} ", toDisplayId, (Object)p.getLifecycleInformation().getPhase());
                    continue;
                }
                toHideIds.add(p.getId());
            }
            toReturn.put("_toHideIds", toHideIds);
            toReturn.put("_toDisplayIds", toDisplayId);
            log.info("Indexing request for Concessione [ID {}] with to HIDE {} and toDisplay {} ", new Object[]{indexingProject.getId(), toHideIds, toDisplayId});
            return toReturn;
        }
        catch (Exception e) {
            log.error("Unable to evaluate to Hide and Display Ids ", (Throwable)e);
            throw new IndexingException("Unable to evaluate chain ids to hide / display", (Throwable)e);
        }
    }

    private static void scanRelation(ArrayList chain, RelationshipNavigationObject obj, boolean putBefore) {
        if (putBefore) {
            chain.add(0, obj.getTarget());
        } else {
            chain.add(obj.getTarget());
        }
        if (obj.getChildren() != null) {
            obj.getChildren().forEach(r -> ConcessioniLifeCycleManager.scanRelation(chain, r, putBefore));
        }
    }
}

