/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.application.cms.concessioni.plugins;

import org.gcube.application.cms.custom.gna.concessioni.model.ProfiledConcessione;
import org.gcube.application.cms.plugins.LifecycleManager;
import org.gcube.application.cms.plugins.faults.InitializationException;
import org.gcube.application.cms.plugins.faults.ShutDownException;
import org.gcube.application.cms.plugins.faults.StepException;
import org.gcube.application.cms.plugins.model.PluginDescriptor;
import org.gcube.application.cms.plugins.reports.ExecutionReport;
import org.gcube.application.cms.plugins.reports.InitializationReport;
import org.gcube.application.cms.plugins.reports.Report;
import org.gcube.application.cms.plugins.requests.StepExecutionRequest;
import org.gcube.application.geoportal.common.model.document.ComparableVersion;
import org.gcube.application.geoportal.common.model.document.ProfiledDocument;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConcessioniLifeCycleManager
implements LifecycleManager {
    private static final Logger log = LoggerFactory.getLogger(ConcessioniLifeCycleManager.class);
    private static final PluginDescriptor DESCRIPTOR = new PluginDescriptor("GNA-CONCESSIONI-LC", "LifecycleManagement");

    public InitializationReport initInContext() throws InitializationException {
        return null;
    }

    public InitializationReport init() throws InitializationException {
        return null;
    }

    public void shutdown() throws ShutDownException {
    }

    public ExecutionReport performStep(StepExecutionRequest request) throws StepException {
        log.info("Serving Request {}", (Object)request);
        ExecutionReport report = new ExecutionReport();
        report.setRequest(request);
        report.setStatus(Report.Status.OK);
        try {
            switch (request.getStep()) {
                case "@@@INIT_DOCUMENT@@": 
                case "@@@UPDATE_DOCUMENT@@": {
                    ProfiledDocument doc = request.getDocument();
                    break;
                }
                case "@@@MATERIALIZE_DOCUMENT@@": {
                    break;
                }
                case "@@@DEMATERIALIZE_DOCUMENT@@": {
                    break;
                }
                case "@@@DEINDEX_DOCUMENT@@": {
                    break;
                }
                case "@@@INDEX_DOCUMENT@@": {
                    break;
                }
                case "@@@DELETE_DOCUMENT@@": {
                    break;
                }
                default: {
                    throw new StepException("Invalid Step " + request.getStep());
                }
            }
        }
        catch (StepException e) {
            throw e;
        }
        catch (Throwable t) {
            log.error("Unable to perform step " + request.getStep(), t);
            report.setStatus(Report.Status.ERROR);
            report.getMessages().add("Unable to execute Step " + request.getStep() + ". Error was " + t.getMessage());
        }
        return report;
    }

    public PluginDescriptor getDescriptor() {
        return DESCRIPTOR;
    }

    private static final ProfiledDocument setDefaults(ProfiledDocument document) {
        ProfiledConcessione c = (ProfiledConcessione)document;
        c.setDefaults();
        return c;
    }

    static {
        DESCRIPTOR.setDescription("GNA Concessioni. This plugin supports custom lifecycle management for the GNA Concessioni UseCase.");
        DESCRIPTOR.setVersion(new ComparableVersion("1.0.0"));
    }
}

