/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.application.aquamaps.aquamapsspeciesview.servlet.save;

import com.thoughtworks.xstream.XStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.InputStream;
import java.io.ObjectOutputStream;
import java.io.Writer;
import java.net.URL;
import java.util.Date;
import java.util.List;
import org.gcube.application.aquamaps.aquamapsservice.stubs.datamodel.utils.CSVUtils;
import org.gcube.application.aquamaps.aquamapsspeciesview.client.rpc.data.CompoundMapItem;
import org.gcube.application.aquamaps.aquamapsspeciesview.client.rpc.data.ImageItem;
import org.gcube.application.aquamaps.aquamapsspeciesview.client.rpc.data.save.SaveCompoundMapRequest;
import org.gcube.application.aquamaps.aquamapsspeciesview.client.rpc.data.save.SaveOperationProgress;
import org.gcube.application.aquamaps.aquamapsspeciesview.client.rpc.data.save.SaveOperationState;
import org.gcube.application.aquamaps.aquamapsspeciesview.client.rpc.data.save.SaveRequest;
import org.gcube.application.aquamaps.aquamapsspeciesview.servlet.save.SaveHandler;
import org.gcube.application.aquamaps.aquamapsspeciesview.servlet.save.SaveThread;
import org.gcube.application.aquamaps.aquamapsspeciesview.servlet.utils.CompoundMapMeta;
import org.gcube.application.framework.core.session.ASLSession;
import org.gcube.common.storagehub.client.dsl.FolderContainer;
import org.gcube.common.storagehub.client.dsl.StorageHubClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
public class SaveThread
extends Thread
implements SaveHandler {
    private static final Logger logger = LoggerFactory.getLogger(SaveThread.class);
    private SaveRequest request = null;
    private SaveOperationProgress progress = new SaveOperationProgress();
    private ASLSession session = null;

    public SaveOperationProgress getProgress() {
        return this.progress;
    }

    public void setRequest(ASLSession session, SaveRequest request) {
        this.session = session;
        this.request = request;
    }

    public void startProcess() {
        this.start();
    }

    @Override
    public void run() {
        try {
            if (this.request == null) {
                throw new Exception("Request was not set");
            }
            if (this.session == null) {
                throw new Exception("Session was not set");
            }
            logger.debug("Starting request " + this.request);
            switch (1.$SwitchMap$org$gcube$application$aquamaps$aquamapsspeciesview$client$rpc$data$save$SaveOperationType[this.request.getType().ordinal()]) {
                case 1: {
                    SaveThread.saveCompoundMap((CompoundMapItem)((SaveCompoundMapRequest)this.request).getToSave(), (String)this.request.getToSaveName(), (String)this.request.getDestinationBasketId(), (ASLSession)this.session, (SaveOperationProgress)this.progress);
                }
            }
            this.progress.setState(SaveOperationState.COMPLETED);
        }
        catch (Throwable t) {
            this.progress.setState(SaveOperationState.ERROR);
            this.progress.setFailureReason(t.getMessage());
            this.progress.setFailureDetails(t.getLocalizedMessage());
        }
    }

    private static void saveCompoundMap(CompoundMapItem item, String toSaveFolderName, String destinationBasketId, ASLSession session, SaveOperationProgress progress) throws Exception {
        progress.setState(SaveOperationState.SAVING_FILES);
        progress.setToSaveCount((long)(item.getImageCount() + 1));
        StorageHubClient shc = new StorageHubClient();
        FolderContainer newFolder = shc.open(destinationBasketId).asFolder().newFolder(toSaveFolderName, "Sources Analysis data");
        int count = 0;
        for (String imgUri : CSVUtils.CSVToStringList((String)item.getImageList())) {
            try {
                ImageItem imageItem = new ImageItem(imgUri);
                URL uri = new URL(imgUri);
                newFolder.uploadFile(uri.openStream(), (String)imageItem.get(ImageItem.LABEL), "AquaMaps Image");
                progress.setSavedCount((long)(++count));
            }
            catch (Exception e) {
                logger.error("Unexpected Exception reading image", (Throwable)e);
                throw new Exception("Unable to read image " + imgUri);
            }
        }
        try {
            newFolder.uploadFile((InputStream)new FileInputStream(SaveThread.formCompoundMeta((CompoundMapItem)item)), item.getTitle() + "_meta.xml", "Compound Map Meta File");
        }
        catch (Exception e) {
            logger.error("Unable to form meta data", (Throwable)e);
            throw new Exception("Unable to form meta data");
        }
    }

    private static String formCompoundMeta(CompoundMapItem toSave) throws Exception {
        CompoundMapMeta meta = new CompoundMapMeta();
        meta.setAlgorithm(toSave.getAlgorithm());
        meta.setAuthor(toSave.getAuthor());
        meta.setCreationDate(new Date(toSave.getCreationDate()));
        meta.setCustom(toSave.isCustom());
        meta.setDataGenerationTime(new Date(toSave.getDataGenerationTime()));
        meta.setGis(toSave.isGis());
        meta.setImageCount(toSave.getImageCount());
        meta.setLayerId(toSave.getLayerId());
        meta.setLayerUrl(toSave.getLayerUrl());
        meta.setMapType(toSave.getType());
        meta.setResourceId(toSave.getResourceId());
        meta.setSpeciesList((List)CSVUtils.CSVToStringList((String)toSave.getSpeciesList()));
        meta.setTitle(toSave.getTitle());
        XStream stream = new XStream();
        stream.processAnnotations(CompoundMapMeta.class);
        File metaFile = File.createTempFile(toSave.getTitle(), ".xml");
        ObjectOutputStream oStream = stream.createObjectOutputStream((Writer)new FileWriter(metaFile));
        oStream.writeObject(meta);
        oStream.flush();
        oStream.close();
        logger.debug("Wrote File " + metaFile.getAbsolutePath());
        return metaFile.getAbsolutePath();
    }
}

