/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.application.aquamaps.aquamapsspeciesview.servlet.db;

import java.sql.PreparedStatement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import net.sf.csv4j.CSVLineProcessor;
import org.gcube.application.aquamaps.aquamapsservice.stubs.fw.fields.SpeciesOccursumFields;
import org.gcube.application.aquamaps.aquamapsservice.stubs.fw.model.Field;
import org.gcube.application.aquamaps.aquamapsservice.stubs.fw.types.FieldType;
import org.gcube.application.aquamaps.aquamapsservice.stubs.fw.types.ResourceStatus;
import org.gcube.application.aquamaps.aquamapsspeciesview.client.rpc.fields.SpeciesFields;
import org.gcube.application.aquamaps.aquamapsspeciesview.servlet.db.DBSession;
import org.gcube.application.aquamaps.aquamapsspeciesview.servlet.db.DBUtil;
import org.gcube.application.aquamaps.aquamapsspeciesview.servlet.db.Tables;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SpeciesCSVProcessor
implements CSVLineProcessor {
    private static final Logger logger = LoggerFactory.getLogger(SpeciesCSVProcessor.class);
    boolean continueProcess = true;
    DBSession session = null;
    int[] modelCSVFieldsMapping = new int[DBUtil.speciesFields.length];
    public ResourceStatus status = ResourceStatus.Completed;
    private HashMap<SpeciesFields, Integer> taxoindexes = new HashMap();
    HashMap<SpeciesOccursumFields, PreparedStatement> taxonomyInsert = new HashMap();
    HashMap<SpeciesOccursumFields, PreparedStatement> taxonomyUpdate = new HashMap();
    ArrayList<Field> kingdomInsertFields = new ArrayList();
    ArrayList<Field> phylumInsertFields = new ArrayList();
    ArrayList<Field> classInsertFields = new ArrayList();
    ArrayList<Field> orderInsertFields = new ArrayList();
    ArrayList<Field> familyInsertFields = new ArrayList();
    ArrayList<Field> phylumKey = new ArrayList();
    ArrayList<Field> phylumUpdateFields = new ArrayList();
    ArrayList<Field> classKey = new ArrayList();
    ArrayList<Field> classUpdateFields = new ArrayList();
    ArrayList<Field> orderKey = new ArrayList();
    ArrayList<Field> orderUpdateFields = new ArrayList();
    ArrayList<Field> familyKey = new ArrayList();
    ArrayList<Field> familyUpdateFields = new ArrayList();

    public SpeciesCSVProcessor(DBSession session) throws Exception {
        this.kingdomInsertFields.add(new Field(SpeciesOccursumFields.kingdom + "", "", FieldType.STRING));
        this.taxonomyInsert.put(SpeciesOccursumFields.kingdom, session.getPreparedStatementForInsert((List)this.kingdomInsertFields, Tables.kingdom + ""));
        this.phylumInsertFields.add(new Field(SpeciesOccursumFields.kingdom + "", "", FieldType.STRING));
        this.phylumInsertFields.add(new Field(SpeciesOccursumFields.phylum + "", "", FieldType.STRING));
        this.taxonomyInsert.put(SpeciesOccursumFields.phylum, session.getPreparedStatementForInsert((List)this.phylumInsertFields, Tables.phylum + ""));
        this.classInsertFields.add(new Field(SpeciesOccursumFields.kingdom + "", "", FieldType.STRING));
        this.classInsertFields.add(new Field(SpeciesOccursumFields.phylum + "", "", FieldType.STRING));
        this.classInsertFields.add(new Field(SpeciesOccursumFields.classcolumn + "", "", FieldType.STRING));
        this.taxonomyInsert.put(SpeciesOccursumFields.classcolumn, session.getPreparedStatementForInsert((List)this.classInsertFields, Tables.class_table + ""));
        this.orderInsertFields.add(new Field(SpeciesOccursumFields.kingdom + "", "", FieldType.STRING));
        this.orderInsertFields.add(new Field(SpeciesOccursumFields.phylum + "", "", FieldType.STRING));
        this.orderInsertFields.add(new Field(SpeciesOccursumFields.classcolumn + "", "", FieldType.STRING));
        this.orderInsertFields.add(new Field(SpeciesOccursumFields.ordercolumn + "", "", FieldType.STRING));
        this.taxonomyInsert.put(SpeciesOccursumFields.ordercolumn, session.getPreparedStatementForInsert((List)this.orderInsertFields, Tables.order_table + ""));
        this.familyInsertFields.add(new Field(SpeciesOccursumFields.kingdom + "", "", FieldType.STRING));
        this.familyInsertFields.add(new Field(SpeciesOccursumFields.phylum + "", "", FieldType.STRING));
        this.familyInsertFields.add(new Field(SpeciesOccursumFields.classcolumn + "", "", FieldType.STRING));
        this.familyInsertFields.add(new Field(SpeciesOccursumFields.ordercolumn + "", "", FieldType.STRING));
        this.familyInsertFields.add(new Field(SpeciesOccursumFields.familycolumn + "", "", FieldType.STRING));
        this.taxonomyInsert.put(SpeciesOccursumFields.familycolumn, session.getPreparedStatementForInsert((List)this.familyInsertFields, Tables.family_table + ""));
        this.phylumKey.add(new Field(SpeciesOccursumFields.phylum + "", "", FieldType.STRING));
        this.phylumUpdateFields.add(new Field(SpeciesOccursumFields.kingdom + "", "", FieldType.STRING));
        this.taxonomyUpdate.put(SpeciesOccursumFields.phylum, session.getPreparedStatementForUpdate((List)this.phylumUpdateFields, (List)this.phylumKey, Tables.phylum + ""));
        this.classKey.add(new Field(SpeciesOccursumFields.classcolumn + "", "", FieldType.STRING));
        this.classUpdateFields.add(new Field(SpeciesOccursumFields.phylum + "", "", FieldType.STRING));
        this.classUpdateFields.add(new Field(SpeciesOccursumFields.kingdom + "", "", FieldType.STRING));
        this.taxonomyUpdate.put(SpeciesOccursumFields.classcolumn, session.getPreparedStatementForUpdate((List)this.classUpdateFields, (List)this.classKey, Tables.class_table + ""));
        this.orderKey.add(new Field(SpeciesOccursumFields.ordercolumn + "", "", FieldType.STRING));
        this.orderUpdateFields.add(new Field(SpeciesOccursumFields.phylum + "", "", FieldType.STRING));
        this.orderUpdateFields.add(new Field(SpeciesOccursumFields.kingdom + "", "", FieldType.STRING));
        this.orderUpdateFields.add(new Field(SpeciesOccursumFields.classcolumn + "", "", FieldType.STRING));
        this.taxonomyUpdate.put(SpeciesOccursumFields.ordercolumn, session.getPreparedStatementForUpdate((List)this.orderUpdateFields, (List)this.orderKey, Tables.order_table + ""));
        this.familyKey.add(new Field(SpeciesOccursumFields.familycolumn + "", "", FieldType.STRING));
        this.familyUpdateFields.add(new Field(SpeciesOccursumFields.phylum + "", "", FieldType.STRING));
        this.familyUpdateFields.add(new Field(SpeciesOccursumFields.kingdom + "", "", FieldType.STRING));
        this.familyUpdateFields.add(new Field(SpeciesOccursumFields.classcolumn + "", "", FieldType.STRING));
        this.familyUpdateFields.add(new Field(SpeciesOccursumFields.ordercolumn + "", "", FieldType.STRING));
        this.taxonomyUpdate.put(SpeciesOccursumFields.familycolumn, session.getPreparedStatementForUpdate((List)this.familyUpdateFields, (List)this.familyKey, Tables.family_table + ""));
        this.session = session;
    }

    public boolean continueProcessing() {
        return this.continueProcess;
    }

    public void processDataLine(int arg0, List<String> arg1) {
        try {
            String kingdomValue = arg1.get((Integer)this.taxoindexes.get(SpeciesFields.kingdom));
            String phylumValue = arg1.get((Integer)this.taxoindexes.get(SpeciesFields.phylum));
            String classValue = arg1.get((Integer)this.taxoindexes.get(SpeciesFields.classcolumn));
            String orderValue = arg1.get((Integer)this.taxoindexes.get(SpeciesFields.ordercolumn));
            String familyValue = arg1.get((Integer)this.taxoindexes.get(SpeciesFields.familycolumn));
            try {
                ((Field)this.kingdomInsertFields.get(0)).value(kingdomValue);
                this.session.fillParameters((List)this.kingdomInsertFields, 0, (PreparedStatement)this.taxonomyInsert.get(SpeciesOccursumFields.kingdom)).executeUpdate();
            }
            catch (Exception exception) {
                // empty catch block
            }
            ((Field)this.phylumKey.get(0)).value(phylumValue);
            ((Field)this.phylumUpdateFields.get(0)).value(kingdomValue);
            if (this.session.fillParameters((List)this.phylumKey, this.phylumUpdateFields.size(), this.session.fillParameters((List)this.phylumUpdateFields, 0, (PreparedStatement)this.taxonomyUpdate.get(SpeciesOccursumFields.phylum))).executeUpdate() == 0) {
                ((Field)this.phylumInsertFields.get(0)).value(kingdomValue);
                ((Field)this.phylumInsertFields.get(1)).value(phylumValue);
                this.session.fillParameters((List)this.phylumInsertFields, 0, (PreparedStatement)this.taxonomyInsert.get(SpeciesOccursumFields.phylum)).executeUpdate();
            }
            ((Field)this.classKey.get(0)).value(classValue);
            ((Field)this.classUpdateFields.get(0)).value(kingdomValue);
            ((Field)this.classUpdateFields.get(1)).value(phylumValue);
            if (this.session.fillParameters((List)this.classKey, this.classUpdateFields.size(), this.session.fillParameters((List)this.classUpdateFields, 0, (PreparedStatement)this.taxonomyUpdate.get(SpeciesOccursumFields.classcolumn))).executeUpdate() == 0) {
                ((Field)this.classInsertFields.get(0)).value(kingdomValue);
                ((Field)this.classInsertFields.get(1)).value(phylumValue);
                ((Field)this.classInsertFields.get(2)).value(classValue);
                this.session.fillParameters((List)this.classInsertFields, 0, (PreparedStatement)this.taxonomyInsert.get(SpeciesOccursumFields.classcolumn)).executeUpdate();
            }
            ((Field)this.orderKey.get(0)).value(orderValue);
            ((Field)this.orderUpdateFields.get(0)).value(kingdomValue);
            ((Field)this.orderUpdateFields.get(1)).value(phylumValue);
            ((Field)this.orderUpdateFields.get(2)).value(classValue);
            if (this.session.fillParameters((List)this.orderKey, this.orderUpdateFields.size(), this.session.fillParameters((List)this.orderUpdateFields, 0, (PreparedStatement)this.taxonomyUpdate.get(SpeciesOccursumFields.ordercolumn))).executeUpdate() == 0) {
                ((Field)this.orderInsertFields.get(0)).value(kingdomValue);
                ((Field)this.orderInsertFields.get(1)).value(phylumValue);
                ((Field)this.orderInsertFields.get(2)).value(classValue);
                ((Field)this.orderInsertFields.get(3)).value(orderValue);
                this.session.fillParameters((List)this.orderInsertFields, 0, (PreparedStatement)this.taxonomyInsert.get(SpeciesOccursumFields.ordercolumn)).executeUpdate();
            }
            ((Field)this.familyKey.get(0)).value(familyValue);
            ((Field)this.familyUpdateFields.get(0)).value(kingdomValue);
            ((Field)this.familyUpdateFields.get(1)).value(phylumValue);
            ((Field)this.familyUpdateFields.get(2)).value(classValue);
            ((Field)this.familyUpdateFields.get(3)).value(orderValue);
            if (this.session.fillParameters((List)this.familyKey, this.familyUpdateFields.size(), this.session.fillParameters((List)this.familyUpdateFields, 0, (PreparedStatement)this.taxonomyUpdate.get(SpeciesOccursumFields.familycolumn))).executeUpdate() == 0) {
                ((Field)this.familyInsertFields.get(0)).value(kingdomValue);
                ((Field)this.familyInsertFields.get(1)).value(phylumValue);
                ((Field)this.familyInsertFields.get(2)).value(classValue);
                ((Field)this.familyInsertFields.get(3)).value(orderValue);
                ((Field)this.familyInsertFields.get(4)).value(familyValue);
                this.session.fillParameters((List)this.familyInsertFields, 0, (PreparedStatement)this.taxonomyInsert.get(SpeciesOccursumFields.familycolumn)).executeUpdate();
            }
        }
        catch (Exception e) {
            logger.error("Unable to insert line ", (Throwable)e);
            System.err.println("Unable to insert line ");
            e.printStackTrace();
            this.continueProcess = false;
            this.status = ResourceStatus.Error;
        }
    }

    public void processHeaderLine(int arg0, List<String> arg1) {
        try {
            logger.trace("Processing Header..");
            for (int i = 0; i < DBUtil.speciesFields.length; ++i) {
                this.modelCSVFieldsMapping[i] = arg1.indexOf(DBUtil.speciesFields[i]);
                if (DBUtil.speciesFields[i].equals(SpeciesFields.kingdom + "")) {
                    this.taxoindexes.put(SpeciesFields.kingdom, this.modelCSVFieldsMapping[i]);
                }
                if (DBUtil.speciesFields[i].equals(SpeciesFields.classcolumn + "")) {
                    this.taxoindexes.put(SpeciesFields.classcolumn, this.modelCSVFieldsMapping[i]);
                }
                if (DBUtil.speciesFields[i].equals(SpeciesFields.ordercolumn + "")) {
                    this.taxoindexes.put(SpeciesFields.ordercolumn, this.modelCSVFieldsMapping[i]);
                }
                if (DBUtil.speciesFields[i].equals(SpeciesFields.phylum + "")) {
                    this.taxoindexes.put(SpeciesFields.phylum, this.modelCSVFieldsMapping[i]);
                }
                if (!DBUtil.speciesFields[i].equals(SpeciesFields.familycolumn + "")) continue;
                this.taxoindexes.put(SpeciesFields.familycolumn, this.modelCSVFieldsMapping[i]);
            }
        }
        catch (Exception e) {
            logger.error("Unable to read header", (Throwable)e);
            System.err.println("Unable to read header");
            e.printStackTrace();
            this.continueProcess = false;
            this.status = ResourceStatus.Error;
        }
    }

    public void close() throws Exception {
        for (PreparedStatement ps : this.taxonomyInsert.values()) {
            if (ps == null) continue;
            ps.close();
        }
        for (PreparedStatement ps : this.taxonomyUpdate.values()) {
            if (ps == null) continue;
            ps.close();
        }
    }

    private static void setParameter(int metaIndex, int paramIndex, String value, PreparedStatement ps) throws Exception {
        if (value == null || value.equalsIgnoreCase("") || value.equalsIgnoreCase("null")) {
            ps.setNull(paramIndex, DBUtil.speciesFieldsType[metaIndex]);
        } else if (DBUtil.speciesFieldsType[metaIndex] == 12) {
            ps.setString(paramIndex, value);
        } else if (DBUtil.speciesFieldsType[metaIndex] == 4 || DBUtil.speciesFieldsType[metaIndex] == 5) {
            ps.setInt(paramIndex, Integer.parseInt(value));
        } else if (DBUtil.speciesFieldsType[metaIndex] == 8) {
            ps.setDouble(paramIndex, Double.parseDouble(value));
        } else if (DBUtil.speciesFieldsType[metaIndex] == 93) {
            ps.setLong(paramIndex, Long.parseLong(value));
        }
    }
}

