/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.application.aquamaps.aquamapsspeciesview.servlet;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.net.URLConnection;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ImageServlet
extends HttpServlet {
    private static final long serialVersionUID = 5385921394364316932L;
    private static final String IMAGE_BASE_URL = "http://www.fishbase.org/images/thumbnails/jpg/";
    private static final Logger logger = LoggerFactory.getLogger(ImageServlet.class);

    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.handleRequest(req, resp);
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.handleRequest(req, resp);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void handleRequest(HttpServletRequest request, HttpServletResponse response) {
        InputStream is;
        block21: {
            is = null;
            if (request.getParameter("PIC_NAME") == null) {
                response.setStatus(400);
                return;
            }
            String imageName = request.getParameter("PIC_NAME");
            try {
                if (imageName.endsWith(".gif")) {
                    response.setContentType("image/gif");
                } else if (imageName.endsWith(".png")) {
                    response.setContentType("image/png");
                } else {
                    response.setContentType("image/png");
                }
                response.setStatus(200);
                try {
                    URL url = new URL(IMAGE_BASE_URL + imageName);
                    URLConnection uc = url.openConnection();
                    is = uc.getInputStream();
                    IOUtils.copy((InputStream)is, (OutputStream)response.getOutputStream());
                }
                catch (Exception e) {
                    response.setContentType("image/jpeg");
                    is = ImageServlet.class.getResourceAsStream("resources/imageNotFound.jpg");
                    IOUtils.copy((InputStream)is, (OutputStream)response.getOutputStream());
                }
                if (is == null) break block21;
            }
            catch (Exception e) {
                logger.error("Unable to serve request for image " + imageName, (Throwable)e);
                response.setStatus(400);
                return;
            }
            IOUtils.closeQuietly((InputStream)is);
        }
        try {
            IOUtils.closeQuietly((OutputStream)response.getOutputStream());
            return;
        }
        catch (Throwable t) {
            logger.error("", t);
            return;
        }
        finally {
            if (is != null) {
                IOUtils.closeQuietly(is);
            }
            try {
                IOUtils.closeQuietly((OutputStream)response.getOutputStream());
            }
            catch (Throwable t) {
                logger.error("", t);
            }
        }
    }
}

