/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.application.aquamaps.aquamapsservice.stubs.datamodel.enhanced;

import com.thoughtworks.xstream.annotations.XStreamAlias;
import com.thoughtworks.xstream.annotations.XStreamAsAttribute;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.gcube.application.aquamaps.aquamapsservice.stubs.datamodel.enhanced.DataModel;
import org.gcube.application.aquamaps.aquamapsservice.stubs.datamodel.json.JSONArray;
import org.gcube.application.aquamaps.aquamapsservice.stubs.datamodel.json.JSONException;
import org.gcube.application.aquamaps.aquamapsservice.stubs.datamodel.json.JSONObject;
import org.gcube.application.aquamaps.aquamapsservice.stubs.datamodel.types.FieldType;
import org.gcube.application.aquamaps.datamodel.FieldArray;

@XStreamAlias(value="Field")
public class Field
extends DataModel
implements Comparable<Field> {
    public static final String VOID = "VOID";
    @XStreamAsAttribute
    private FieldType type = FieldType.STRING;
    @XStreamAsAttribute
    private String name;
    @XStreamAsAttribute
    private String value;

    public FieldType getType() {
        return this.type;
    }

    public Field() {
        this.type = FieldType.STRING;
        this.name = "DefaultFieldName";
        this.value = "DefaultValue";
    }

    public Field(String name, String value) {
        this();
        this.name = name;
        this.value = value;
    }

    public Field(String name, String value, FieldType type) {
        this(name, value);
        this.setType(type);
    }

    public void setType(FieldType type) {
        this.type = type;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public static List<Field> load(FieldArray toLoad) {
        ArrayList<Field> toReturn = new ArrayList<Field>();
        if (toLoad != null && toLoad.getFields() != null) {
            for (org.gcube.application.aquamaps.datamodel.Field f : toLoad.getFields()) {
                toReturn.add(new Field(f));
            }
        }
        return toReturn;
    }

    public static FieldArray toStubsVersion(Collection<Field> collection) {
        ArrayList<org.gcube.application.aquamaps.datamodel.Field> list = new ArrayList<org.gcube.application.aquamaps.datamodel.Field>();
        if (collection != null) {
            for (Field obj : collection) {
                list.add(obj.toStubsVersion());
            }
        }
        return new FieldArray(list.toArray(new org.gcube.application.aquamaps.datamodel.Field[list.size()]));
    }

    public Field(org.gcube.application.aquamaps.datamodel.Field toLoad) {
        this.setName(toLoad.getName());
        this.setType(FieldType.valueOf(toLoad.getType()));
        this.setValue(toLoad.getValue());
    }

    public org.gcube.application.aquamaps.datamodel.Field toStubsVersion() {
        org.gcube.application.aquamaps.datamodel.Field toReturn = new org.gcube.application.aquamaps.datamodel.Field();
        toReturn.setName(this.getName());
        toReturn.setType(this.getType().toString());
        toReturn.setValue(this.getValue());
        return toReturn;
    }

    public String getOperator() {
        if (this.name.contains("min")) {
            return ">=";
        }
        if (this.name.contains("max")) {
            return "<=";
        }
        return "=";
    }

    public static List<Field> loadRow(ResultSet rs) throws Exception {
        ArrayList<Field> toReturn = new ArrayList<Field>();
        ResultSetMetaData rsMeta = rs.getMetaData();
        int colCount = rsMeta.getColumnCount();
        for (int i = 1; i <= colCount; ++i) {
            toReturn.add(new Field(rsMeta.getColumnName(i), rs.getString(i), Field.getType(rsMeta.getColumnType(i))));
        }
        return toReturn;
    }

    public static FieldType getType(int SQLType2) {
        if (SQLType2 == -5 || SQLType2 == -6 || SQLType2 == 5 || SQLType2 == 4 || SQLType2 == -7 || SQLType2 == 93) {
            return FieldType.INTEGER;
        }
        if (SQLType2 == 6 || SQLType2 == 8 || SQLType2 == 7 || SQLType2 == 3 || SQLType2 == 2) {
            return FieldType.DOUBLE;
        }
        if (SQLType2 == 16) {
            return FieldType.BOOLEAN;
        }
        return FieldType.STRING;
    }

    public static List<List<Field>> loadResultSet(ResultSet rs) throws SQLException {
        ArrayList<List<Field>> toReturn = new ArrayList<List<Field>>();
        ResultSetMetaData rsMeta = rs.getMetaData();
        int colCount = rsMeta.getColumnCount();
        while (rs.next()) {
            ArrayList<Field> row = new ArrayList<Field>();
            for (int i = 1; i <= colCount; ++i) {
                row.add(new Field(rsMeta.getColumnName(i), rs.getString(i), Field.getType(rsMeta.getColumnType(i))));
            }
            toReturn.add(row);
        }
        return toReturn;
    }

    public Double getValueAsDouble() {
        try {
            return Double.parseDouble(this.getValue());
        }
        catch (Exception e) {
            return null;
        }
    }

    public Integer getValueAsInteger() {
        try {
            return Integer.parseInt(this.getValue());
        }
        catch (Exception e) {
            return null;
        }
    }

    public Long getValueAsLong() {
        try {
            return Long.parseLong(this.getValue());
        }
        catch (Exception e) {
            return null;
        }
    }

    public Boolean getValueAsBoolean() {
        if (this.getValue().equalsIgnoreCase("false") || this.getValue().equalsIgnoreCase("true")) {
            return Boolean.parseBoolean(this.getValue());
        }
        Integer i = this.getValueAsInteger();
        if (i != null) {
            return i.equals(1);
        }
        return null;
    }

    public Double getValueAsDouble(String defaultValue) {
        try {
            return Double.parseDouble(this.getValue());
        }
        catch (Exception e) {
            return Double.parseDouble(defaultValue);
        }
    }

    public Integer getValueAsInteger(String defaultValue) {
        try {
            return Integer.parseInt(this.getValue());
        }
        catch (Exception e) {
            return Integer.parseInt(defaultValue);
        }
    }

    public Long getValueAsLong(String defaultValue) {
        try {
            return Long.parseLong(this.getValue());
        }
        catch (Exception e) {
            return Long.parseLong(defaultValue);
        }
    }

    public Boolean getValueAsBoolean(String defaultValue) {
        try {
            return Boolean.parseBoolean(this.getValue());
        }
        catch (Exception e) {
            Integer i = this.getValueAsInteger();
            if (i != null) {
                return i == 1;
            }
            return Boolean.parseBoolean(defaultValue);
        }
    }

    public JSONObject toJSONObject() throws JSONException {
        JSONObject toReturn = new JSONObject();
        toReturn.put("name", this.name);
        toReturn.put("value", this.value);
        toReturn.put("type", (Object)this.type);
        return toReturn;
    }

    public Field(JSONObject obj) throws JSONException {
        this.setName(obj.getString("name"));
        this.setType(FieldType.valueOf(obj.getString("type")));
        this.setValue(obj.getString("value"));
    }

    public static ArrayList<Field> fromJSONArray(JSONArray array) throws JSONException {
        ArrayList<Field> toReturn = new ArrayList<Field>();
        for (int i = 0; i < array.length(); ++i) {
            toReturn.add(new Field(array.getJSONObject(i)));
        }
        return toReturn;
    }

    public static JSONArray toJSONArray(List<Field> list) throws JSONException {
        JSONArray array = new JSONArray();
        for (Field f : list) {
            array.put(f.toJSONObject());
        }
        return array;
    }

    @Override
    public int compareTo(Field arg0) {
        return this.getName().compareTo(arg0.getName());
    }
}

