/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.application.aquamaps.aquamapsservice.stubs.datamodel.enhanced;

import com.thoughtworks.xstream.annotations.XStreamAlias;
import com.thoughtworks.xstream.annotations.XStreamImplicit;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.gcube.application.aquamaps.aquamapsservice.stubs.datamodel.enhanced.DataModel;
import org.gcube.application.aquamaps.aquamapsservice.stubs.datamodel.enhanced.Envelope;
import org.gcube.application.aquamaps.aquamapsservice.stubs.datamodel.enhanced.Field;
import org.gcube.application.aquamaps.aquamapsservice.stubs.datamodel.fields.EnvelopeFields;
import org.gcube.application.aquamaps.aquamapsservice.stubs.datamodel.fields.HspenFields;
import org.gcube.application.aquamaps.aquamapsservice.stubs.datamodel.fields.SpeciesOccursumFields;
import org.gcube.application.aquamaps.aquamapsservice.stubs.datamodel.json.JSONArray;
import org.gcube.application.aquamaps.aquamapsservice.stubs.datamodel.json.JSONException;
import org.gcube.application.aquamaps.aquamapsservice.stubs.datamodel.json.JSONObject;
import org.gcube.application.aquamaps.datamodel.Specie;
import org.gcube.application.aquamaps.datamodel.SpeciesArray;

@XStreamAlias(value="Species")
public class Species
extends DataModel
implements Comparable<Species> {
    private String id;
    @XStreamImplicit
    private List<Field> attributesList = new ArrayList<Field>();

    public List<Field> getAttributesList() {
        if (this.attributesList == null) {
            this.attributesList = new ArrayList<Field>();
        }
        return this.attributesList;
    }

    public void setAttributesList(List<Field> attributesList) {
        this.attributesList = attributesList;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getId() {
        return this.id;
    }

    public Field getFieldbyName(String fieldName) {
        for (Field field : this.getAttributesList()) {
            if (!field.getName().equals(fieldName)) continue;
            return field;
        }
        return new Field(fieldName, "VOID");
    }

    public void addField(Field toAddField) {
        this.getAttributesList().add(toAddField);
    }

    public Envelope extractEnvelope() {
        Double s;
        Double w;
        Double n;
        Envelope toReturn = new Envelope();
        for (EnvelopeFields envelopeField : EnvelopeFields.values()) {
            for (HspenFields paramName : toReturn.getValueNames(envelopeField)) {
                toReturn.setValue(envelopeField, paramName, Double.parseDouble(this.getFieldbyName(paramName.toString()).getValue()));
            }
        }
        Double e = this.getFieldbyName((Object)((Object)HspenFields.emostlong) + "").getValueAsDouble();
        if (e != null) {
            toReturn.getBoundingBox().setE(e);
        }
        if ((n = this.getFieldbyName((Object)((Object)HspenFields.nmostlat) + "").getValueAsDouble()) != null) {
            toReturn.getBoundingBox().setN(n);
        }
        if ((w = this.getFieldbyName((Object)((Object)HspenFields.wmostlong) + "").getValueAsDouble()) != null) {
            toReturn.getBoundingBox().setW(w);
        }
        if ((s = this.getFieldbyName((Object)((Object)HspenFields.smostlat) + "").getValueAsDouble()) != null) {
            toReturn.getBoundingBox().setS(s);
        }
        toReturn.setFaoAreas(this.getFieldbyName((Object)((Object)HspenFields.faoareas) + "").getValue());
        toReturn.setPelagic(Boolean.parseBoolean(this.getFieldbyName((Object)((Object)HspenFields.pelagic) + "").getValue()));
        toReturn.setUseBottomSeaTempAndSalinity(this.getFieldbyName((Object)((Object)HspenFields.layer) + "").getValue().equalsIgnoreCase("b"));
        return toReturn;
    }

    public JSONObject toJSONObject() throws JSONException {
        JSONObject obj = new JSONObject();
        obj.put((Object)((Object)SpeciesOccursumFields.speciesid) + "", this.id);
        JSONArray array = new JSONArray();
        for (Field f : this.getAttributesList()) {
            array.put(f.toJSONObject());
        }
        obj.put("Fields", array);
        return obj;
    }

    public Species(JSONObject obj) throws JSONException {
        this(obj.getString((Object)((Object)SpeciesOccursumFields.speciesid) + ""));
        JSONArray array = obj.getJSONArray("Fields");
        for (int i = 0; i < array.length(); ++i) {
            this.addField(new Field(array.getJSONObject(i)));
        }
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Species)) {
            return false;
        }
        Species other = (Species)obj;
        return !(this.id == null ? other.id != null : !this.id.equals(other.id));
    }

    public Species(Specie toLoad) {
        this.setId(toLoad.getId());
        this.getAttributesList().addAll(Field.load(toLoad.getAdditionalField()));
    }

    public static List<Species> load(SpeciesArray toLoad) {
        ArrayList<Species> toReturn = new ArrayList<Species>();
        if (toLoad != null && toLoad.getSpeciesList() != null) {
            for (Specie s : toLoad.getSpeciesList()) {
                toReturn.add(new Species(s));
            }
        }
        return toReturn;
    }

    public static SpeciesArray toStubsVersion(Set<Species> toConvert) {
        ArrayList<Specie> list = new ArrayList<Specie>();
        if (toConvert != null) {
            for (Species obj : toConvert) {
                list.add(obj.toStubsVersion());
            }
        }
        return new SpeciesArray(list.toArray(new Specie[list.size()]));
    }

    public Specie toStubsVersion() {
        Specie toReturn = new Specie();
        toReturn.setAdditionalField(Field.toStubsVersion(this.getAttributesList()));
        toReturn.setId(this.id);
        return toReturn;
    }

    public Species(String speciesId) {
        this.id = speciesId;
    }

    @Override
    public int compareTo(Species arg0) {
        if (arg0 == null) {
            throw new NullPointerException("Cannot compare a null Species");
        }
        if (this.id == null || arg0.getId() == null) {
            throw new NullPointerException("Either current or compared Species has null Id");
        }
        return this.id.compareTo(arg0.getId());
    }
}

