/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.application.aquamaps.aquamapsservice.stubs.datamodel.enhanced;

import com.thoughtworks.xstream.annotations.XStreamAlias;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.gcube.application.aquamaps.aquamapsservice.stubs.datamodel.enhanced.DataModel;
import org.gcube.application.aquamaps.aquamapsservice.stubs.datamodel.enhanced.Field;
import org.gcube.application.aquamaps.aquamapsservice.stubs.datamodel.fields.MetaSourceFields;
import org.gcube.application.aquamaps.aquamapsservice.stubs.datamodel.json.JSONArray;
import org.gcube.application.aquamaps.aquamapsservice.stubs.datamodel.json.JSONException;
import org.gcube.application.aquamaps.aquamapsservice.stubs.datamodel.types.AlgorithmType;
import org.gcube.application.aquamaps.aquamapsservice.stubs.datamodel.types.FieldType;
import org.gcube.application.aquamaps.aquamapsservice.stubs.datamodel.types.ResourceStatus;
import org.gcube.application.aquamaps.aquamapsservice.stubs.datamodel.types.ResourceType;
import org.gcube.application.aquamaps.aquamapsservice.stubs.datamodel.utils.CSVUtils;
import org.gcube.application.aquamaps.datamodel.ResourceArray;
import org.gcube.common.core.utils.logging.GCUBELog;

@XStreamAlias(value="Resource")
public class Resource
extends DataModel {
    static GCUBELog logger = new GCUBELog(Resource.class);
    private ResourceType type = ResourceType.HCAF;
    private static final AlgorithmType DEFAULT_ALGORITHM_TYPE = AlgorithmType.NativeRange;
    private int searchId = 1;
    private String title;
    private String tableName;
    private String description;
    private String author;
    private String disclaimer;
    private String provenance;
    private Long generationTime = 0L;
    private ArrayList<Integer> sourceHCAFIds = new ArrayList();
    private ArrayList<Integer> sourceHSPENIds = new ArrayList();
    private ArrayList<Integer> sourceHSPECIds = new ArrayList();
    private ArrayList<Integer> sourceOccurrenceCellsIds = new ArrayList();
    private ArrayList<Field> parameters = new ArrayList();
    private ResourceStatus status = ResourceStatus.Completed;
    private ArrayList<String> sourceHSPECTables = new ArrayList();
    private ArrayList<String> sourceHSPENTables = new ArrayList();
    private ArrayList<String> sourceHCAFTables = new ArrayList();
    private ArrayList<String> sourceOccurrenceCellsTables = new ArrayList();
    private AlgorithmType algorithm = DEFAULT_ALGORITHM_TYPE;
    private Boolean defaultSource = false;
    private Long rowCount = 0L;

    public Resource(ResourceType type, int searchId) {
        this.type = type;
        this.searchId = searchId;
    }

    public Resource(org.gcube.application.aquamaps.datamodel.Resource toLoad) {
        try {
            this.setAlgorithm(AlgorithmType.valueOf(toLoad.getAlgorithm()));
        }
        catch (Exception e) {
            this.setAlgorithm(DEFAULT_ALGORITHM_TYPE);
        }
        this.setAuthor(toLoad.getAuthor());
        this.setGenerationTime(toLoad.getDate());
        this.setDescription(toLoad.getDescription());
        this.setDisclaimer(toLoad.getDisclaimer());
        try {
            this.parameters.addAll(Field.fromJSONArray(new JSONArray(toLoad.getParameters())));
        }
        catch (Exception e) {
            logger.warn((Object)"Unable to parse parameters", (Throwable)e);
        }
        this.setProvenance(toLoad.getProvenance());
        this.setSearchId(toLoad.getSearchId());
        try {
            this.sourceHCAFIds = CSVUtils.CSVTOIntegerList(toLoad.getSourceHCAFIds());
            Collections.sort(this.sourceHCAFIds);
        }
        catch (Exception e) {
            logger.warn((Object)("Unable to load CSVLIST " + toLoad.getSourceHCAFIds()), (Throwable)e);
        }
        try {
            this.sourceHSPENIds = CSVUtils.CSVTOIntegerList(toLoad.getSourceHSPENIds());
            Collections.sort(this.sourceHSPENIds);
        }
        catch (Exception e) {
            logger.warn((Object)("Unable to load CSVLIST " + toLoad.getSourceHSPENIds()), (Throwable)e);
        }
        try {
            this.sourceHSPECIds = CSVUtils.CSVTOIntegerList(toLoad.getSourceHSPECIds());
            Collections.sort(this.sourceHSPECIds);
        }
        catch (Exception e) {
            logger.warn((Object)("Unable to load CSVLIST " + toLoad.getSourceHSPECIds()), (Throwable)e);
        }
        try {
            this.sourceOccurrenceCellsIds = CSVUtils.CSVTOIntegerList(toLoad.getSourceOccurrenceCellsIds());
            Collections.sort(this.sourceOccurrenceCellsIds);
        }
        catch (Exception e) {
            logger.warn((Object)("Unable to load CSVLIST " + toLoad.getSourceOccurrenceCellsIds()), (Throwable)e);
        }
        try {
            this.sourceHCAFTables = CSVUtils.CSVToStringList(toLoad.getSourceHCAFTables());
            Collections.sort(this.sourceHCAFTables);
        }
        catch (Exception e) {
            logger.warn((Object)("Unable to load CSVLIST " + toLoad.getSourceHCAFTables()), (Throwable)e);
        }
        try {
            this.sourceHSPECTables = CSVUtils.CSVToStringList(toLoad.getSourceHSPECTables());
            Collections.sort(this.sourceHSPECTables);
        }
        catch (Exception e) {
            logger.warn((Object)("Unable to load CSVLIST " + toLoad.getSourceHSPECTables()), (Throwable)e);
        }
        try {
            this.sourceHSPENTables = CSVUtils.CSVToStringList(toLoad.getSourceHSPENTables());
            Collections.sort(this.sourceHSPENTables);
        }
        catch (Exception e) {
            logger.warn((Object)("Unable to load CSVLIST " + toLoad.getSourceHSPENTables()), (Throwable)e);
        }
        try {
            this.sourceOccurrenceCellsTables = CSVUtils.CSVToStringList(toLoad.getSourceOccurrenceCellsTables());
            Collections.sort(this.sourceOccurrenceCellsTables);
        }
        catch (Exception e) {
            logger.warn((Object)("Unable to load CSVLIST " + toLoad.getSourceOccurrenceCellsTables()), (Throwable)e);
        }
        this.setStatus(ResourceStatus.valueOf(toLoad.getStatus()));
        this.setTableName(toLoad.getTableName());
        this.setTitle(toLoad.getTitle());
        this.setType(ResourceType.valueOf(toLoad.getType()));
        this.setDefaultSource(toLoad.isDefaultSource());
        this.setRowCount(toLoad.getPercent());
    }

    public org.gcube.application.aquamaps.datamodel.Resource toStubsVersion() throws JSONException {
        org.gcube.application.aquamaps.datamodel.Resource toReturn = new org.gcube.application.aquamaps.datamodel.Resource();
        toReturn.setAlgorithm((Object)((Object)this.getAlgorithm()) + "");
        toReturn.setAuthor(this.getAuthor());
        toReturn.setDate(this.generationTime != null ? this.generationTime : 0L);
        toReturn.setDescription(this.getDescription());
        toReturn.setDisclaimer(this.getDisclaimer());
        toReturn.setParameters(Field.toJSONArray(this.parameters).toString());
        toReturn.setProvenance(this.getProvenance());
        toReturn.setSearchId(this.getSearchId());
        toReturn.setSourceHCAFIds(CSVUtils.listToCSV(this.sourceHCAFIds));
        toReturn.setSourceHSPENIds(CSVUtils.listToCSV(this.sourceHSPENIds));
        toReturn.setSourceHSPECIds(CSVUtils.listToCSV(this.sourceHSPECIds));
        toReturn.setSourceHSPENTables(CSVUtils.listToCSV(this.sourceHSPENTables));
        toReturn.setSourceHCAFTables(CSVUtils.listToCSV(this.sourceHCAFTables));
        toReturn.setSourceHSPECTables(CSVUtils.listToCSV(this.sourceHSPECTables));
        toReturn.setStatus((Object)((Object)this.getStatus()) + "");
        toReturn.setTableName(this.getTableName());
        toReturn.setTitle(this.getTitle());
        toReturn.setType(this.getType().toString());
        toReturn.setDefaultSource(this.getDefaultSource());
        toReturn.setSourceOccurrenceCellsIds(CSVUtils.listToCSV(this.sourceOccurrenceCellsIds));
        toReturn.setSourceOccurrenceCellsTables(CSVUtils.listToCSV(this.sourceOccurrenceCellsTables));
        toReturn.setPercent(this.getRowCount());
        return toReturn;
    }

    public static List<Resource> load(ResourceArray toLoad) {
        ArrayList<Resource> toReturn = new ArrayList<Resource>();
        if (toLoad != null && toLoad.getResourceList() != null) {
            for (org.gcube.application.aquamaps.datamodel.Resource f : toLoad.getResourceList()) {
                toReturn.add(new Resource(f));
            }
        }
        return toReturn;
    }

    public static ResourceArray toStubsVersion(List<Resource> toConvert) throws JSONException {
        ArrayList<org.gcube.application.aquamaps.datamodel.Resource> list = new ArrayList<org.gcube.application.aquamaps.datamodel.Resource>();
        if (toConvert != null) {
            for (Resource obj : toConvert) {
                list.add(obj.toStubsVersion());
            }
        }
        return new ResourceArray(list.toArray(new org.gcube.application.aquamaps.datamodel.Resource[list.size()]));
    }

    public Resource(ResultSet rs) throws Exception {
        for (Field f : Field.loadRow(rs)) {
            try {
                this.setField(f);
            }
            catch (Exception e) {}
        }
    }

    public boolean setField(Field f) throws JSONException {
        try {
            switch (MetaSourceFields.valueOf(f.getName().toLowerCase())) {
                case searchid: {
                    this.setSearchId(f.getValueAsInteger());
                    break;
                }
                case title: {
                    this.setTitle(f.getValue());
                    break;
                }
                case tablename: {
                    this.setTableName(f.getValue());
                    break;
                }
                case description: {
                    this.setDescription(f.getValue());
                    break;
                }
                case author: {
                    this.setAuthor(f.getValue());
                    break;
                }
                case disclaimer: {
                    this.setDisclaimer(f.getValue());
                    break;
                }
                case provenience: {
                    this.setProvenance(f.getValue());
                    break;
                }
                case generationtime: {
                    this.setGenerationTime(f.getValueAsLong());
                    break;
                }
                case sourcehcafids: {
                    this.sourceHCAFIds = CSVUtils.CSVTOIntegerList(f.getValue());
                    break;
                }
                case sourcehspenids: {
                    this.sourceHSPENIds = CSVUtils.CSVTOIntegerList(f.getValue());
                    break;
                }
                case sourcehspecids: {
                    this.sourceHSPECIds = CSVUtils.CSVTOIntegerList(f.getValue());
                    break;
                }
                case parameters: {
                    this.parameters = Field.fromJSONArray(new JSONArray(f.getValue()));
                    break;
                }
                case status: {
                    this.setStatus(ResourceStatus.valueOf(f.getValue()));
                    break;
                }
                case sourcehcaftables: {
                    this.sourceHCAFTables = CSVUtils.CSVToStringList(f.getValue());
                    break;
                }
                case sourcehspentables: {
                    this.sourceHSPENTables = CSVUtils.CSVToStringList(f.getValue());
                    break;
                }
                case sourcehspectables: {
                    this.sourceHSPECTables = CSVUtils.CSVToStringList(f.getValue());
                    break;
                }
                case type: {
                    this.setType(ResourceType.valueOf(f.getValue()));
                    break;
                }
                case algorithm: {
                    try {
                        this.setAlgorithm(AlgorithmType.valueOf(f.getValue()));
                    }
                    catch (Exception e) {}
                    break;
                }
                case defaultsource: {
                    this.setDefaultSource(f.getValueAsBoolean());
                    break;
                }
                case rowcount: {
                    this.setRowCount(f.getValueAsLong());
                    break;
                }
                case sourceoccurrencecellsids: {
                    this.sourceOccurrenceCellsIds = CSVUtils.CSVTOIntegerList(f.getValue());
                    break;
                }
                case sourceoccurrencecellstables: {
                    this.sourceOccurrenceCellsTables = CSVUtils.CSVToStringList(f.getValue());
                    break;
                }
                default: {
                    return false;
                }
            }
        }
        catch (Exception e) {
            logger.warn((Object)("Unable to parse field " + f.toJSONObject()), (Throwable)e);
        }
        return true;
    }

    public Field getField(MetaSourceFields fieldName) throws JSONException {
        switch (fieldName) {
            case searchid: {
                return new Field((Object)((Object)fieldName) + "", this.getSearchId() + "", FieldType.INTEGER);
            }
            case title: {
                return new Field((Object)((Object)fieldName) + "", this.getTitle(), FieldType.STRING);
            }
            case tablename: {
                return new Field((Object)((Object)fieldName) + "", this.getTableName(), FieldType.STRING);
            }
            case description: {
                return new Field((Object)((Object)fieldName) + "", this.getDescription(), FieldType.STRING);
            }
            case author: {
                return new Field((Object)((Object)fieldName) + "", this.getAuthor(), FieldType.STRING);
            }
            case disclaimer: {
                return new Field((Object)((Object)fieldName) + "", this.getDisclaimer(), FieldType.STRING);
            }
            case provenience: {
                return new Field((Object)((Object)fieldName) + "", this.getProvenance(), FieldType.STRING);
            }
            case generationtime: {
                return new Field((Object)((Object)fieldName) + "", this.getGenerationTime() + "", FieldType.LONG);
            }
            case sourcehcafids: {
                return new Field((Object)((Object)fieldName) + "", CSVUtils.listToCSV(this.sourceHCAFIds) + "", FieldType.STRING);
            }
            case sourcehspenids: {
                return new Field((Object)((Object)fieldName) + "", CSVUtils.listToCSV(this.sourceHSPENIds) + "", FieldType.STRING);
            }
            case sourcehspecids: {
                return new Field((Object)((Object)fieldName) + "", CSVUtils.listToCSV(this.sourceHSPECIds) + "", FieldType.STRING);
            }
            case parameters: {
                return new Field((Object)((Object)fieldName) + "", Field.toJSONArray(this.parameters).toString(), FieldType.STRING);
            }
            case status: {
                return new Field((Object)((Object)fieldName) + "", (Object)((Object)this.getStatus()) + "", FieldType.STRING);
            }
            case sourcehcaftables: {
                return new Field((Object)((Object)fieldName) + "", CSVUtils.listToCSV(this.sourceHCAFTables), FieldType.STRING);
            }
            case sourcehspentables: {
                return new Field((Object)((Object)fieldName) + "", CSVUtils.listToCSV(this.sourceHSPENTables), FieldType.STRING);
            }
            case sourcehspectables: {
                return new Field((Object)((Object)fieldName) + "", CSVUtils.listToCSV(this.sourceHSPECTables), FieldType.STRING);
            }
            case type: {
                return new Field((Object)((Object)fieldName) + "", (Object)((Object)this.getType()) + "", FieldType.STRING);
            }
            case algorithm: {
                return new Field((Object)((Object)fieldName) + "", (Object)((Object)this.getAlgorithm()) + "", FieldType.STRING);
            }
            case defaultsource: {
                return new Field((Object)((Object)fieldName) + "", this.getDefaultSource() + "", FieldType.BOOLEAN);
            }
            case sourceoccurrencecellsids: {
                return new Field((Object)((Object)fieldName) + "", CSVUtils.listToCSV(this.sourceOccurrenceCellsIds), FieldType.STRING);
            }
            case sourceoccurrencecellstables: {
                return new Field((Object)((Object)fieldName) + "", CSVUtils.listToCSV(this.sourceOccurrenceCellsTables), FieldType.STRING);
            }
            case rowcount: {
                return new Field((Object)((Object)fieldName) + "", this.getRowCount() + "", FieldType.LONG);
            }
        }
        return null;
    }

    public List<Field> toRow() throws JSONException {
        ArrayList<Field> toReturn = new ArrayList<Field>();
        for (MetaSourceFields f : MetaSourceFields.values()) {
            toReturn.add(this.getField(f));
        }
        return toReturn;
    }

    public ResourceType getType() {
        return this.type;
    }

    public void setType(ResourceType type) {
        this.type = type;
    }

    public int getSearchId() {
        return this.searchId;
    }

    public void setSearchId(int searchId) {
        this.searchId = searchId;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getTableName() {
        return this.tableName;
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getAuthor() {
        return this.author;
    }

    public void setAuthor(String author) {
        this.author = author;
    }

    public String getDisclaimer() {
        return this.disclaimer;
    }

    public void setDisclaimer(String disclaimer) {
        this.disclaimer = disclaimer;
    }

    public String getProvenance() {
        return this.provenance;
    }

    public void setProvenance(String provenance) {
        this.provenance = provenance;
    }

    public Long getGenerationTime() {
        return this.generationTime;
    }

    public void setGenerationTime(Long generationTime) {
        this.generationTime = generationTime;
    }

    public ArrayList<Integer> getSourceHCAFIds() {
        return this.sourceHCAFIds;
    }

    public void setSourceHCAFIds(ArrayList<Integer> sourceHCAFIds) {
        this.sourceHCAFIds = sourceHCAFIds;
    }

    public ArrayList<Integer> getSourceHSPECIds() {
        return this.sourceHSPECIds;
    }

    public void setSourceHSPECIds(ArrayList<Integer> sourceHSPECIds) {
        this.sourceHSPECIds = sourceHSPECIds;
    }

    public ArrayList<Field> getParameters() {
        return this.parameters;
    }

    public void setParameters(ArrayList<Field> parameters) {
        this.parameters = parameters;
    }

    public ResourceStatus getStatus() {
        return this.status;
    }

    public void setStatus(ResourceStatus status) {
        this.status = status;
    }

    public AlgorithmType getAlgorithm() {
        return this.algorithm;
    }

    public void setAlgorithm(AlgorithmType algorithm) {
        this.algorithm = algorithm;
    }

    public Boolean getDefaultSource() {
        return this.defaultSource;
    }

    public void setDefaultSource(Boolean defaultSource) {
        this.defaultSource = defaultSource;
    }

    public Long getRowCount() {
        return this.rowCount;
    }

    public void setRowCount(Long rowCount) {
        this.rowCount = rowCount;
    }

    public static AlgorithmType getDefaultAlgorithmType() {
        return DEFAULT_ALGORITHM_TYPE;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.algorithm == null ? 0 : this.algorithm.hashCode());
        result = 31 * result + (this.author == null ? 0 : this.author.hashCode());
        result = 31 * result + (this.defaultSource == null ? 0 : this.defaultSource.hashCode());
        result = 31 * result + (this.description == null ? 0 : this.description.hashCode());
        result = 31 * result + (this.disclaimer == null ? 0 : this.disclaimer.hashCode());
        result = 31 * result + (this.generationTime == null ? 0 : this.generationTime.hashCode());
        result = 31 * result + (this.parameters == null ? 0 : this.parameters.hashCode());
        result = 31 * result + (this.provenance == null ? 0 : this.provenance.hashCode());
        result = 31 * result + (this.rowCount == null ? 0 : this.rowCount.hashCode());
        result = 31 * result + this.searchId;
        result = 31 * result + (this.sourceHCAFIds == null ? 0 : this.sourceHCAFIds.hashCode());
        result = 31 * result + (this.sourceHCAFTables == null ? 0 : this.sourceHCAFTables.hashCode());
        result = 31 * result + (this.sourceHSPECIds == null ? 0 : this.sourceHSPECIds.hashCode());
        result = 31 * result + (this.sourceHSPECTables == null ? 0 : this.sourceHSPECTables.hashCode());
        result = 31 * result + (this.sourceHSPENIds == null ? 0 : this.sourceHSPENIds.hashCode());
        result = 31 * result + (this.sourceHSPENTables == null ? 0 : this.sourceHSPENTables.hashCode());
        result = 31 * result + (this.sourceOccurrenceCellsIds == null ? 0 : this.sourceOccurrenceCellsIds.hashCode());
        result = 31 * result + (this.sourceOccurrenceCellsTables == null ? 0 : this.sourceOccurrenceCellsTables.hashCode());
        result = 31 * result + (this.status == null ? 0 : this.status.hashCode());
        result = 31 * result + (this.tableName == null ? 0 : this.tableName.hashCode());
        result = 31 * result + (this.title == null ? 0 : this.title.hashCode());
        result = 31 * result + (this.type == null ? 0 : this.type.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Resource other = (Resource)obj;
        if (this.algorithm != other.algorithm) {
            return false;
        }
        if (this.author == null ? other.author != null : !this.author.equals(other.author)) {
            return false;
        }
        if (this.defaultSource == null ? other.defaultSource != null : !this.defaultSource.equals(other.defaultSource)) {
            return false;
        }
        if (this.description == null ? other.description != null : !this.description.equals(other.description)) {
            return false;
        }
        if (this.disclaimer == null ? other.disclaimer != null : !this.disclaimer.equals(other.disclaimer)) {
            return false;
        }
        if (this.generationTime == null ? other.generationTime != null : !this.generationTime.equals(other.generationTime)) {
            return false;
        }
        if (this.parameters == null ? other.parameters != null : !this.parameters.equals(other.parameters)) {
            return false;
        }
        if (this.provenance == null ? other.provenance != null : !this.provenance.equals(other.provenance)) {
            return false;
        }
        if (this.rowCount == null ? other.rowCount != null : !this.rowCount.equals(other.rowCount)) {
            return false;
        }
        if (this.searchId != other.searchId) {
            return false;
        }
        if (this.sourceHCAFIds == null ? other.sourceHCAFIds != null : !this.sourceHCAFIds.equals(other.sourceHCAFIds)) {
            return false;
        }
        if (this.sourceHCAFTables == null ? other.sourceHCAFTables != null : !this.sourceHCAFTables.equals(other.sourceHCAFTables)) {
            return false;
        }
        if (this.sourceHSPECIds == null ? other.sourceHSPECIds != null : !this.sourceHSPECIds.equals(other.sourceHSPECIds)) {
            return false;
        }
        if (this.sourceHSPECTables == null ? other.sourceHSPECTables != null : !this.sourceHSPECTables.equals(other.sourceHSPECTables)) {
            return false;
        }
        if (this.sourceHSPENIds == null ? other.sourceHSPENIds != null : !this.sourceHSPENIds.equals(other.sourceHSPENIds)) {
            return false;
        }
        if (this.sourceHSPENTables == null ? other.sourceHSPENTables != null : !this.sourceHSPENTables.equals(other.sourceHSPENTables)) {
            return false;
        }
        if (this.sourceOccurrenceCellsIds == null ? other.sourceOccurrenceCellsIds != null : !this.sourceOccurrenceCellsIds.equals(other.sourceOccurrenceCellsIds)) {
            return false;
        }
        if (this.sourceOccurrenceCellsTables == null ? other.sourceOccurrenceCellsTables != null : !this.sourceOccurrenceCellsTables.equals(other.sourceOccurrenceCellsTables)) {
            return false;
        }
        if (this.status != other.status) {
            return false;
        }
        if (this.tableName == null ? other.tableName != null : !this.tableName.equals(other.tableName)) {
            return false;
        }
        if (this.title == null ? other.title != null : !this.title.equals(other.title)) {
            return false;
        }
        return this.type == other.type;
    }

    public ArrayList<Integer> getSourceHSPENIds() {
        return this.sourceHSPENIds;
    }

    public void setSourceHSPENIds(ArrayList<Integer> sourceHSPENIds) {
        this.sourceHSPENIds = sourceHSPENIds;
        Collections.sort(this.sourceHSPENIds);
    }

    public ArrayList<Integer> getSourceOccurrenceCellsIds() {
        return this.sourceOccurrenceCellsIds;
    }

    public void setSourceOccurrenceCellsIds(ArrayList<Integer> sourceOccurrenceCellsIds) {
        this.sourceOccurrenceCellsIds = sourceOccurrenceCellsIds;
        Collections.sort(this.sourceOccurrenceCellsIds);
    }

    public ArrayList<String> getSourceHSPECTables() {
        return this.sourceHSPECTables;
    }

    public void setSourceHSPECTables(ArrayList<String> sourceHSPECTables) {
        this.sourceHSPECTables = sourceHSPECTables;
        Collections.sort(this.sourceHSPECTables);
    }

    public ArrayList<String> getSourceHSPENTables() {
        return this.sourceHSPENTables;
    }

    public void setSourceHSPENTables(ArrayList<String> sourceHSPENTables) {
        this.sourceHSPENTables = sourceHSPENTables;
        Collections.sort(this.sourceHSPENTables);
    }

    public ArrayList<String> getSourceHCAFTables() {
        return this.sourceHCAFTables;
    }

    public void setSourceHCAFTables(ArrayList<String> sourceHCAFTables) {
        this.sourceHCAFTables = sourceHCAFTables;
        Collections.sort(this.sourceHCAFTables);
    }

    public ArrayList<String> getSourceOccurrenceCellsTables() {
        return this.sourceOccurrenceCellsTables;
    }

    public void setSourceOccurrenceCellsTables(ArrayList<String> sourceOccurrenceCellsTables) {
        this.sourceOccurrenceCellsTables = sourceOccurrenceCellsTables;
        Collections.sort(this.sourceOccurrenceCellsTables);
    }

    public void addSource(Resource toAdd) {
        ArrayList<String> toModifyNames = null;
        ArrayList<Integer> toModifyIds = null;
        switch (toAdd.getType()) {
            case HCAF: {
                toModifyNames = this.sourceHCAFTables;
                toModifyIds = this.sourceHCAFIds;
                break;
            }
            case HSPEN: {
                toModifyNames = this.sourceHSPENTables;
                toModifyIds = this.sourceHSPENIds;
                break;
            }
            case HSPEC: {
                toModifyNames = this.sourceHSPECTables;
                toModifyIds = this.sourceHSPECIds;
                break;
            }
            case OCCURRENCECELLS: {
                toModifyNames = this.sourceOccurrenceCellsTables;
                toModifyIds = this.sourceOccurrenceCellsIds;
            }
        }
        if (!toModifyIds.contains(toAdd.getSearchId())) {
            toModifyIds.add(toAdd.getSearchId());
            Collections.sort(toModifyIds);
            toModifyNames.add(toAdd.getTableName());
            Collections.sort(toModifyNames);
        }
    }

    public void removeSource(Resource toRemove) {
        this.removeSourceId(toRemove.getSearchId());
        this.removeSourceTableName(toRemove.getTableName());
    }

    public void removeSourceId(Integer id) {
        if (this.sourceHCAFIds.contains(id)) {
            this.sourceHCAFIds.remove(id);
            Collections.sort(this.sourceHCAFIds);
        } else if (this.sourceHSPECIds.contains(id)) {
            this.sourceHSPECIds.remove(id);
            Collections.sort(this.sourceHSPECIds);
        }
        if (this.sourceHSPENIds.contains(id)) {
            this.sourceHSPENIds.remove(id);
            Collections.sort(this.sourceHSPENIds);
        }
        if (this.sourceOccurrenceCellsIds.contains(id)) {
            this.sourceOccurrenceCellsIds.remove(id);
            Collections.sort(this.sourceOccurrenceCellsIds);
        }
    }

    public void removeSourceTableName(String tableName) {
        if (this.sourceHCAFTables.contains(tableName)) {
            this.sourceHCAFTables.remove(tableName);
            Collections.sort(this.sourceHCAFTables);
        } else if (this.sourceHSPECTables.contains(tableName)) {
            this.sourceHSPECTables.remove(tableName);
            Collections.sort(this.sourceHSPECTables);
        }
        if (this.sourceHSPENTables.contains(tableName)) {
            this.sourceHSPENTables.remove(tableName);
            Collections.sort(this.sourceHSPENTables);
        }
        if (this.sourceOccurrenceCellsTables.contains(tableName)) {
            this.sourceOccurrenceCellsTables.remove(tableName);
            Collections.sort(this.sourceOccurrenceCellsTables);
        }
    }

    public String toString() {
        return "Resource [type=" + (Object)((Object)this.type) + ", searchId=" + this.searchId + ", title=" + this.title + ", tableName=" + this.tableName + "]";
    }
}

