/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.application.aquamaps.aquamapsservice.stubs.wrapper;

import java.io.File;
import java.net.URI;
import java.rmi.Remote;
import java.util.ArrayList;
import java.util.List;
import org.gcube.application.aquamaps.aquamapsservice.stubs.AquaMapsServicePortType;
import org.gcube.application.aquamaps.aquamapsservice.stubs.CalculateEnvelopeRequestType;
import org.gcube.application.aquamaps.aquamapsservice.stubs.CalculateEnvelopefromCellSelectionRequestType;
import org.gcube.application.aquamaps.aquamapsservice.stubs.GetAquaMapsPerUserRequestType;
import org.gcube.application.aquamaps.aquamapsservice.stubs.GetOccurrenceCellsRequestType;
import org.gcube.application.aquamaps.aquamapsservice.stubs.GetPhylogenyRequestType;
import org.gcube.application.aquamaps.aquamapsservice.stubs.GetResourceListRequestType;
import org.gcube.application.aquamaps.aquamapsservice.stubs.GetSpeciesByFiltersRequestType;
import org.gcube.application.aquamaps.aquamapsservice.stubs.GetSpeciesEnvelopeRequestType;
import org.gcube.application.aquamaps.aquamapsservice.stubs.datamodel.enhanced.AquaMapsObject;
import org.gcube.application.aquamaps.aquamapsservice.stubs.datamodel.enhanced.Area;
import org.gcube.application.aquamaps.aquamapsservice.stubs.datamodel.enhanced.BoundingBox;
import org.gcube.application.aquamaps.aquamapsservice.stubs.datamodel.enhanced.Envelope;
import org.gcube.application.aquamaps.aquamapsservice.stubs.datamodel.enhanced.Field;
import org.gcube.application.aquamaps.aquamapsservice.stubs.datamodel.enhanced.Filter;
import org.gcube.application.aquamaps.aquamapsservice.stubs.datamodel.enhanced.Job;
import org.gcube.application.aquamaps.aquamapsservice.stubs.datamodel.enhanced.Resource;
import org.gcube.application.aquamaps.aquamapsservice.stubs.datamodel.enhanced.Species;
import org.gcube.application.aquamaps.aquamapsservice.stubs.datamodel.enhanced.Submitted;
import org.gcube.application.aquamaps.aquamapsservice.stubs.datamodel.fields.SpeciesOccursumFields;
import org.gcube.application.aquamaps.aquamapsservice.stubs.datamodel.types.FieldType;
import org.gcube.application.aquamaps.aquamapsservice.stubs.datamodel.types.ObjectType;
import org.gcube.application.aquamaps.aquamapsservice.stubs.datamodel.types.ResourceType;
import org.gcube.application.aquamaps.aquamapsservice.stubs.datamodel.types.SubmittedStatus;
import org.gcube.application.aquamaps.aquamapsservice.stubs.service.AquaMapsServiceAddressingLocator;
import org.gcube.application.aquamaps.aquamapsservice.stubs.wrapper.AquaMapsCall;
import org.gcube.application.aquamaps.aquamapsservice.stubs.wrapper.AquaMapsServiceInterface;
import org.gcube.application.aquamaps.aquamapsservice.stubs.wrapper.PagedRequestSettings;
import org.gcube.application.aquamaps.aquamapsservice.stubs.wrapper.ServiceException;
import org.gcube.application.aquamaps.aquamapsservice.stubs.wrapper.utils.RSWrapper;
import org.gcube.application.aquamaps.datamodel.AquaMap;
import org.gcube.common.core.contexts.GCUBERemotePortTypeContext;
import org.gcube.common.core.faults.GCUBEFault;
import org.gcube.common.core.scope.GCUBEScope;
import org.gcube.common.core.security.GCUBESecurityManager;
import org.gcube.common.core.security.GCUBESecurityManagerImpl;
import org.gcube.common.core.types.StringArray;

public class AquaMapsServiceCall
extends AquaMapsCall
implements AquaMapsServiceInterface {
    private AquaMapsServicePortType pt;

    public static AquaMapsServiceInterface getCall(GCUBEScope scope, GCUBESecurityManager[] securityManager, String defaultURI, boolean queryIS) throws Exception {
        return new AquaMapsServiceCall(scope, securityManager, defaultURI, queryIS);
    }

    public static AquaMapsServiceInterface getCall(GCUBEScope scope, String defaultURI, boolean queryIS) throws Exception {
        GCUBESecurityManagerImpl secMan = new GCUBESecurityManagerImpl(){

            public boolean isSecurityEnabled() {
                return false;
            }
        };
        return new AquaMapsServiceCall(scope, new GCUBESecurityManager[]{secMan}, defaultURI, queryIS);
    }

    private AquaMapsServiceCall(GCUBEScope scope, GCUBESecurityManager[] securityManager, String defaultURI, boolean queryIS) throws Exception {
        super(scope, securityManager, defaultURI, queryIS);
        this.pt = (AquaMapsServicePortType)GCUBERemotePortTypeContext.getProxy((Remote)new AquaMapsServiceAddressingLocator().getAquaMapsServicePortTypePort(this.epr), (GCUBEScope)scope, (int)120000, (GCUBESecurityManager[])securityManager);
    }

    public String getPortTypeName() {
        return "gcube/application/aquamaps/aquamapsservice/AquaMapsService";
    }

    @Override
    public Envelope calculateEnvelope(BoundingBox bb, List<Area> areas, String speciesId, boolean useBottom, boolean useBounding, boolean useFAO) throws Exception {
        try {
            CalculateEnvelopeRequestType request = new CalculateEnvelopeRequestType();
            request.setBoundingEast(bb.getE());
            request.setBoundingNorth(bb.getN());
            request.setBoundingSouth(bb.getS());
            request.setBoundingWest(bb.getW());
            StringBuilder areaSelection = new StringBuilder();
            for (Area a : areas) {
                areaSelection.append(a.getCode() + ",");
            }
            areaSelection.deleteCharAt(areaSelection.lastIndexOf(","));
            request.setFaoAreas(areaSelection.toString());
            request.setSpeciesID(speciesId);
            request.setUseBottomSeaTempAndSalinity(useBottom);
            request.setUseBounding(useBounding);
            request.setUseFAO(useFAO);
            Species s = new Species(speciesId);
            s.getAttributesList().addAll(Field.load(this.pt.calculateEnvelope(request)));
            return s.extractEnvelope();
        }
        catch (GCUBEFault f) {
            logger.error((Object)"Service thrown Fault ", (Throwable)f);
            throw new ServiceException(f.getFaultMessage());
        }
    }

    @Override
    public Envelope calculateEnvelopeFromCellSelection(List<String> cellIds, String speciesId) throws Exception {
        try {
            CalculateEnvelopefromCellSelectionRequestType request = new CalculateEnvelopefromCellSelectionRequestType();
            request.setCellIds(new StringArray(cellIds.toArray(new String[cellIds.size()])));
            request.setSpeciesID(speciesId);
            Species s = new Species(speciesId);
            s.getAttributesList().addAll(Field.load(this.pt.calculateEnvelopefromCellSelection(request)));
            return s.extractEnvelope();
        }
        catch (GCUBEFault f) {
            logger.error((Object)"Service thrown Fault ", (Throwable)f);
            throw new ServiceException(f.getFaultMessage());
        }
    }

    @Override
    public int deleteSubmitted(List<Integer> ids) throws Exception {
        try {
            String[] array = new String[ids.size()];
            for (int i = 0; i < ids.size(); ++i) {
                array[i] = String.valueOf(ids.get(i));
            }
            return this.pt.deleteSubmitted(new StringArray(array));
        }
        catch (GCUBEFault f) {
            logger.error((Object)"Service thrown Fault ", (Throwable)f);
            throw new ServiceException(f.getFaultMessage());
        }
    }

    @Override
    public String getJSONSubmitted(String userName, boolean showObjects, String date, Integer jobId, SubmittedStatus status, ObjectType objType, PagedRequestSettings settings) throws Exception {
        try {
            GetAquaMapsPerUserRequestType request = new GetAquaMapsPerUserRequestType();
            request.setUserID(userName);
            request.setAquamaps(showObjects);
            request.setDateEnabled(date != null);
            if (date != null) {
                request.setDateValue(date);
            }
            request.setJobIdEnabled(jobId != null);
            if (jobId != null) {
                request.setJobIdValue(jobId);
            }
            request.setJobStatusEnabled(false);
            request.setJobStatusValue(null);
            request.setLimit(settings.getLimit());
            request.setObjectStatusEnabled(status != null);
            if (status != null) {
                request.setObjectStatusValue(status.toString());
            }
            request.setOffset(settings.getOffset());
            request.setSortColumn(settings.getOrderColumn());
            request.setSortDirection((Object)((Object)settings.getOrderDirection()) + "");
            request.setTypeEnabled(objType != null);
            if (objType != null) {
                request.setTypeValue(objType.toString());
            }
            return this.pt.getAquaMapsPerUser(request);
        }
        catch (GCUBEFault f) {
            logger.error((Object)"Service thrown Fault ", (Throwable)f);
            throw new ServiceException(f.getFaultMessage());
        }
    }

    @Override
    public String getJSONOccurrenceCells(String speciesId, PagedRequestSettings settings) throws Exception {
        try {
            GetOccurrenceCellsRequestType request = new GetOccurrenceCellsRequestType();
            request.setSpeciesID(speciesId);
            request.setOffset(settings.getOffset());
            request.setSortColumn(settings.getOrderColumn());
            request.setSortDirection((Object)((Object)settings.getOrderDirection()) + "");
            request.setLimit(settings.getLimit());
            return this.pt.getOccurrenceCells(request);
        }
        catch (GCUBEFault f) {
            logger.error((Object)"Service thrown Fault ", (Throwable)f);
            throw new ServiceException(f.getFaultMessage());
        }
    }

    @Override
    public AquaMapsObject loadObject(int objectId) throws Exception {
        try {
            AquaMap returned = this.pt.getObject(objectId);
            return new AquaMapsObject(returned);
        }
        catch (GCUBEFault f) {
            logger.error((Object)"Service thrown Fault ", (Throwable)f);
            throw new ServiceException(f.getFaultMessage());
        }
    }

    @Override
    public Resource loadResource(int resId) throws Exception {
        try {
            Resource request = new Resource(ResourceType.HCAF, resId);
            return new Resource(this.pt.getResourceInfo(request.toStubsVersion()));
        }
        catch (GCUBEFault f) {
            logger.error((Object)"Service thrown Fault ", (Throwable)f);
            throw new ServiceException(f.getFaultMessage());
        }
    }

    @Override
    public String getJSONResources(PagedRequestSettings settings, List<Field> filter) throws Exception {
        try {
            GetResourceListRequestType request = new GetResourceListRequestType();
            request.setFilters(Field.toStubsVersion(filter));
            request.setOffset(settings.getOffset());
            request.setSortColumn(settings.getOrderColumn());
            request.setSortDirection((Object)((Object)settings.getOrderDirection()) + "");
            request.setLimit(settings.getLimit());
            return this.pt.getResourceList(request);
        }
        catch (GCUBEFault f) {
            logger.error((Object)"Service thrown Fault ", (Throwable)f);
            throw new ServiceException(f.getFaultMessage());
        }
    }

    @Override
    public String getJSONSpecies(int hspenId, List<Field> characteristcs, List<Filter> names, List<Filter> codes, PagedRequestSettings settings) throws Exception {
        try {
            GetSpeciesByFiltersRequestType request = new GetSpeciesByFiltersRequestType();
            request.setCharacteristicFilters(Field.toStubsVersion(characteristcs));
            request.setCodeFilters(Filter.toStubsVersion(codes));
            request.setHspen(hspenId);
            request.setNameFilters(Filter.toStubsVersion(names));
            request.setOffset(settings.getOffset());
            request.setSortColumn(settings.getOrderColumn());
            request.setSortDirection((Object)((Object)settings.getOrderDirection()) + "");
            request.setLimit(settings.getLimit());
            return this.pt.getSpeciesByFilters(request);
        }
        catch (GCUBEFault f) {
            logger.error((Object)"Service thrown Fault ", (Throwable)f);
            throw new ServiceException(f.getFaultMessage());
        }
    }

    @Override
    public Species loadEnvelope(String speciesId, int hspenId) throws Exception {
        try {
            Species spec = new Species(speciesId);
            GetSpeciesEnvelopeRequestType req = new GetSpeciesEnvelopeRequestType(hspenId, speciesId);
            spec.getAttributesList().addAll(Field.load(this.pt.getSpeciesEnvelop(req)));
            return spec;
        }
        catch (GCUBEFault f) {
            logger.error((Object)"Service thrown Fault ", (Throwable)f);
            throw new ServiceException(f.getFaultMessage());
        }
    }

    @Override
    public void markSaved(List<Integer> submittedIds) throws Exception {
        try {
            ArrayList<String> ids = new ArrayList<String>();
            for (Integer id : submittedIds) {
                ids.add(String.valueOf(id));
            }
            this.pt.markSaved(new StringArray(ids.toArray(new String[ids.size()])));
        }
        catch (GCUBEFault f) {
            logger.error((Object)"Service thrown Fault ", (Throwable)f);
            throw new ServiceException(f.getFaultMessage());
        }
    }

    @Override
    public void submitJob(Job toSubmit) throws Exception {
        try {
            this.pt.submitJob(toSubmit.toStubsVersion());
        }
        catch (GCUBEFault f) {
            logger.error((Object)"Service thrown Fault ", (Throwable)f);
            throw new ServiceException(f.getFaultMessage());
        }
    }

    @Override
    public Submitted loadSubmittedById(int id) throws Exception {
        try {
            return new Submitted(this.pt.loadSubmittedById(id));
        }
        catch (GCUBEFault f) {
            logger.error((Object)"Service thrown Fault ", (Throwable)f);
            throw new ServiceException(f.getFaultMessage());
        }
    }

    @Override
    public String getJSONPhilogeny(SpeciesOccursumFields level, ArrayList<Field> filters, PagedRequestSettings settings) throws Exception {
        try {
            GetPhylogenyRequestType request = new GetPhylogenyRequestType();
            request.setFieldList(Field.toStubsVersion(filters));
            request.setLimit(settings.getLimit());
            request.setOffset(settings.getOffset());
            request.setSortColumn(settings.getOrderColumn());
            request.setSortDirection((Object)((Object)settings.getOrderDirection()) + "");
            request.setToSelect(new Field((Object)((Object)level) + "", "", FieldType.STRING).toStubsVersion());
            return this.pt.getPhylogeny(request);
        }
        catch (GCUBEFault f) {
            logger.error((Object)"Service thrown Fault ", (Throwable)f);
            throw new ServiceException(f.getFaultMessage());
        }
    }

    @Override
    public File getCSVSpecies(int hspenId, List<Field> characteristcs, List<Filter> names, List<Filter> codes) throws Exception {
        try {
            GetSpeciesByFiltersRequestType request = new GetSpeciesByFiltersRequestType();
            request.setCharacteristicFilters(Field.toStubsVersion(characteristcs));
            request.setCodeFilters(Filter.toStubsVersion(codes));
            request.setHspen(hspenId);
            request.setNameFilters(Filter.toStubsVersion(names));
            String locator = this.pt.getSpeciesByFiltersASCSV(request);
            return RSWrapper.getStreamFromLocator(new URI(locator));
        }
        catch (GCUBEFault f) {
            logger.error((Object)"Service thrown Fault ", (Throwable)f);
            throw new ServiceException(f.getFaultMessage());
        }
    }
}

