/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.application.aquamaps.aquamapsservice.stubs.datamodel.environments;

import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.gcube.application.aquamaps.aquamapsservice.stubs.HspecGroupGenerationRequestType;
import org.gcube.application.aquamaps.aquamapsservice.stubs.datamodel.enhanced.DataModel;
import org.gcube.application.aquamaps.aquamapsservice.stubs.datamodel.enhanced.Field;
import org.gcube.application.aquamaps.aquamapsservice.stubs.datamodel.enhanced.Resource;
import org.gcube.application.aquamaps.aquamapsservice.stubs.datamodel.fields.SourceGenerationRequestFields;
import org.gcube.application.aquamaps.aquamapsservice.stubs.datamodel.json.JSONArray;
import org.gcube.application.aquamaps.aquamapsservice.stubs.datamodel.json.JSONException;
import org.gcube.application.aquamaps.aquamapsservice.stubs.datamodel.types.AlgorithmType;
import org.gcube.application.aquamaps.aquamapsservice.stubs.datamodel.types.FieldType;
import org.gcube.application.aquamaps.aquamapsservice.stubs.datamodel.types.LogicType;
import org.gcube.application.aquamaps.aquamapsservice.stubs.datamodel.types.SourceGenerationPhase;
import org.gcube.application.aquamaps.aquamapsservice.stubs.datamodel.utils.CSVUtils;
import org.gcube.application.aquamaps.aquamapsservice.stubs.datamodel.xstream.AquaMapsXStream;
import org.gcube.common.core.utils.logging.GCUBELog;

public class SourceGenerationRequest
extends DataModel {
    static GCUBELog logger = new GCUBELog(SourceGenerationRequest.class);
    public static final String FIRST_HCAF_ID = "FIRST_HCAF_ID";
    public static final String SECOND_HCAF_ID = "SECOND_HCAF_ID";
    public static final String NUM_INTERPOLATIONS = "NUM_INTERPOLATIONS";
    public static final String FIRST_HCAF_TIME = "FIRST_HCAF_TIME";
    public static final String SECOND_HCAF_TIME = "SECOND_HCAF_TIME";
    public static final String COMBINE_MATCHING = "COMBINE_MATCHING";
    public static final String FORCE_MAPS_REGENERATION = "FORCE_MAPS_REGENERATION";
    public static final String GENERATE_MAPS = "GENERATE_MAPS";
    public static final String GIS_ENABLED = "GIS_ENABLED";
    public static final ArrayList<String> generationParametersNames = new ArrayList();
    public static final ArrayList<String> executionParametersNames = new ArrayList();
    private String author;
    private String generationname;
    private String id;
    private String description;
    private SourceGenerationPhase phase = SourceGenerationPhase.pending;
    private Long submissiontime = 0L;
    private Long endtime = 0L;
    private Long starttime = 0L;
    private Double currentphasepercent = 0.0;
    private ArrayList<Integer> hcafIds = new ArrayList();
    private ArrayList<Integer> hspenIds = new ArrayList();
    private ArrayList<Integer> occurrenceCellIds = new ArrayList();
    private ArrayList<Field> generationParameters = new ArrayList();
    private ArrayList<Field> executionParameters = new ArrayList();
    private ArrayList<Integer> generatedSources = new ArrayList();
    private ArrayList<Integer> reportID = new ArrayList();
    private ArrayList<Integer> jobIds = new ArrayList();
    private String submissionBackend;
    private String executionEnvironment;
    private String backendURL;
    private HashMap<String, String> environmentConfiguration = new HashMap();
    private LogicType logic;
    private Integer numPartitions = 0;
    private ArrayList<AlgorithmType> algorithms = new ArrayList();
    private Integer toGenerateTableCount = 0;
    private Integer evaluatedComputationCount = 0;

    public ArrayList<Integer> getGeneratedSources() {
        return this.generatedSources;
    }

    public void setGeneratedSources(ArrayList<Integer> generatedSources) {
        this.generatedSources = generatedSources;
        Collections.sort(this.generatedSources);
    }

    public Long getEndtime() {
        return this.endtime;
    }

    public void setEndtime(Long endtime) {
        this.endtime = endtime;
    }

    public Long getStarttime() {
        return this.starttime;
    }

    public void setStarttime(Long starttime) {
        this.starttime = starttime;
    }

    public String getAuthor() {
        return this.author;
    }

    public void setAuthor(String author) {
        this.author = author;
    }

    public String getGenerationname() {
        return this.generationname;
    }

    public void setGenerationname(String generationname) {
        this.generationname = generationname;
    }

    public ArrayList<AlgorithmType> getAlgorithms() {
        return this.algorithms;
    }

    public void setAlgorithms(ArrayList<AlgorithmType> algorithms) {
        this.algorithms = algorithms;
        Collections.sort(this.algorithms);
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public SourceGenerationPhase getPhase() {
        return this.phase;
    }

    public void setPhase(SourceGenerationPhase phase) {
        this.phase = phase;
    }

    public Long getSubmissiontime() {
        return this.submissiontime;
    }

    public void setSubmissiontime(Long submissiontime) {
        this.submissiontime = submissiontime;
    }

    public Double getCurrentphasepercent() {
        return this.currentphasepercent;
    }

    public void setCurrentphasepercent(Double currentphasepercent) {
        this.currentphasepercent = currentphasepercent;
    }

    public void setEvaluatedComputationCount(Integer evaluatedComputationCount) {
        this.evaluatedComputationCount = evaluatedComputationCount;
    }

    public void setToGenerateTableCount(Integer toGenerateTableCount) {
        this.toGenerateTableCount = toGenerateTableCount;
    }

    public Integer getEvaluatedComputationCount() {
        return this.evaluatedComputationCount;
    }

    public Integer getToGenerateTableCount() {
        return this.toGenerateTableCount;
    }

    public void addReportId(Integer id) {
        this.reportID.add(id);
        Collections.sort(this.reportID);
    }

    public void removeReportId(Integer id) {
        this.reportID.remove(id);
        Collections.sort(this.reportID);
    }

    public static ArrayList<SourceGenerationRequest> loadResultSet(ResultSet rs) throws Exception {
        ArrayList<SourceGenerationRequest> toReturn = new ArrayList<SourceGenerationRequest>();
        while (rs.next()) {
            toReturn.add(new SourceGenerationRequest(Field.loadRow(rs)));
        }
        return toReturn;
    }

    public String getSubmissionBackend() {
        return this.submissionBackend;
    }

    public void setSubmissionBackend(String submissionBackend) {
        this.submissionBackend = submissionBackend;
    }

    public LogicType getLogic() {
        return this.logic;
    }

    public void setLogic(LogicType logic) {
        this.logic = logic;
    }

    public void setReportID(List<Integer> reportID) {
        this.reportID.clear();
        this.reportID.addAll(reportID);
        Collections.sort(this.reportID);
    }

    public ArrayList<Integer> getReportID() {
        return this.reportID;
    }

    public void setJobIds(ArrayList<Integer> jobIds) {
        this.jobIds = jobIds;
        Collections.sort(this.jobIds);
    }

    public ArrayList<Integer> getJobIds() {
        return this.jobIds;
    }

    public Integer getNumPartitions() {
        return this.numPartitions;
    }

    public void setNumPartitions(Integer numPartitions) {
        this.numPartitions = numPartitions;
    }

    public String getExecutionEnvironment() {
        return this.executionEnvironment;
    }

    public void setExecutionEnvironment(String executionEnvironment) {
        this.executionEnvironment = executionEnvironment;
    }

    public String getBackendURL() {
        return this.backendURL;
    }

    public void setBackendURL(String backendURL) {
        this.backendURL = backendURL;
    }

    public HashMap<String, String> getEnvironmentConfiguration() {
        return this.environmentConfiguration;
    }

    public void setEnvironmentConfiguration(HashMap<String, String> environmentConfiguration) {
        this.environmentConfiguration = environmentConfiguration;
    }

    public SourceGenerationRequest(ResultSet rs) throws Exception {
        this(Field.loadRow(rs));
    }

    public SourceGenerationRequest(List<Field> row) {
        for (Field f : row) {
            try {
                this.setField(f);
            }
            catch (Exception e) {}
        }
    }

    public boolean setField(Field f) throws JSONException {
        try {
            switch (SourceGenerationRequestFields.valueOf(f.getName().toLowerCase())) {
                case algorithms: {
                    ArrayList<AlgorithmType> parsed = new ArrayList<AlgorithmType>();
                    for (String s : CSVUtils.CSVToStringList(f.getValue())) {
                        parsed.add(AlgorithmType.valueOf(s));
                    }
                    this.setAlgorithms(parsed);
                    break;
                }
                case author: {
                    this.setAuthor(f.getValue());
                    break;
                }
                case backendurl: {
                    this.setBackendURL(f.getValue());
                    break;
                }
                case currentphasepercent: {
                    this.setCurrentphasepercent(f.getValueAsDouble());
                    break;
                }
                case description: {
                    this.setDescription(f.getValue());
                    break;
                }
                case endtime: {
                    this.setEndtime(f.getValueAsLong());
                    break;
                }
                case environmentconfiguration: {
                    this.setEnvironmentConfiguration((HashMap)AquaMapsXStream.getXMLInstance().fromXML(f.getValue()));
                    break;
                }
                case executionenvironment: {
                    this.setExecutionEnvironment(f.getValue());
                    break;
                }
                case generatedsourcesid: {
                    this.setGeneratedSources(CSVUtils.CSVTOIntegerList(f.getValue()));
                    break;
                }
                case generationname: {
                    this.setGenerationname(f.getValue());
                    break;
                }
                case jobids: {
                    this.setJobIds(CSVUtils.CSVTOIntegerList(f.getValue()));
                    break;
                }
                case logic: {
                    this.setLogic(LogicType.valueOf(f.getValue()));
                    break;
                }
                case numpartitions: {
                    this.setNumPartitions(f.getValueAsInteger());
                    break;
                }
                case phase: {
                    this.setPhase(SourceGenerationPhase.valueOf(f.getValue()));
                    break;
                }
                case reportid: {
                    this.setReportID(CSVUtils.CSVTOIntegerList(f.getValue()));
                    break;
                }
                case starttime: {
                    this.setStarttime(f.getValueAsLong());
                    break;
                }
                case submissionbackend: {
                    this.setSubmissionBackend(f.getValue());
                    break;
                }
                case submissiontime: {
                    this.setSubmissiontime(f.getValueAsLong());
                    break;
                }
                case sourcehcafids: {
                    this.setHcafIds(CSVUtils.CSVTOIntegerList(f.getValue()));
                    break;
                }
                case sourcehspenids: {
                    this.setHspenIds(CSVUtils.CSVTOIntegerList(f.getValue()));
                    break;
                }
                case sourceoccurrencecellsids: {
                    this.setOccurrenceCellIds(CSVUtils.CSVTOIntegerList(f.getValue()));
                    break;
                }
                case id: {
                    this.setId(f.getValue());
                    break;
                }
                case evaluatedcomputationcount: {
                    this.setEvaluatedComputationCount(f.getValueAsInteger());
                    break;
                }
                case togeneratetablescount: {
                    this.setToGenerateTableCount(f.getValueAsInteger());
                    break;
                }
                case generationparameters: {
                    this.setGenerationParameters(Field.fromJSONArray(new JSONArray(f.getValue())));
                    break;
                }
                case executionparameters: {
                    this.setExecutionParameters(Field.fromJSONArray(new JSONArray(f.getValue())));
                    break;
                }
                default: {
                    return false;
                }
            }
        }
        catch (Exception e) {
            logger.warn((Object)("Unable to parse field " + f.toJSONObject()), (Throwable)e);
        }
        return true;
    }

    public Field getField(SourceGenerationRequestFields fieldName) throws JSONException {
        switch (fieldName) {
            case algorithms: {
                return new Field((Object)((Object)fieldName) + "", CSVUtils.listToCSV(this.getAlgorithms()), FieldType.STRING);
            }
            case author: {
                return new Field((Object)((Object)fieldName) + "", this.getAuthor(), FieldType.STRING);
            }
            case backendurl: {
                return new Field((Object)((Object)fieldName) + "", this.getBackendURL(), FieldType.STRING);
            }
            case currentphasepercent: {
                return new Field((Object)((Object)fieldName) + "", this.getCurrentphasepercent() + "", FieldType.DOUBLE);
            }
            case description: {
                return new Field((Object)((Object)fieldName) + "", this.getDescription(), FieldType.STRING);
            }
            case endtime: {
                return new Field((Object)((Object)fieldName) + "", this.getEndtime() + "", FieldType.INTEGER);
            }
            case environmentconfiguration: {
                return new Field((Object)((Object)fieldName) + "", AquaMapsXStream.getXMLInstance().toXML(this.getEnvironmentConfiguration()), FieldType.STRING);
            }
            case executionenvironment: {
                return new Field((Object)((Object)fieldName) + "", this.getExecutionEnvironment(), FieldType.STRING);
            }
            case generatedsourcesid: {
                return new Field((Object)((Object)fieldName) + "", CSVUtils.listToCSV(this.generatedSources), FieldType.STRING);
            }
            case generationname: {
                return new Field((Object)((Object)fieldName) + "", this.getGenerationname(), FieldType.STRING);
            }
            case id: {
                return new Field((Object)((Object)fieldName) + "", this.getId(), FieldType.STRING);
            }
            case jobids: {
                return new Field((Object)((Object)fieldName) + "", CSVUtils.listToCSV(this.jobIds), FieldType.STRING);
            }
            case logic: {
                return new Field((Object)((Object)fieldName) + "", (Object)((Object)this.getLogic()) + "", FieldType.STRING);
            }
            case numpartitions: {
                return new Field((Object)((Object)fieldName) + "", this.getNumPartitions() + "", FieldType.INTEGER);
            }
            case phase: {
                return new Field((Object)((Object)fieldName) + "", (Object)((Object)this.getPhase()) + "", FieldType.STRING);
            }
            case reportid: {
                return new Field((Object)((Object)fieldName) + "", CSVUtils.listToCSV(this.reportID), FieldType.STRING);
            }
            case starttime: {
                return new Field((Object)((Object)fieldName) + "", this.getStarttime() + "", FieldType.LONG);
            }
            case submissionbackend: {
                return new Field((Object)((Object)fieldName) + "", this.getSubmissionBackend(), FieldType.STRING);
            }
            case submissiontime: {
                return new Field((Object)((Object)fieldName) + "", this.getSubmissiontime() + "", FieldType.LONG);
            }
            case sourcehcafids: {
                return new Field((Object)((Object)fieldName) + "", CSVUtils.listToCSV(this.hcafIds), FieldType.STRING);
            }
            case sourcehspenids: {
                return new Field((Object)((Object)fieldName) + "", CSVUtils.listToCSV(this.hspenIds), FieldType.STRING);
            }
            case sourceoccurrencecellsids: {
                return new Field((Object)((Object)fieldName) + "", CSVUtils.listToCSV(this.occurrenceCellIds), FieldType.STRING);
            }
            case evaluatedcomputationcount: {
                return new Field((Object)((Object)fieldName) + "", this.getEvaluatedComputationCount() + "", FieldType.INTEGER);
            }
            case togeneratetablescount: {
                return new Field((Object)((Object)fieldName) + "", this.getToGenerateTableCount() + "", FieldType.INTEGER);
            }
            case generationparameters: {
                return new Field((Object)((Object)fieldName) + "", Field.toJSONArray(this.getGenerationParameters()).toString(), FieldType.STRING);
            }
            case executionparameters: {
                return new Field((Object)((Object)fieldName) + "", Field.toJSONArray(this.getExecutionParameters()).toString(), FieldType.STRING);
            }
        }
        return null;
    }

    public List<Field> toRow() throws JSONException {
        ArrayList<Field> toReturn = new ArrayList<Field>();
        for (SourceGenerationRequestFields f : SourceGenerationRequestFields.values()) {
            toReturn.add(this.getField(f));
        }
        return toReturn;
    }

    @Deprecated
    public SourceGenerationRequest() {
    }

    public SourceGenerationRequest(HspecGroupGenerationRequestType request) throws JSONException {
        ArrayList<AlgorithmType> parsed = new ArrayList<AlgorithmType>();
        for (String s : CSVUtils.CSVToStringList(request.getAlgorithms())) {
            parsed.add(AlgorithmType.valueOf(s));
        }
        this.setAlgorithms(parsed);
        this.setAuthor(request.getAuthor());
        this.setBackendURL(request.getBackendUrl());
        this.setDescription(request.getDescription());
        this.setEnvironmentConfiguration((HashMap)AquaMapsXStream.getXMLInstance().fromXML(request.getEnvironmentConfiguration()));
        this.setExecutionEnvironment(request.getExecutionEnvironment());
        this.setGenerationname(request.getGenerationName());
        this.setHcafIds(CSVUtils.CSVTOIntegerList(request.getHcafIds()));
        this.setHspenIds(CSVUtils.CSVTOIntegerList(request.getHspenIds()));
        this.setOccurrenceCellIds(CSVUtils.CSVTOIntegerList(request.getOccurrenceCellsIds()));
        this.setExecutionParameters(Field.fromJSONArray(new JSONArray(request.getExecutionParameters())));
        this.setGenerationParameters(Field.fromJSONArray(new JSONArray(request.getGenerationParameters())));
        this.setLogic(LogicType.valueOf(request.getLogic()));
        this.setNumPartitions(request.getNumPartitions());
        this.setSubmissionBackend(request.getSubmissionBackend());
    }

    public HspecGroupGenerationRequestType toStubsVersion() throws JSONException {
        return new HspecGroupGenerationRequestType(CSVUtils.listToCSV(this.algorithms), this.author, this.backendURL, this.description, AquaMapsXStream.getXMLInstance().toXML(this.environmentConfiguration), this.executionEnvironment, Field.toJSONArray(this.executionParameters).toString(), this.generationname, Field.toJSONArray(this.generationParameters).toString(), CSVUtils.listToCSV(this.hcafIds), CSVUtils.listToCSV(this.hspenIds), (Object)((Object)this.logic) + "", this.numPartitions, CSVUtils.listToCSV(this.occurrenceCellIds), this.submissionBackend);
    }

    public ArrayList<Integer> getHcafIds() {
        return this.hcafIds;
    }

    public ArrayList<Integer> getHspenIds() {
        return this.hspenIds;
    }

    public ArrayList<Integer> getOccurrenceCellIds() {
        return this.occurrenceCellIds;
    }

    public void setHcafIds(ArrayList<Integer> hcafIds) {
        this.hcafIds = hcafIds;
        Collections.sort(this.hcafIds);
    }

    public void setHspenIds(ArrayList<Integer> hspenIds) {
        this.hspenIds = hspenIds;
        Collections.sort(this.hspenIds);
    }

    public void setOccurrenceCellIds(ArrayList<Integer> occurrenceCellIds) {
        this.occurrenceCellIds = occurrenceCellIds;
        Collections.sort(this.occurrenceCellIds);
    }

    public ArrayList<Field> getExecutionParameters() {
        return this.executionParameters;
    }

    public void setExecutionParameters(ArrayList<Field> executionParameters) {
        this.executionParameters = executionParameters;
        Collections.sort(this.executionParameters);
    }

    public ArrayList<Field> getGenerationParameters() {
        return this.generationParameters;
    }

    public void setGenerationParameters(ArrayList<Field> generationParameters) {
        this.generationParameters = generationParameters;
        Collections.sort(this.generationParameters);
    }

    public void addSource(Resource toAdd) throws Exception {
        ArrayList<Integer> toModifyIds = null;
        switch (toAdd.getType()) {
            case HCAF: {
                toModifyIds = this.hcafIds;
                break;
            }
            case HSPEN: {
                toModifyIds = this.hspenIds;
                break;
            }
            case OCCURRENCECELLS: {
                toModifyIds = this.occurrenceCellIds;
                break;
            }
            default: {
                throw new Exception("Invalid resource type " + toAdd);
            }
        }
        if (!toModifyIds.contains(toAdd.getSearchId())) {
            toModifyIds.add(toAdd.getSearchId());
            Collections.sort(toModifyIds);
        }
    }

    public void addParameter(Field f) throws Exception {
        if (generationParametersNames.contains(f.getName())) {
            this.generationParameters.add(f);
            Collections.sort(this.generationParameters);
        } else if (executionParametersNames.contains(f.getName())) {
            this.executionParameters.add(f);
            Collections.sort(this.executionParameters);
        } else {
            throw new Exception("Invalid Field name " + f);
        }
    }

    static {
        generationParametersNames.add(FIRST_HCAF_TIME);
        generationParametersNames.add(FIRST_HCAF_ID);
        generationParametersNames.add(NUM_INTERPOLATIONS);
        generationParametersNames.add(SECOND_HCAF_ID);
        generationParametersNames.add(SECOND_HCAF_TIME);
        executionParametersNames.add(COMBINE_MATCHING);
        executionParametersNames.add(FORCE_MAPS_REGENERATION);
        executionParametersNames.add(GENERATE_MAPS);
        executionParametersNames.add(GIS_ENABLED);
    }
}

