/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.application.aquamaps.aquamapsservice.impl.db.managers;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.gcube.application.aquamaps.aquamapsservice.impl.db.DBSession;
import org.gcube.application.aquamaps.aquamapsservice.impl.db.DBUtils;
import org.gcube.application.aquamaps.aquamapsservice.impl.util.ServiceUtils;
import org.gcube.application.aquamaps.aquamapsservice.stubs.datamodel.environments.SourceGenerationRequest;
import org.gcube.application.aquamaps.aquamapsservice.stubs.datamodel.types.SourceGenerationPhase;
import org.gcube.application.aquamaps.aquamapsservice.stubs.datamodel.utils.CSVUtils;
import org.gcube.application.aquamaps.aquamapsservice.stubs.fw.fields.SourceGenerationRequestFields;
import org.gcube.application.aquamaps.aquamapsservice.stubs.fw.model.Field;
import org.gcube.application.aquamaps.aquamapsservice.stubs.fw.types.FieldType;
import org.gcube_system.namespaces.application.aquamaps.types.OrderDirection;
import org.gcube_system.namespaces.application.aquamaps.types.PagedRequestSettings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SourceGenerationRequestsManager {
    static final Logger logger = LoggerFactory.getLogger(SourceGenerationRequestsManager.class);
    public static final String requestsTable = "source_generation_requests";

    public static String insertRequest(SourceGenerationRequest toInsert) throws Exception {
        try (DBSession session = null;){
            session = DBSession.getInternalDBSession();
            toInsert.setId(ServiceUtils.generateId("HGGR", ""));
            toInsert.setPhase(SourceGenerationPhase.pending);
            toInsert.setSubmissiontime(Long.valueOf(System.currentTimeMillis()));
            toInsert.setGeneratedSources(new ArrayList());
            toInsert.setJobIds(new ArrayList());
            toInsert.setCurrentphasepercent(Double.valueOf(0.0));
            toInsert.setEndtime(Long.valueOf(0L));
            toInsert.setEvaluatedComputationCount(Integer.valueOf(0));
            toInsert.setReportID(new ArrayList());
            toInsert.setStarttime(Long.valueOf(0L));
            toInsert.setToGenerateTableCount(Integer.valueOf(0));
            ArrayList<List<Field>> rows = new ArrayList<List<Field>>();
            ArrayList<Field> toInsertRow = new ArrayList<Field>();
            logger.debug("Inserting request, fields are :");
            for (Field f : toInsert.toRow()) {
                if (f.value() == null || f.value().equalsIgnoreCase("null")) continue;
                toInsertRow.add(f);
                logger.debug(f.toXML());
            }
            rows.add(toInsertRow);
            session.insertOperation(requestsTable, rows);
            String string = toInsert.getId();
            return string;
        }
    }

    private static void updateField(String id, List<Field> values) throws Exception {
        try (DBSession session = null;){
            session = DBSession.getInternalDBSession();
            ArrayList<List<Field>> keys = new ArrayList<List<Field>>();
            ArrayList<Field> key = new ArrayList<Field>();
            key.add(new Field(SourceGenerationRequestFields.id + "", id, FieldType.STRING));
            keys.add(key);
            ArrayList<List<Field>> rows = new ArrayList<List<Field>>();
            rows.add(values);
            session.updateOperation(requestsTable, keys, rows);
        }
    }

    public static ArrayList<SourceGenerationRequest> getList(ArrayList<Field> filter) throws Exception {
        DBSession session = null;
        if (filter == null) {
            filter = new ArrayList();
        }
        try {
            session = DBSession.getInternalDBSession();
            ArrayList arrayList = SourceGenerationRequest.loadResultSet((ResultSet)session.executeFilteredQuery(filter, requestsTable, SourceGenerationRequestFields.submissiontime + "", OrderDirection.ASC));
            return arrayList;
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            if (session != null) {
                session.close();
            }
        }
    }

    public static List<SourceGenerationRequest> getList(List<Field> filter, PagedRequestSettings settings) throws Exception {
        try (DBSession session = null;){
            session = DBSession.getInternalDBSession();
            ArrayList<SourceGenerationRequest> toReturn = new ArrayList<SourceGenerationRequest>();
            ResultSet rs = session.executeFilteredQuery(filter, requestsTable, settings.getOrderField(), settings.getOrderDirection());
            int rowIndex = 0;
            while (rs.next() && toReturn.size() < settings.getLimit()) {
                if (rowIndex >= settings.getOffset()) {
                    toReturn.add(new SourceGenerationRequest(rs));
                }
                ++rowIndex;
            }
            ArrayList<SourceGenerationRequest> arrayList = toReturn;
            return arrayList;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static Field getField(String id, String field) throws Exception {
        try (DBSession session = null;){
            session = DBSession.getInternalDBSession();
            ArrayList<Field> key = new ArrayList<Field>();
            key.add(new Field(SourceGenerationRequestFields.id + "", id, FieldType.STRING));
            ResultSet rs = session.executeFilteredQuery(key, requestsTable, field, OrderDirection.ASC);
            if (!rs.next()) throw new Exception("Field not found " + field);
            Iterator i$ = Field.loadRow((ResultSet)rs).iterator();
            while (i$.hasNext()) {
                Field f = (Field)i$.next();
                if (f.name().equals(field)) {
                    Field field2 = f;
                    return field2;
                }
            }
            throw new Exception("Field not found " + field);
        }
    }

    public static void setPhase(SourceGenerationPhase phase, String id) throws Exception {
        ArrayList<Field> fields = new ArrayList<Field>();
        fields.add(new Field(SourceGenerationRequestFields.phase + "", phase + "", FieldType.STRING));
        if (phase.equals((Object)SourceGenerationPhase.completed) || phase.equals((Object)SourceGenerationPhase.error)) {
            fields.add(new Field(SourceGenerationRequestFields.endtime + "", System.currentTimeMillis() + "", FieldType.LONG));
            fields.add(new Field(SourceGenerationRequestFields.currentphasepercent + "", "100", FieldType.DOUBLE));
        }
        SourceGenerationRequestsManager.updateField(id, fields);
    }

    public static void addReportId(int reportId, String id) throws Exception {
        SourceGenerationRequest req = SourceGenerationRequestsManager.getById(id);
        req.addReportId(Integer.valueOf(reportId));
        SourceGenerationRequestsManager.updateField(id, new ArrayList<Field>(Arrays.asList(req.getField(SourceGenerationRequestFields.reportid))));
    }

    public static void removeReportId(int reportId, String id) throws Exception {
        SourceGenerationRequest req = SourceGenerationRequestsManager.getById(id);
        req.removeReportId(Integer.valueOf(reportId));
        SourceGenerationRequestsManager.updateField(id, new ArrayList<Field>(Arrays.asList(req.getField(SourceGenerationRequestFields.reportid))));
    }

    public static void setPhasePercent(double percent, String id) throws Exception {
        ArrayList<Field> fields = new ArrayList<Field>();
        fields.add(new Field(SourceGenerationRequestFields.currentphasepercent + "", percent + "", FieldType.DOUBLE));
        SourceGenerationRequestsManager.updateField(id, fields);
    }

    public static void addGeneratedResource(int hspecId, String id) throws Exception {
        ArrayList<Field> fields = new ArrayList<Field>();
        ArrayList current = CSVUtils.CSVToStringList((String)SourceGenerationRequestsManager.getField(id, SourceGenerationRequestFields.generatedsourcesid + "").value());
        current.add(hspecId + "");
        fields.add(new Field(SourceGenerationRequestFields.generatedsourcesid + "", CSVUtils.listToCSV((List)current), FieldType.STRING));
        SourceGenerationRequestsManager.updateField(id, fields);
    }

    public static void addJobIds(int jobId, String id) throws Exception {
        ArrayList<Field> fields = new ArrayList<Field>();
        ArrayList current = CSVUtils.CSVToStringList((String)SourceGenerationRequestsManager.getField(id, SourceGenerationRequestFields.jobids + "").value());
        current.add(jobId + "");
        fields.add(new Field(SourceGenerationRequestFields.jobids + "", CSVUtils.listToCSV((List)current), FieldType.STRING));
        SourceGenerationRequestsManager.updateField(id, fields);
    }

    public static void setToGenerateTableCount(int count, String id) throws Exception {
        ArrayList<Field> fields = new ArrayList<Field>();
        fields.add(new Field(SourceGenerationRequestFields.togeneratetablescount + "", count + "", FieldType.INTEGER));
        SourceGenerationRequestsManager.updateField(id, fields);
    }

    public static void setEvaluatedComputationCount(int count, String id) throws Exception {
        ArrayList<Field> fields = new ArrayList<Field>();
        fields.add(new Field(SourceGenerationRequestFields.evaluatedcomputationcount + "", count + "", FieldType.INTEGER));
        SourceGenerationRequestsManager.updateField(id, fields);
    }

    public static void setStartTime(String id) throws Exception {
        ArrayList<Field> fields = new ArrayList<Field>();
        fields.add(new Field(SourceGenerationRequestFields.starttime + "", System.currentTimeMillis() + "", FieldType.LONG));
        SourceGenerationRequestsManager.updateField(id, fields);
    }

    public static String getJSONList(List<Field> filters, PagedRequestSettings settings) throws Exception {
        if (filters == null) {
            filters = new ArrayList<Field>();
        }
        try (DBSession session = null;){
            session = DBSession.getInternalDBSession();
            String string = DBUtils.toJSon(session.executeFilteredQuery(filters, requestsTable, settings.getOrderField(), settings.getOrderDirection()), settings.getOffset(), settings.getOffset() + settings.getOffset() + settings.getLimit());
            return string;
        }
    }

    public static int delete(ArrayList<Field> filter) throws Exception {
        DBSession session = null;
        if (filter == null) {
            filter = new ArrayList();
        }
        try {
            session = DBSession.getInternalDBSession();
            PreparedStatement ps = session.getPreparedStatementForDelete(filter, requestsTable);
            int n = session.fillParameters(filter, 0, ps).executeUpdate();
            return n;
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            if (session != null) {
                session.close();
            }
        }
    }

    public static int delete(String id) throws Exception {
        ArrayList<Field> filter = new ArrayList<Field>();
        filter.add(new Field(SourceGenerationRequestFields.id + "", id, FieldType.STRING));
        return SourceGenerationRequestsManager.delete(filter);
    }

    public static Long getCount(List<Field> filter) throws Exception {
        DBSession session = null;
        if (filter == null) {
            filter = new ArrayList<Field>();
        }
        try {
            session = DBSession.getInternalDBSession();
            Long l = session.getCount(requestsTable, filter);
            return l;
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            if (session != null) {
                session.close();
            }
        }
    }

    public static SourceGenerationRequest getById(String id) throws Exception {
        SourceGenerationRequest request = new SourceGenerationRequest();
        request.setId(id);
        ArrayList<SourceGenerationRequest> found = SourceGenerationRequestsManager.getList(new ArrayList<Field>(Arrays.asList(request.getField(SourceGenerationRequestFields.id))));
        if (found.size() > 0) {
            return found.get(0);
        }
        return null;
    }
}

