/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.application.aquamaps.aquamapsservice.impl.publishing.gis;

import it.geosolutions.geoserver.rest.decoder.RESTLayer;
import it.geosolutions.geoserver.rest.encoder.GSLayerEncoder;
import it.geosolutions.geoserver.rest.encoder.feature.GSFeatureTypeEncoder;
import java.awt.Color;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.sql.PreparedStatement;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import net.sf.csv4j.CSVLineProcessor;
import net.sf.csv4j.CSVReaderProcessor;
import org.gcube.application.aquamaps.aquamapsservice.impl.ServiceContext;
import org.gcube.application.aquamaps.aquamapsservice.impl.db.DBSession;
import org.gcube.application.aquamaps.aquamapsservice.impl.publishing.BadRequestException;
import org.gcube.application.aquamaps.aquamapsservice.impl.publishing.gis.AquaMapsIsoMetadata;
import org.gcube.application.aquamaps.aquamapsservice.impl.publishing.gis.LayerGenerationRequest;
import org.gcube.application.aquamaps.aquamapsservice.impl.publishing.gis.StyleGenerationRequest;
import org.gcube.application.aquamaps.aquamapsservice.impl.util.ServiceUtils;
import org.gcube.application.aquamaps.aquamapsservice.impl.util.isconfig.ConfigurationManager;
import org.gcube.application.aquamaps.aquamapsservice.impl.util.isconfig.DBDescriptor;
import org.gcube.application.aquamaps.aquamapsservice.stubs.fw.fields.HCAF_SFields;
import org.gcube.application.aquamaps.aquamapsservice.stubs.fw.model.Field;
import org.gcube.application.aquamaps.aquamapsservice.stubs.fw.model.gis.LayerType;
import org.gcube.application.aquamaps.aquamapsservice.stubs.fw.types.AlgorithmType;
import org.gcube.application.aquamaps.aquamapsservice.stubs.fw.types.FieldType;
import org.gcube.application.aquamaps.aquamapsservice.stubs.fw.types.ObjectType;
import org.gcube.common.core.contexts.GHNContext;
import org.gcube.common.gis.datamodel.enhanced.LayerInfo;
import org.gcube.common.gis.datamodel.enhanced.WMSContextInfo;
import org.gcube.common.gis.datamodel.utils.ReadTemplate;
import org.gcube.common.scope.api.ScopeProvider;
import org.gcube.spatial.data.geonetwork.LoginLevel;
import org.gcube.spatial.data.geonetwork.iso.Thesaurus;
import org.gcube.spatial.data.gis.GISInterface;
import org.gcube.spatial.data.gis.is.GeoServerDescriptor;
import org.gcube.spatial.data.gis.model.report.DeleteReport;
import org.gcube.spatial.data.gis.model.report.PublishResponse;
import org.gcube.spatial.data.gis.model.report.Report;
import org.gcube.spatial.data.gis.symbology.StyleUtils;
import org.opengis.metadata.Metadata;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GISUtils {
    static final Logger logger = LoggerFactory.getLogger(GISUtils.class);
    public static char delimiter = (char)44;
    public static boolean hasHeader = false;
    private static String cSquareCodeDefinition = HCAF_SFields.csquarecode + " varchar(10)";
    private static final String crs = "GEOGCS[\"WGS 84\", DATUM[\"World Geodetic System 1984\", SPHEROID[\"WGS 84\", 6378137.0, 298.257223563, AUTHORITY[\"EPSG\",\"7030\"]],AUTHORITY[\"EPSG\",\"6326\"]], PRIMEM[\"Greenwich\", 0.0, AUTHORITY[\"EPSG\",\"8901\"]],  UNIT[\"degree\", 0.017453292519943295],AXIS[\"Geodetic longitude\", EAST],  AXIS[\"Geodetic latitude\", NORTH],  AUTHORITY[\"EPSG\",\"4326\"]]";
    private static long DB_WAIT_TIME;
    private static long GEO_SERVER_WAIT_TIME;

    public static GISPublishedItem generateLayer(LayerGenerationRequest request) throws Exception {
        DBSession session = null;
        String layerTable = null;
        String appTableName = null;
        String generatedLayerId = null;
        try {
            long start = System.currentTimeMillis();
            logger.debug("Generating layer..");
            session = DBSession.getPostGisDBSession();
            session.disableAutoCommit();
            logger.debug("Importing data..");
            appTableName = GISUtils.importLayerData(request.getCsvFile(), request.getFeatureLabel(), request.getFeatureDefinition(), session);
            logger.debug("Created " + appTableName + " in " + (System.currentTimeMillis() - start));
            layerTable = GISUtils.createLayerTable(appTableName, request.getMapName(), request.getFeatureLabel(), session);
            logger.debug("Created " + layerTable + " in " + (System.currentTimeMillis() - start));
            session.dropTable(appTableName);
            session.commit();
            logger.debug("Committed session");
            try {
                logger.debug("Waiting for postgis-geoserver sync..");
                Thread.sleep(DB_WAIT_TIME);
            }
            catch (InterruptedException e) {
                // empty catch block
            }
            ScopeProvider.instance.set(ServiceContext.getContext().getConfigurationScope());
            GISInterface gis = GISInterface.get();
            GeoServerDescriptor desc = (GeoServerDescriptor)gis.getGeoServerDescriptorSet(true).last();
            logger.debug("Current GeoServer " + desc);
            for (StyleGenerationRequest styleReq : request.getToGenerateStyles()) {
                if (GISUtils.generateStyle(styleReq, gis)) {
                    request.getToAssociateStyles().add(styleReq.getNameStyle());
                    continue;
                }
                logger.warn("Style " + styleReq.getNameStyle() + " was not generated!!");
            }
            if (request.getToAssociateStyles().size() == 0) {
                throw new BadRequestException("No style to associate wtih Layer " + request.getMapName());
            }
            generatedLayerId = GISUtils.createLayer(layerTable, request.getMapName(), (ArrayList)request.getToAssociateStyles(), request.getDefaultStyle(), request.getMeta(), gis);
            if (generatedLayerId == null) {
                throw new Exception("Unable to generate Layer " + request.getMapName());
            }
            logger.debug("GIS GENERATOR request served in " + (System.currentTimeMillis() - start) + " layer : " + layerTable + ", geoserver was " + desc.getUrl());
            GISPublishedItem gISPublishedItem = new GISPublishedItem(GISUtils.getLayer(request.getMapType(), gis.getGeoServerReader(desc).getLayer(layerTable), desc), generatedLayerId);
            return gISPublishedItem;
        }
        catch (Exception e) {
            logger.trace("Layer generation failed, gonna clean up data.. exception was", (Throwable)e);
            if (appTableName != null) {
                try {
                    logger.debug("Found table to delete : " + appTableName);
                    session.dropTable(appTableName);
                }
                catch (Exception e1) {
                    logger.warn("Unable to drop table " + appTableName, (Throwable)e);
                }
                if (layerTable != null) {
                    logger.debug("Found layer table to delete : " + layerTable);
                    try {
                        session.dropTable(layerTable);
                    }
                    catch (Exception e1) {
                        logger.warn("Unable to drop table " + appTableName, (Throwable)e);
                    }
                }
            }
            throw e;
        }
        finally {
            if (session != null) {
                session.close();
            }
        }
    }

    public static boolean deleteLayer(LayerInfo toDelete) throws Exception {
        logger.trace("Deleting layer " + toDelete.getName());
        GISInterface gis = GISInterface.get();
        SortedSet descs = gis.getGeoServerDescriptorSet(false);
        boolean deleted = false;
        for (GeoServerDescriptor desc : descs) {
            if (!toDelete.getUrl().contains(desc.getUrl())) continue;
            logger.debug("Found hosting geoserver " + desc.getUrl());
            DeleteReport report = gis.deleteLayer("aquamaps", toDelete.getName(), Long.valueOf(0L), desc, LoginLevel.DEFAULT);
            if (report.getDataOperationResult().equals((Object)Report.OperationState.COMPLETE)) {
                logger.debug("Deleting layerTable : " + toDelete.getName());
                GISUtils.deleteLayerTable(toDelete.getName());
                deleted = true;
                break;
            }
            throw new Exception("Unable to delete layer " + toDelete.getName() + ", cause " + report.getDataOperationMessages());
        }
        if (!deleted) {
            throw new Exception("Unable to find host for layer " + toDelete.getName());
        }
        return deleted;
    }

    @Deprecated
    public static void deleteWMSContext(WMSContextInfo toDelete) throws Exception {
        throw new Exception("Logic not supported");
    }

    private static String importLayerData(final String fileName, String featureLabel, String featureDefinition, DBSession session) throws Exception {
        CSVReaderProcessor processor = new CSVReaderProcessor();
        processor.setDelimiter(delimiter);
        processor.setHasHeader(hasHeader);
        logger.trace("Reading from file " + fileName);
        String tableName = ServiceUtils.generateId("app", "");
        session.createTable(tableName, new String[]{cSquareCodeDefinition, featureLabel + " " + featureDefinition});
        ArrayList<Field> toInsertFields = new ArrayList<Field>();
        toInsertFields.add(new Field(HCAF_SFields.csquarecode + "", "", FieldType.STRING));
        toInsertFields.add(new Field(featureLabel, "", FieldType.STRING));
        final PreparedStatement ps = session.getPreparedStatementForInsert(toInsertFields, tableName);
        InputStreamReader reader = new InputStreamReader((InputStream)new FileInputStream(fileName), Charset.defaultCharset());
        final ArrayList<Integer> count = new ArrayList<Integer>();
        count.add(0);
        long start = System.currentTimeMillis();
        processor.processStream((Reader)reader, new CSVLineProcessor(){

            public boolean continueProcessing() {
                return true;
            }

            public void processDataLine(int arg0, List<String> arg1) {
                try {
                    ps.setString(1, arg1.get(0));
                    ps.setFloat(2, Float.parseFloat(arg1.get(1)));
                    count.set(0, (Integer)count.get(0) + ps.executeUpdate());
                }
                catch (Exception e) {
                    logger.warn("Unable to complete insertion from file " + fileName, (Throwable)e);
                }
            }

            public void processHeaderLine(int arg0, List<String> arg1) {
            }
        });
        logger.debug("Inserted " + count.get(0) + " in " + (System.currentTimeMillis() - start));
        return tableName;
    }

    private static String createLayerTable(String appTableName, String layerName, String featureLabel, DBSession session) throws Exception {
        String featureTable = ServiceUtils.generateId("L" + layerName, "").replaceAll(" ", "").replaceAll("_", "").replaceAll("-", "").toLowerCase();
        String worldTable = ConfigurationManager.getVODescriptor().getGeoDb().getProperty(DBDescriptor.AQUAMAPS_WORLD_TABLE);
        logger.trace("Creating table " + featureTable);
        session.executeUpdate("Create table " + featureTable + " AS (Select " + worldTable + ".*, app." + featureLabel + " FROM " + appTableName + " AS app inner join " + worldTable + " ON app." + HCAF_SFields.csquarecode + "=" + worldTable + "." + HCAF_SFields.csquarecode + ")");
        logger.trace(featureTable + " created");
        logger.trace("going do drop appTable " + appTableName);
        session.dropTable(appTableName);
        return featureTable;
    }

    private static boolean generateStyle(StyleGenerationRequest req, GISInterface gis) throws Exception {
        String style;
        logger.trace("Generating style " + req.getNameStyle() + " attribute :" + req.getAttributeName() + " min " + req.getMin() + " max " + req.getMax() + " N classes " + req.getNClasses());
        if (req.getTypeValue() == Integer.class) {
            switch (req.getClusterScaleType()) {
                case logarithmic: {
                    style = StyleUtils.createStyleLog((String)req.getNameStyle(), (String)req.getAttributeName().toLowerCase(), (int)req.getNClasses(), (Color)req.getC1(), (Color)req.getC2(), (Class)req.getTypeValue(), (Object)Integer.parseInt(req.getMax()), (Object)Integer.parseInt(req.getMin()));
                    break;
                }
                default: {
                    style = StyleUtils.createStyle((String)req.getNameStyle(), (String)req.getAttributeName().toLowerCase(), (int)req.getNClasses(), (Color)req.getC1(), (Color)req.getC2(), (Class)req.getTypeValue(), (Object)Integer.parseInt(req.getMax()), (Object)Integer.parseInt(req.getMin()));
                    break;
                }
            }
        } else if (req.getTypeValue() == Float.class) {
            switch (req.getClusterScaleType()) {
                case logarithmic: {
                    style = StyleUtils.createStyleLog((String)req.getNameStyle(), (String)req.getAttributeName().toLowerCase(), (int)req.getNClasses(), (Color)req.getC1(), (Color)req.getC2(), (Class)req.getTypeValue(), (Object)Float.valueOf(Float.parseFloat(req.getMax())), (Object)Float.valueOf(Float.parseFloat(req.getMin())));
                    break;
                }
                default: {
                    style = StyleUtils.createStyle((String)req.getNameStyle(), (String)req.getAttributeName().toLowerCase(), (int)req.getNClasses(), (Color)req.getC1(), (Color)req.getC2(), (Class)req.getTypeValue(), (Object)Float.valueOf(Float.parseFloat(req.getMax())), (Object)Float.valueOf(Float.parseFloat(req.getMin())));
                    break;
                }
            }
        } else {
            throw new BadRequestException("Invalid type class : " + req.getTypeValue());
        }
        logger.trace("Submitting style " + req.getNameStyle());
        boolean toReturn = false;
        toReturn = gis.publishStyle(style, req.getNameStyle()).getDataOperationResult().equals((Object)Report.OperationState.COMPLETE);
        logger.trace("Submitting style result : " + toReturn);
        return toReturn;
    }

    private static String createLayer(String featureTable, String layerName, ArrayList<String> styles, int defaultStyleIndex, Map<String, Object> meta, GISInterface gis) throws Exception {
        try {
            ScopeProvider.instance.set(GHNContext.getContext().getStartScopes()[0].getInfrastructure().toString());
            AquaMapsIsoMetadata metaParams = new AquaMapsIsoMetadata();
            metaParams.setAlgorithm((AlgorithmType)meta.get("ALGORITHM"));
            metaParams.setCreationDate((Date)meta.get("META_DATE"));
            metaParams.setGeometryCount((Integer)meta.get("META_GEOMETRY_COUNT"));
            metaParams.setSourceGenerationTime((Date)meta.get("SOURCE_TIME"));
            metaParams.setSourceTableName((String)meta.get("SOURCE_TABLENAME"));
            metaParams.setSourceTitle((String)meta.get("SOURCE_TITLE"));
            metaParams.setTitle((String)meta.get("META_TITLE"));
            metaParams.setType((ObjectType)meta.get("META_OBJECT_TYPE"));
            metaParams.setUser((String)meta.get("META_AUTHOR"));
            for (String string : (List)meta.get("META_FILESET_URIS")) {
                metaParams.addGraphicOverview(string);
            }
            for (Map.Entry entry : ((Map)meta.get("META_KEYWORDS_MAP")).entrySet()) {
                Thesaurus t = (Thesaurus)metaParams.getConfig().getThesauri().get(entry.getKey());
                for (String keyword : (HashSet)entry.getValue()) {
                    metaParams.addKeyword(keyword, t);
                }
            }
            logger.debug("Invoking Caller for registering layer : ");
            GSFeatureTypeEncoder fte = new GSFeatureTypeEncoder();
            fte.setEnabled(true);
            fte.setLatLonBoundingBox(-180.0, -90.0, 180.0, 90.0, crs);
            fte.setName(featureTable);
            fte.setNativeCRS(crs);
            GSLayerEncoder gSLayerEncoder = new GSLayerEncoder();
            gSLayerEncoder.setDefaultStyle(styles.get(defaultStyleIndex));
            gSLayerEncoder.setEnabled(true);
            Metadata toSetMeta = metaParams.getMetadata();
            PublishResponse resp = gis.publishDBTable("aquamaps", "aquamapsdb", fte, gSLayerEncoder, toSetMeta, "datasets", "_none_", LoginLevel.DEFAULT, false);
            logger.debug("Publish response : " + resp);
            return resp.getDataOperationResult().equals((Object)Report.OperationState.COMPLETE) && resp.getMetaOperationResult().equals((Object)Report.OperationState.COMPLETE) ? toSetMeta.getFileIdentifier() : null;
        }
        catch (Exception e) {
            logger.debug("Create layer threw an exception ", (Throwable)e);
            throw e;
        }
    }

    private static LayerInfo getLayer(LayerType type, RESTLayer restLayer, GeoServerDescriptor desc) throws Exception {
        LayerInfo layer = ReadTemplate.getLayerTemplate((LayerType)type);
        layer.setType(type);
        layer.setName(restLayer.getName());
        layer.setTitle(restLayer.getTitle());
        layer.set_abstract(restLayer.getAbstract());
        layer.setUrl(restLayer.getResourceUrl());
        layer.setServerProtocol("OGC:WMS");
        layer.setServerLogin(desc.getUser());
        layer.setServerPassword(desc.getPassword());
        layer.setServerType("geoserver");
        layer.setSrs("EPSG:4326");
        layer.setOpacity(1.0);
        layer.setStyles(new ArrayList());
        layer.getStyles().add(restLayer.getDefaultStyle());
        layer.setDefaultStyle(restLayer.getDefaultStyle());
        return layer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean deleteLayerTable(String layerTable) throws Exception {
        try (DBSession session = null;){
            session = DBSession.getPostGisDBSession();
            session.dropTable(layerTable);
            boolean bl = true;
            return bl;
        }
    }

    static {
        try {
            DB_WAIT_TIME = ServiceContext.getContext().getPropertyAsInteger("GEOSERVER_WAIT_FOR_DB_MS").intValue();
            GEO_SERVER_WAIT_TIME = ServiceContext.getContext().getPropertyAsInteger("GEOSERVER_WAIT_FOR_FT").intValue();
        }
        catch (Exception e) {
            logger.error("UNABLE TO LOAD GIS CONFGURATION", (Throwable)e);
        }
    }

    public static class GISPublishedItem {
        private LayerInfo layerInfo;
        private String metaId;

        public GISPublishedItem(LayerInfo layerInfo, String metaId) {
            this.layerInfo = layerInfo;
            this.metaId = metaId;
        }

        public LayerInfo getLayerInfo() {
            return this.layerInfo;
        }

        public String getMetaId() {
            return this.metaId;
        }
    }
}

