/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.application.aquamaps.aquamapsservice.impl.monitor;

import com.thoughtworks.xstream.XStream;
import org.gcube.application.aquamaps.aquamapsservice.impl.ServiceContext;
import org.gcube.application.aquamaps.aquamapsservice.impl.monitor.HSQLDB;
import org.gcube.application.aquamaps.aquamapsservice.impl.monitor.ReportItem;
import org.gcube.application.aquamaps.aquamapsservice.impl.util.ServiceUtils;
import org.gcube.common.core.contexts.GHNContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StatusMonitorThread
extends Thread {
    static final Logger logger = LoggerFactory.getLogger(StatusMonitorThread.class);
    private long interval;
    private long freeSpaceThreshold;
    private static String valueDisk = "freeDiskSpace";

    public StatusMonitorThread(long waitTime, long freeSpaceThreshold) {
        super("Machine status monitor");
        this.interval = waitTime;
        this.freeSpaceThreshold = freeSpaceThreshold;
    }

    @Override
    public void run() {
        while (true) {
            try {
                try {
                    long currentDisk = GHNContext.getContext().getFreeSpace(GHNContext.getContext().getLocation());
                    if (currentDisk >= this.freeSpaceThreshold) continue;
                    logger.trace("Observed " + currentDisk + " / " + this.freeSpaceThreshold);
                    logger.trace("Storing value..");
                    HSQLDB.insertReportItem(valueDisk, currentDisk);
                    logger.trace("Forming report..");
                    ReportItem ri = HSQLDB.getReport(valueDisk);
                    ri.setTime(ServiceUtils.getDate());
                    ri.setActualValue(currentDisk);
                    ri.setThreshold(this.freeSpaceThreshold);
                    ri.setValueName(valueDisk);
                    XStream xstream = new XStream();
                    xstream.alias("ReportItem", ReportItem.class);
                    String toPublish = xstream.toXML((Object)ri);
                    logger.trace("publishing " + toPublish);
                    ServiceContext.getContext().getInstance().setSpecificData(toPublish);
                }
                catch (Exception e) {
                    logger.error("Unexpected error ", (Throwable)e);
                    try {
                        Thread.sleep(this.interval);
                    }
                    catch (InterruptedException eI) {
                        logger.trace("Awaken monitoring thread");
                    }
                }
                continue;
            }
            finally {
                try {
                    Thread.sleep(this.interval);
                }
                catch (InterruptedException eI) {
                    logger.trace("Awaken monitoring thread");
                }
                continue;
            }
            break;
        }
    }
}

