/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.application.aquamaps.aquamapsservice.impl.util.isconfig;

import java.io.StringWriter;
import java.security.Key;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.gcube.application.aquamaps.aquamapsservice.impl.util.ISQueryConstants;
import org.gcube.application.aquamaps.aquamapsservice.impl.util.ParserXPath;
import org.gcube.application.aquamaps.aquamapsservice.impl.util.isconfig.CachedObject;
import org.gcube.application.aquamaps.aquamapsservice.impl.util.isconfig.DBDescriptor;
import org.gcube.application.aquamaps.aquamapsservice.impl.util.isconfig.DataSourceDescriptor;
import org.gcube.application.aquamaps.aquamapsservice.impl.util.isconfig.GeoServerDescriptor;
import org.gcube.application.aquamaps.aquamapsservice.impl.util.isconfig.VODescriptor;
import org.gcube.common.core.contexts.GHNContext;
import org.gcube.common.core.scope.GCUBEScope;
import org.gcube.common.resources.gcore.GenericResource;
import org.gcube.common.resources.gcore.ServiceEndpoint;
import org.gcube.common.scope.api.ScopeProvider;
import org.gcube.common.utils.encryption.StringEncrypter;
import org.gcube.resources.discovery.client.api.DiscoveryClient;
import org.gcube.resources.discovery.client.queries.api.Query;
import org.gcube.resources.discovery.client.queries.impl.XQuery;
import org.gcube.resources.discovery.icclient.ICFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigurationManager {
    static final Logger logger = LoggerFactory.getLogger(ConfigurationManager.class);
    private static TransformerFactory tf = TransformerFactory.newInstance();
    private static Transformer transformer;
    private static CachedObject<VODescriptor> cachedConfiguration;
    private static String configurationScope;

    static {
        try {
            transformer = tf.newTransformer();
            transformer.setOutputProperty("omit-xml-declaration", "yes");
            transformer.setOutputProperty("indent", "no");
        }
        catch (Exception e) {
            logger.error("Unable to initialize transformer ", (Throwable)e);
        }
        cachedConfiguration = null;
        configurationScope = null;
    }

    public static synchronized VODescriptor getVODescriptor() throws Exception {
        if (!cachedConfiguration.isvalid()) {
            cachedConfiguration = new CachedObject<VODescriptor>(ConfigurationManager.getScopeInformation(configurationScope));
        }
        return cachedConfiguration.getTheObject();
    }

    public static String init(GCUBEScope infrastructureScope) throws Exception {
        for (GCUBEScope scope : ConfigurationManager.findAvailableScopes(infrastructureScope)) {
            try {
                cachedConfiguration = new CachedObject<VODescriptor>(ConfigurationManager.getScopeInformation(scope.toString()));
                configurationScope = cachedConfiguration.getTheObject().getScope();
                logger.trace("Found well configured scope : " + configurationScope);
                return configurationScope;
            }
            catch (Exception e) {
                logger.debug("Invalid scope : " + scope.toString(), (Throwable)e);
            }
        }
        throw new Exception("No well configured scope available");
    }

    private static VODescriptor getScopeInformation(String scope) throws Exception {
        String callerScope = ScopeProvider.instance.get();
        try {
            ScopeProvider.instance.set(scope);
            logger.debug("Checking scope : " + scope);
            List<GeoServerDescriptor> geoServers = ConfigurationManager.getGeoServers();
            List<DataSourceDescriptor> geoNetworks = ConfigurationManager.getGeoNetwork();
            List<DBDescriptor> gisDBs = ConfigurationManager.getGISDBDescriptor();
            List<DBDescriptor> internalDBs = ConfigurationManager.getInternalDB();
            ArrayList<DBDescriptor> publisherDBs = ConfigurationManager.getPublisherDB();
            if (geoNetworks.size() > 1) {
                throw new Exception("Multiple GeoNetworks found");
            }
            if (geoServers.size() > 0 && gisDBs.isEmpty()) {
                throw new Exception("No gis databases found");
            }
            if (gisDBs.size() > 1) {
                throw new Exception("Found " + gisDBs.size() + " gis DBs");
            }
            if (internalDBs.size() != 1) {
                throw new Exception("Found " + internalDBs.size() + " internal DBs");
            }
            if (publisherDBs.size() != 1) {
                throw new Exception("Found " + publisherDBs.size() + " publisher DBs");
            }
            DataSourceDescriptor geoNetwork = geoNetworks.isEmpty() ? null : geoNetworks.get(0);
            DBDescriptor internal = internalDBs.isEmpty() ? null : internalDBs.get(0);
            DBDescriptor publisher = publisherDBs.isEmpty() ? null : (DBDescriptor)publisherDBs.get(0);
            DBDescriptor gisDb = gisDBs.isEmpty() ? null : gisDBs.get(0);
            VODescriptor vODescriptor = new VODescriptor(scope, geoServers, geoNetwork, internal, gisDb, publisher);
            return vODescriptor;
        }
        catch (Exception e) {
            logger.error("Unexpected Error while crawling scope " + scope + ", error message : " + e.getMessage());
            throw e;
        }
        finally {
            ScopeProvider.instance.set(callerScope);
        }
    }

    protected static ArrayList<GCUBEScope> findAvailableScopes(GCUBEScope Infrastructure) throws Exception {
        GCUBEScope scope;
        HashSet<GCUBEScope> toReturn = new HashSet<GCUBEScope>();
        GCUBEScope[] gCUBEScopeArray = GHNContext.getContext().getStartScopes();
        int n = gCUBEScopeArray.length;
        int n2 = 0;
        while (n2 < n) {
            scope = gCUBEScopeArray[n2];
            toReturn.add(scope);
            toReturn.addAll(ConfigurationManager.getChildren(scope));
            ++n2;
        }
        gCUBEScopeArray = GHNContext.getContext().getStartScopes();
        n = gCUBEScopeArray.length;
        n2 = 0;
        while (n2 < n) {
            scope = gCUBEScopeArray[n2];
            toReturn.add(scope);
            toReturn.addAll(ConfigurationManager.getChildren(scope));
            ++n2;
        }
        toReturn.add(Infrastructure);
        return new ArrayList<GCUBEScope>(toReturn);
    }

    protected static ArrayList<GCUBEScope> getChildren(GCUBEScope scope) throws Exception {
        ArrayList<GCUBEScope> toReturn = new ArrayList<GCUBEScope>();
        if (!scope.getType().equals((Object)GCUBEScope.Type.VRE)) {
            logger.debug("Retrieving children of scope " + scope + ", (" + scope.getType() + ")");
            XQuery query = ICFactory.queryFor(GenericResource.class);
            String secondaryType = scope.getType().equals((Object)GCUBEScope.Type.VO) ? "VRE" : "VO";
            query.addCondition("$resource/Profile/SecondaryType/text() eq '" + secondaryType + "'");
            DiscoveryClient client = ICFactory.clientFor(GenericResource.class);
            ScopeProvider.instance.set(scope.toString());
            for (GenericResource res : client.submit((Query)query)) {
                try {
                    StringWriter writer = new StringWriter();
                    transformer.transform(new DOMSource(res.profile().body()), new StreamResult(writer));
                    String theXML = writer.getBuffer().toString();
                    String foundScope = ParserXPath.getTextFromXPathExpression("<rootNode>" + theXML + "</rootNode>", "//Scope").get(0);
                    toReturn.add(GCUBEScope.getScope((String)foundScope));
                }
                catch (Exception e) {
                    logger.warn("Unable to detect scope from generic resource [ID : " + res.id() + "] under scope " + scope, (Throwable)e);
                }
            }
        }
        return toReturn;
    }

    protected static List<DBDescriptor> getGISDBDescriptor() throws NumberFormatException, Exception {
        logger.debug("Checking gis DBs");
        ArrayList<DBDescriptor> toReturn = new ArrayList<DBDescriptor>();
        XQuery query = ICFactory.queryFor(ServiceEndpoint.class);
        query.addCondition("$resource/Profile/Category/text() eq '" + ISQueryConstants.get().getGeoServerDBCategory() + "'").addCondition("$resource/Profile/Platform/Name/text() eq '" + ISQueryConstants.get().getGeoServerDBPlatformName() + "'").setResult("$resource/Profile/AccessPoint");
        DiscoveryClient client = ICFactory.clientFor(ServiceEndpoint.AccessPoint.class);
        for (ServiceEndpoint.AccessPoint point : client.submit((Query)query)) {
            Map map = point.propertyMap();
            if (!point.name().equals(ISQueryConstants.get().getGeoServerDBEntryName()) || !map.containsKey(ISQueryConstants.get().getGeoServerDBAquaMapsDataStore()) || !Boolean.parseBoolean(((ServiceEndpoint.Property)map.get(ISQueryConstants.get().getGeoServerDBAquaMapsDataStore())).value())) continue;
            logger.debug("Found Access point " + point.address());
            DBDescriptor toAdd = new DBDescriptor(point.address(), point.username(), ConfigurationManager.decrypt(point.password()), DBDescriptor.DBType.postgres, Integer.parseInt(((ServiceEndpoint.Property)map.get(ISQueryConstants.get().getDBMaxConnection())).value()));
            toAdd.setProperty(DBDescriptor.AQUAMAPS_WORLD_TABLE, ((ServiceEndpoint.Property)map.get(DBDescriptor.AQUAMAPS_WORLD_TABLE)).value());
            toReturn.add(toAdd);
        }
        return toReturn;
    }

    protected static List<DBDescriptor> getInternalDB() throws NumberFormatException, Exception {
        logger.debug("Checking internal DBs");
        ArrayList<DBDescriptor> toReturn = new ArrayList<DBDescriptor>();
        XQuery query = ICFactory.queryFor(ServiceEndpoint.class);
        query.addCondition("$resource/Profile/Category/text() eq '" + ISQueryConstants.get().getInternalDBCategoryName() + "'").addCondition("$resource/Profile/Platform/Name/text() eq '" + ISQueryConstants.get().getInternalDBPlatformName() + "'").setResult("$resource/Profile/AccessPoint");
        DiscoveryClient client = ICFactory.clientFor(ServiceEndpoint.AccessPoint.class);
        for (ServiceEndpoint.AccessPoint point : client.submit((Query)query)) {
            Map map = point.propertyMap();
            if (!point.name().equals(ISQueryConstants.get().getInternalDBEntryName()) || !map.containsKey(ISQueryConstants.get().getInternalDBSchemaName()) || !((ServiceEndpoint.Property)map.get(ISQueryConstants.get().getInternalDBSchemaName())).value().equals(ISQueryConstants.get().getInternalDBSchemaValue())) continue;
            logger.debug("Found Access point " + point.address());
            DBDescriptor toAdd = new DBDescriptor(point.address(), point.username(), ConfigurationManager.decrypt(point.password()), DBDescriptor.DBType.postgres, Integer.parseInt(((ServiceEndpoint.Property)map.get(ISQueryConstants.get().getDBMaxConnection())).value()));
            toAdd.setProperty(DBDescriptor.TABLESPACE_PREFIX, ((ServiceEndpoint.Property)map.get(DBDescriptor.TABLESPACE_PREFIX)).value());
            toAdd.setProperty(DBDescriptor.TABLESPACE_COUNT, ((ServiceEndpoint.Property)map.get(DBDescriptor.TABLESPACE_COUNT)).value());
            toReturn.add(toAdd);
        }
        return toReturn;
    }

    protected static List<GeoServerDescriptor> getGeoServers() throws Exception {
        logger.debug("Checking geoServers..");
        ArrayList<GeoServerDescriptor> toReturn = new ArrayList<GeoServerDescriptor>();
        XQuery query = ICFactory.queryFor(ServiceEndpoint.class);
        query.addCondition("$resource/Profile/Category/text() eq '" + ISQueryConstants.get().getGeoServerCategoryName() + "'").addCondition("$resource/Profile/Platform/Name/text() eq '" + ISQueryConstants.get().getGeoServerPlatformName() + "'").setResult("$resource/Profile/AccessPoint");
        DiscoveryClient client = ICFactory.clientFor(ServiceEndpoint.AccessPoint.class);
        for (ServiceEndpoint.AccessPoint point : client.submit((Query)query)) {
            if (!point.name().equals(ISQueryConstants.get().getGeoServerEntryName())) continue;
            Map map = point.propertyMap();
            logger.debug("Found Access point " + point.address());
            toReturn.add(new GeoServerDescriptor(point.address(), point.username(), ConfigurationManager.decrypt(point.password()), ((ServiceEndpoint.Property)map.get(ISQueryConstants.get().getGeoServerAquaMapsWorkspace())).value(), ((ServiceEndpoint.Property)map.get(ISQueryConstants.get().getGeoServerAquaMapsDataStore())).value(), ((ServiceEndpoint.Property)map.get(ISQueryConstants.get().getGeoServerAquaMapsDefaultDistributionStyle())).value()));
        }
        return toReturn;
    }

    protected static List<DataSourceDescriptor> getGeoNetwork() throws Exception {
        logger.debug("Checking geoNetwork..");
        ArrayList<DataSourceDescriptor> toReturn = new ArrayList<DataSourceDescriptor>();
        XQuery query = ICFactory.queryFor(ServiceEndpoint.class);
        query.addCondition("$resource/Profile/Category/text() eq '" + ISQueryConstants.get().getGeoNetworkCategoryName() + "'").addCondition("$resource/Profile/Platform/Name/text() eq '" + ISQueryConstants.get().getGeoNetworkPlatformName() + "'").setResult("$resource/Profile/AccessPoint");
        DiscoveryClient client = ICFactory.clientFor(ServiceEndpoint.AccessPoint.class);
        for (ServiceEndpoint.AccessPoint point : client.submit((Query)query)) {
            if (!point.name().equals(ISQueryConstants.get().getGeoNetworkEntryName())) continue;
            logger.debug("Found Access point " + point.address());
            toReturn.add(new DataSourceDescriptor(point.address(), point.username(), ConfigurationManager.decrypt(point.password())));
        }
        return toReturn;
    }

    protected static ArrayList<DBDescriptor> getPublisherDB() throws Exception {
        logger.debug("Checking internal DBs");
        ArrayList<DBDescriptor> toReturn = new ArrayList<DBDescriptor>();
        XQuery query = ICFactory.queryFor(ServiceEndpoint.class);
        query.addCondition("$resource/Profile/Category/text() eq '" + ISQueryConstants.get().getPublisherDBCategoryName() + "'").addCondition("$resource/Profile/Platform/Name/text() eq '" + ISQueryConstants.get().getPublisherDBPlatformName() + "'").setResult("$resource/Profile/AccessPoint");
        DiscoveryClient client = ICFactory.clientFor(ServiceEndpoint.AccessPoint.class);
        for (ServiceEndpoint.AccessPoint point : client.submit((Query)query)) {
            Map map = point.propertyMap();
            if (!point.name().equals(ISQueryConstants.get().getPublisherDBEntryName()) || !map.containsKey(ISQueryConstants.get().getPublisherDBSchemaName()) || !((ServiceEndpoint.Property)map.get(ISQueryConstants.get().getPublisherDBSchemaName())).value().equals(ISQueryConstants.get().getPublisherDBSchemaValue())) continue;
            logger.debug("Found Access point " + point.address());
            DBDescriptor toAdd = new DBDescriptor(point.address(), point.username(), ConfigurationManager.decrypt(point.password()), DBDescriptor.DBType.postgres, Integer.parseInt(((ServiceEndpoint.Property)map.get(ISQueryConstants.get().getDBMaxConnection())).value()));
            toReturn.add(toAdd);
        }
        return toReturn;
    }

    private static final String decrypt(String toDecrypt) throws Exception {
        return StringEncrypter.getEncrypter().decrypt(toDecrypt, new Key[0]);
    }
}

