/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.application.aquamaps.aquamapsservice.impl.db.managers.threads;

import java.sql.ParameterMetaData;
import java.sql.PreparedStatement;
import java.util.ArrayList;
import java.util.List;
import net.sf.csv4j.CSVLineProcessor;
import org.gcube.application.aquamaps.aquamapsservice.impl.db.DBSession;
import org.gcube.application.aquamaps.aquamapsservice.impl.db.managers.SourceManager;
import org.gcube.application.aquamaps.aquamapsservice.stubs.datamodel.enhanced.Field;
import org.gcube.application.aquamaps.aquamapsservice.stubs.datamodel.enhanced.Resource;
import org.gcube.application.aquamaps.aquamapsservice.stubs.datamodel.types.ResourceStatus;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StatefullCSVLineProcessor
implements CSVLineProcessor {
    static final Logger logger = LoggerFactory.getLogger(StatefullCSVLineProcessor.class);
    boolean continueProcess = true;
    private PreparedStatement ps = null;
    private DBSession session = null;
    private Long count = 0L;
    private ResourceStatus status = ResourceStatus.Completed;
    private List<Field> model;
    private int[] modelCSVFieldsMapping;
    private Long totalCount;
    private boolean[] fieldsMask;
    private long updateStep;
    private Resource toFillResource;

    public StatefullCSVLineProcessor(List<Field> model, Resource tofillResource, Long totalCount, boolean[] fieldsmask) {
        this.model = model;
        this.modelCSVFieldsMapping = new int[model.size()];
        this.totalCount = totalCount;
        this.toFillResource = tofillResource;
        this.fieldsMask = fieldsmask;
        this.updateStep = totalCount > 1000L ? 1000L : totalCount / 5L;
        logger.info("Instatiated Line Processor");
        logger.info("csv parsed row count : " + totalCount);
        logger.info("to Fill Resource : " + this.toFillResource);
    }

    public boolean continueProcessing() {
        return this.continueProcess;
    }

    public void processDataLine(int arg0, List<String> arg1) {
        ArrayList<Field> line = new ArrayList<Field>();
        try {
            for (int i = 0; i < this.model.size(); ++i) {
                Field modelField = this.model.get(i);
                line.add(new Field(modelField.getName(), arg1.get(this.modelCSVFieldsMapping[i]), modelField.getType()));
            }
            this.count = this.count + (long)this.session.fillParameters(line, 0, this.ps).executeUpdate();
            if (this.count % this.updateStep == 0L) {
                logger.debug("Updateing " + this.count + " / " + this.totalCount);
                SourceManager.setCountRow(this.toFillResource.getSearchId(), this.count);
            }
        }
        catch (Exception e) {
            logger.error("Unable to insert row", (Throwable)e);
            try {
                ParameterMetaData meta = this.ps.getParameterMetaData();
                logger.error("Parameters :");
                for (int i = 0; i < meta.getParameterCount(); ++i) {
                    Field f = (Field)line.get(i);
                    logger.error(f.getName() + " FIELD TYPE : " + f.getType() + " SQL TYPE : " + meta.getParameterType(i + 1) + " VALUE :" + f.getValue());
                }
            }
            catch (Exception e1) {
                logger.error("Unable to read parameter metadata ", (Throwable)e1);
            }
            this.status = ResourceStatus.Error;
        }
    }

    public void processHeaderLine(int arg0, List<String> arg1) {
        try {
            logger.trace("Processing Header..");
            boolean bl = this.continueProcess = arg1.size() == this.model.size();
            if (this.continueProcess) {
                int i;
                for (i = 0; i < arg1.size(); ++i) {
                    if (!this.fieldsMask[i]) continue;
                    boolean found = false;
                    for (int j = 0; j < this.model.size(); ++j) {
                        if (!arg1.get(i).equalsIgnoreCase(this.model.get(j).getName())) continue;
                        this.modelCSVFieldsMapping[j] = i;
                        found = true;
                        break;
                    }
                    if (found) continue;
                    throw new Exception("Found field " + arg1.get(i) + " has no match in table");
                }
                logger.trace("Matched " + arg1.size() + " fields : ");
                for (i = 0; i < this.model.size(); ++i) {
                    Field modelField = this.model.get(i);
                    logger.debug(modelField.getName() + " , " + arg1.get(this.modelCSVFieldsMapping[i]) + " , " + modelField.getType());
                }
            } else {
                throw new Exception("Selected Type and csv fields count are not compatible");
            }
            this.session = DBSession.getInternalDBSession();
            this.session.disableAutoCommit();
            this.ps = this.session.getPreparedStatementForInsert(this.model, this.toFillResource.getTableName());
        }
        catch (Exception e) {
            logger.error("Unable to initialize reading", (Throwable)e);
            this.continueProcess = false;
            this.status = ResourceStatus.Error;
        }
    }

    public void close() {
        if (this.session != null) {
            try {
                logger.info("finalizing csv process...");
                this.session.commit();
                this.session.close();
            }
            catch (Exception e) {
                logger.warn("Unable to close session", (Throwable)e);
            }
        }
        try {
            this.toFillResource.setRowCount(this.count);
            this.toFillResource.setStatus(this.status);
            logger.info("Updateing resource " + this.toFillResource);
            SourceManager.update(this.toFillResource);
        }
        catch (Exception e) {
            logger.warn("Unable to update resource meta ", (Throwable)e);
        }
    }
}

