/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.application.aquamaps.aquamapsservice.impl.db.managers;

import java.io.IOException;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.gcube.application.aquamaps.aquamapsservice.impl.db.DBSession;
import org.gcube.application.aquamaps.aquamapsservice.impl.db.DBUtils;
import org.gcube.application.aquamaps.aquamapsservice.stubs.datamodel.enhanced.Field;
import org.gcube.application.aquamaps.aquamapsservice.stubs.datamodel.enhanced.Submitted;
import org.gcube.application.aquamaps.aquamapsservice.stubs.datamodel.fields.SubmittedFields;
import org.gcube.application.aquamaps.aquamapsservice.stubs.datamodel.types.FieldType;
import org.gcube.application.aquamaps.aquamapsservice.stubs.datamodel.types.SubmittedStatus;
import org.gcube.application.aquamaps.aquamapsservice.stubs.datamodel.utils.CSVUtils;
import org.gcube_system.namespaces.application.aquamaps.types.OrderDirection;
import org.gcube_system.namespaces.application.aquamaps.types.PagedRequestSettings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SubmittedManager {
    static final Logger logger = LoggerFactory.getLogger(SubmittedManager.class);
    public static final String submittedTable = "submitted";

    protected static Object getField(int id, SubmittedFields field) throws Exception {
        DBSession session = null;
        try {
            session = DBSession.getInternalDBSession();
            ArrayList<Field> filter = new ArrayList<Field>();
            filter.add(new Field(SubmittedFields.searchid + "", id + "", FieldType.INTEGER));
            ResultSet rs = session.executeFilteredQuery(filter, submittedTable, SubmittedFields.searchid + "", OrderDirection.ASC);
            if (rs.next()) {
                Object object = rs.getObject(field.toString());
                return object;
            }
            Object var5_7 = null;
            return var5_7;
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            if (session != null) {
                session.close();
            }
        }
    }

    protected static int updateField(int id, SubmittedFields field, FieldType type, Object value) throws Exception {
        DBSession session = null;
        try {
            session = DBSession.getInternalDBSession();
            ArrayList<List<Field>> keys = new ArrayList<List<Field>>();
            ArrayList<Field> filter = new ArrayList<Field>();
            filter.add(new Field(SubmittedFields.searchid + "", id + "", FieldType.INTEGER));
            keys.add(filter);
            ArrayList<List<Field>> values = new ArrayList<List<Field>>();
            ArrayList<Field> valueList = new ArrayList<Field>();
            valueList.add(new Field(field + "", value + "", type));
            values.add(valueList);
            int n = session.updateOperation(submittedTable, keys, values);
            return n;
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            if (session != null) {
                session.close();
            }
        }
    }

    public static int deleteFromTables(int submittedId) throws Exception {
        DBSession session = null;
        try {
            session = DBSession.getInternalDBSession();
            ArrayList<Field> filter = new ArrayList<Field>();
            filter.add(new Field(SubmittedFields.searchid + "", submittedId + "", FieldType.INTEGER));
            int n = session.deleteOperation(submittedTable, filter);
            return n;
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            if (session != null) {
                session.close();
            }
        }
    }

    public static int delete(int submittedId) throws Exception {
        Boolean isAquaMaps = SubmittedManager.isAquaMap(submittedId);
        DBSession session = null;
        try {
            int count = 0;
            ArrayList<List<Field>> keys = new ArrayList<List<Field>>();
            ArrayList<Field> key = new ArrayList<Field>();
            key.add(new Field(SubmittedFields.searchid + "", submittedId + "", FieldType.INTEGER));
            keys.add(key);
            ArrayList<List<Field>> rows = new ArrayList<List<Field>>();
            ArrayList<Field> toSet = new ArrayList<Field>();
            toSet.add(new Field(SubmittedFields.todelete + "", "true", FieldType.BOOLEAN));
            rows.add(toSet);
            session = DBSession.getInternalDBSession();
            session.disableAutoCommit();
            count += session.updateOperation(submittedTable, keys, rows);
            if (!isAquaMaps.booleanValue()) {
                ((List)keys.get(0)).set(0, new Field(SubmittedFields.jobid + "", submittedId + "", FieldType.INTEGER));
                count += session.updateOperation(submittedTable, keys, rows);
            }
            session.commit();
            int n = count;
            return n;
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            if (session != null) {
                session.close();
            }
        }
    }

    public static int getHCAFTableId(int jobId) throws Exception {
        return (Integer)SubmittedManager.getField(jobId, SubmittedFields.sourcehcaf);
    }

    public static int getHSPENTableId(int jobId) throws Exception {
        return (Integer)SubmittedManager.getField(jobId, SubmittedFields.sourcehspen);
    }

    public static int getHSPECTableId(int jobId) throws Exception {
        return (Integer)SubmittedManager.getField(jobId, SubmittedFields.sourcehspec);
    }

    public static Boolean isGIS(int submittedId) throws Exception {
        return (Integer)SubmittedManager.getField(submittedId, SubmittedFields.gisenabled) == 1;
    }

    public static List<String> getGisId(int submittedId) throws Exception {
        return CSVUtils.CSVToStringList((String)((String)SubmittedManager.getField(submittedId, SubmittedFields.gispublishedid)));
    }

    public static SubmittedStatus getStatus(int submittedId) throws Exception {
        return SubmittedStatus.valueOf((String)((String)SubmittedManager.getField(submittedId, SubmittedFields.status)));
    }

    public static String getAuthor(int submittedId) throws Exception {
        return (String)SubmittedManager.getField(submittedId, SubmittedFields.author);
    }

    public static Boolean isAquaMap(int submittedId) throws Exception {
        return (Integer)SubmittedManager.getField(submittedId, SubmittedFields.isaquamap) == 1;
    }

    public static int updateGISData(int submittedId, Boolean gisEnabled) throws Exception {
        return SubmittedManager.updateField(submittedId, SubmittedFields.gisenabled, FieldType.BOOLEAN, gisEnabled + "");
    }

    public static int markSaved(int submittedId) throws Exception {
        return SubmittedManager.updateField(submittedId, SubmittedFields.saved, FieldType.BOOLEAN, true);
    }

    public static int setGisPublishedId(int submittedId, String gisId) throws Exception {
        return SubmittedManager.updateField(submittedId, SubmittedFields.gispublishedid, FieldType.STRING, gisId);
    }

    public static int setSerializedPath(int submittedId, String path) throws Exception {
        return SubmittedManager.updateField(submittedId, SubmittedFields.serializedrequest, FieldType.STRING, path);
    }

    public static void updateStatus(int toUpdateId, SubmittedStatus statusValue) throws SQLException, IOException, Exception {
        SubmittedManager.updateField(toUpdateId, SubmittedFields.status, FieldType.STRING, statusValue.toString());
        if (statusValue.equals((Object)SubmittedStatus.Error) || statusValue.equals((Object)SubmittedStatus.Completed)) {
            SubmittedManager.updateField(toUpdateId, SubmittedFields.endtime, FieldType.LONG, System.currentTimeMillis() + "");
        }
        logger.trace("done submitted[ID : " + toUpdateId + "] status updateing status : " + statusValue.toString());
    }

    public static Submitted insertInTable(Submitted toInsert) throws Exception {
        DBSession session = null;
        try {
            session = DBSession.getInternalDBSession();
            ArrayList<List<Field>> rows = new ArrayList<List<Field>>();
            ArrayList<Field> row = new ArrayList<Field>();
            for (Field f : toInsert.toRow()) {
                if (f.getName().equals(SubmittedFields.searchid + "")) continue;
                row.add(f);
            }
            rows.add(row);
            List<List<Field>> inserted = session.insertOperation(submittedTable, rows);
            Submitted submitted = new Submitted(inserted.get(0));
            return submitted;
        }
        catch (Exception e) {
            logger.error("Unable to insert submitted " + toInsert);
            throw e;
        }
        finally {
            if (session != null) {
                session.close();
            }
        }
    }

    public static List<Submitted> getList(List<Field> filters) throws Exception {
        DBSession session = null;
        try {
            session = DBSession.getInternalDBSession();
            ArrayList arrayList = Submitted.loadResultSet((ResultSet)session.executeFilteredQuery(filters, submittedTable, null, null));
            return arrayList;
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            if (session != null) {
                session.close();
            }
        }
    }

    public static String getJsonList(List<Field> filters, PagedRequestSettings settings) throws Exception {
        DBSession session = null;
        try {
            session = DBSession.getInternalDBSession();
            String string = DBUtils.toJSon(session.executeFilteredQuery(filters, submittedTable, settings.getOrderField(), settings.getOrderDirection()), settings.getOffset(), settings.getLimit() + settings.getOffset());
            return string;
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            if (session != null) {
                session.close();
            }
        }
    }

    public static Submitted getSubmittedById(int objId) throws Exception {
        ArrayList<Field> filter = new ArrayList<Field>();
        filter.add(new Field(SubmittedFields.searchid + "", objId + "", FieldType.INTEGER));
        List<Submitted> found = SubmittedManager.getList(filter, new PagedRequestSettings(1, 0, OrderDirection.ASC, SubmittedFields.searchid + ""));
        return found.get(0);
    }

    public static void update(Submitted toUpdate) throws Exception {
        DBSession session = null;
        try {
            session = DBSession.getInternalDBSession();
            ArrayList<Field> id = new ArrayList<Field>();
            id.add(toUpdate.getField(SubmittedFields.searchid));
            ArrayList<Field> values = new ArrayList<Field>();
            for (Field f : toUpdate.toRow()) {
                if (f.getName().equals(SubmittedFields.searchid + "")) continue;
                values.add(f);
            }
            PreparedStatement psUpdate = session.getPreparedStatementForUpdate(values, id, submittedTable);
            psUpdate = session.fillParameters(values, 0, psUpdate);
            psUpdate = session.fillParameters(id, values.size(), psUpdate);
            psUpdate.executeUpdate();
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            if (session != null) {
                session.close();
            }
        }
    }

    public static List<Submitted> getList(List<Field> filter, PagedRequestSettings settings) throws Exception {
        DBSession session = null;
        try {
            session = DBSession.getInternalDBSession();
            ArrayList<Submitted> toReturn = new ArrayList<Submitted>();
            ResultSet rs = session.executeFilteredQuery(filter, submittedTable, settings.getOrderField(), settings.getOrderDirection());
            int rowIndex = 0;
            while (rs.next() && toReturn.size() < settings.getLimit()) {
                if (rowIndex >= settings.getOffset()) {
                    toReturn.add(new Submitted(rs));
                }
                ++rowIndex;
            }
            ArrayList<Submitted> arrayList = toReturn;
            return arrayList;
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            if (session != null) {
                session.close();
            }
        }
    }

    public static Long getCount(List<Field> filter) throws Exception {
        DBSession session = null;
        try {
            session = DBSession.getInternalDBSession();
            Long l = session.getCount(submittedTable, filter);
            return l;
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            if (session != null) {
                session.close();
            }
        }
    }

    public static void setStartTime(int submittedId) throws Exception {
        SubmittedManager.updateField(submittedId, SubmittedFields.starttime, FieldType.LONG, System.currentTimeMillis());
    }
}

