/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.application.aquamaps.aquamapsservice.impl.db.managers;

import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.gcube.application.aquamaps.aquamapsservice.impl.db.DBSession;
import org.gcube.application.aquamaps.aquamapsservice.impl.db.DBUtils;
import org.gcube.application.aquamaps.aquamapsservice.impl.db.managers.threads.SourceImporter;
import org.gcube.application.aquamaps.aquamapsservice.impl.util.ServiceUtils;
import org.gcube.application.aquamaps.aquamapsservice.impl.util.isconfig.ConfigurationManager;
import org.gcube.application.aquamaps.aquamapsservice.impl.util.isconfig.DBDescriptor;
import org.gcube.application.aquamaps.aquamapsservice.stubs.ExportCSVSettings;
import org.gcube.application.aquamaps.aquamapsservice.stubs.ImportResourceRequestType;
import org.gcube.application.aquamaps.aquamapsservice.stubs.datamodel.enhanced.Field;
import org.gcube.application.aquamaps.aquamapsservice.stubs.datamodel.enhanced.Resource;
import org.gcube.application.aquamaps.aquamapsservice.stubs.datamodel.fields.MetaSourceFields;
import org.gcube.application.aquamaps.aquamapsservice.stubs.datamodel.types.FieldType;
import org.gcube.application.aquamaps.aquamapsservice.stubs.datamodel.types.ResourceStatus;
import org.gcube.application.aquamaps.aquamapsservice.stubs.datamodel.types.ResourceType;
import org.gcube.common.core.utils.logging.GCUBELog;
import org.gcube_system.namespaces.application.aquamaps.types.OrderDirection;
import org.gcube_system.namespaces.application.aquamaps.types.PagedRequestSettings;

public class SourceManager {
    private static final GCUBELog logger = new GCUBELog(SourceManager.class);
    private static final String sourcesTable = "meta_sources";

    public static int getDefaultId(ResourceType type) throws Exception {
        DBSession session = null;
        try {
            session = DBSession.getInternalDBSession();
            ArrayList<Field> filter = new ArrayList<Field>();
            filter.add(new Field("" + MetaSourceFields.type, "" + type, FieldType.STRING));
            filter.add(new Field("" + MetaSourceFields.defaultsource, "true", FieldType.BOOLEAN));
            Set<Resource> found = SourceManager.loadRS(session.executeFilteredQuery(filter, sourcesTable, "" + MetaSourceFields.searchid, OrderDirection.ASC));
            if (found.isEmpty()) {
                throw new Exception("No Default Found for type " + type);
            }
            int n = found.iterator().next().getSearchId();
            return n;
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            if (session != null && session != null) {
                session.close();
            }
        }
    }

    public static Resource registerSource(Resource toRegister) throws Exception {
        DBSession session = null;
        logger.trace((Object)("registering source " + toRegister));
        try {
            session = DBSession.getInternalDBSession();
            ArrayList<List<Field>> rows = new ArrayList<List<Field>>();
            ArrayList<Field> row = new ArrayList<Field>();
            MetaSourceFields[] metaSourceFieldsArray = MetaSourceFields.values();
            int n = metaSourceFieldsArray.length;
            int n2 = 0;
            while (n2 < n) {
                MetaSourceFields field = metaSourceFieldsArray[n2];
                if (!field.equals((Object)MetaSourceFields.searchid)) {
                    row.add(toRegister.getField(field));
                }
                ++n2;
            }
            rows.add(row);
            List<List<Field>> ids = session.insertOperation(sourcesTable, rows);
            for (Field f : ids.get(0)) {
                if (!f.getName().equals("" + MetaSourceFields.searchid)) continue;
                toRegister.setSearchId(f.getValueAsInteger().intValue());
            }
            logger.trace((Object)("registered source with id : " + toRegister.getSearchId()));
            Resource resource = toRegister;
            return resource;
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            if (session != null) {
                session.close();
            }
        }
    }

    public static void deleteSource(int id, boolean deleteTable) throws Exception {
        DBSession session = null;
        try {
            session = DBSession.getInternalDBSession();
            Resource toDelete = SourceManager.getById(id);
            ArrayList<Field> filter = new ArrayList<Field>();
            filter.add(new Field("" + MetaSourceFields.searchid, String.valueOf(id), FieldType.INTEGER));
            session.deleteOperation(sourcesTable, filter);
            if (deleteTable) {
                session.dropTable(toDelete.getTableName());
            }
        }
        finally {
            if (session != null) {
                session.close();
            }
        }
    }

    public static String getSourceName(int id) throws Exception {
        return (String)SourceManager.getField(id, MetaSourceFields.tablename);
    }

    public static String getSourceTitle(int id) throws Exception {
        return (String)SourceManager.getField(id, MetaSourceFields.title);
    }

    private static Object getField(int id, MetaSourceFields field) throws Exception {
        DBSession session = null;
        try {
            session = DBSession.getInternalDBSession();
            ArrayList<Field> filter = new ArrayList<Field>();
            filter.add(new Field("" + MetaSourceFields.searchid, String.valueOf(id), FieldType.INTEGER));
            ResultSet rs = session.executeFilteredQuery(filter, sourcesTable, "" + MetaSourceFields.searchid, OrderDirection.ASC);
            if (rs.next()) {
                Object object = rs.getObject("" + field);
                return object;
            }
            return null;
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            if (session != null) {
                session.close();
            }
        }
    }

    private static int updateField(int id, MetaSourceFields field, FieldType objectType, Object value) throws Exception {
        DBSession session = null;
        try {
            session = DBSession.getInternalDBSession();
            ArrayList<List<Field>> keys = new ArrayList<List<Field>>();
            ArrayList<Field> filter = new ArrayList<Field>();
            filter.add(new Field("" + MetaSourceFields.searchid, String.valueOf(id), FieldType.INTEGER));
            keys.add(filter);
            ArrayList<List<Field>> values = new ArrayList<List<Field>>();
            ArrayList<Field> valueList = new ArrayList<Field>();
            valueList.add(new Field("" + field, "" + value, objectType));
            values.add(valueList);
            int n = session.updateOperation(sourcesTable, keys, values);
            return n;
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            if (session != null) {
                session.close();
            }
        }
    }

    public static void setTableTitle(int id, String tableTitle) throws Exception {
        SourceManager.updateField(id, MetaSourceFields.title, FieldType.STRING, tableTitle);
    }

    public static void setCountRow(int id, Long count) throws Exception {
        SourceManager.updateField(id, MetaSourceFields.rowcount, FieldType.INTEGER, count);
    }

    public static Set<Resource> getList(List<Field> filter) throws Exception {
        DBSession session = null;
        try {
            session = DBSession.getInternalDBSession();
            Set<Resource> set = SourceManager.loadRS(session.executeFilteredQuery(filter, sourcesTable, "" + MetaSourceFields.searchid, OrderDirection.ASC));
            return set;
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            if (session != null) {
                session.close();
            }
        }
    }

    public static String getJsonList(List<Field> filter, PagedRequestSettings settings) throws Exception {
        DBSession session = null;
        try {
            session = DBSession.getInternalDBSession();
            String string = DBUtils.toJSon(session.executeFilteredQuery(filter, sourcesTable, settings.getOrderField(), settings.getOrderDirection()), settings.getOffset(), settings.getLimit() + settings.getOffset());
            return string;
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            if (session != null) {
                session.close();
            }
        }
    }

    private static Set<Resource> loadRS(ResultSet rs) throws Exception {
        HashSet<Resource> toReturn = new HashSet<Resource>();
        while (rs.next()) {
            toReturn.add(new Resource(rs));
        }
        return toReturn;
    }

    public static Resource getById(int id) throws Exception {
        if (id == 0) {
            return null;
        }
        DBSession session = null;
        try {
            session = DBSession.getInternalDBSession();
            ArrayList<Field> filters = new ArrayList<Field>();
            filters.add(new Field("" + MetaSourceFields.searchid, String.valueOf(id), FieldType.INTEGER));
            Resource resource = SourceManager.loadRS(session.executeFilteredQuery(filters, sourcesTable, "" + MetaSourceFields.searchid, OrderDirection.ASC)).iterator().next();
            return resource;
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            if (session != null) {
                session.close();
            }
        }
    }

    public static int update(Resource toUpdate) throws Exception {
        DBSession session = null;
        try {
            ArrayList<List<Field>> keys;
            ArrayList<List<Field>> values;
            session = DBSession.getInternalDBSession();
            session.disableAutoCommit();
            if (toUpdate.getDefaultSource().booleanValue()) {
                values = new ArrayList<List<Field>>();
                ArrayList<Field> toSet = new ArrayList<Field>();
                toSet.add(new Field("" + MetaSourceFields.defaultsource, "false", FieldType.BOOLEAN));
                values.add(toSet);
                keys = new ArrayList();
                ArrayList<Field> key = new ArrayList<Field>();
                key.add(toUpdate.getField(MetaSourceFields.type));
                keys.add(key);
                session.updateOperation(sourcesTable, keys, values);
            }
            values = new ArrayList();
            ArrayList<Field> value = new ArrayList<Field>();
            MetaSourceFields[] metaSourceFieldsArray = MetaSourceFields.values();
            int n = metaSourceFieldsArray.length;
            int key = 0;
            while (key < n) {
                MetaSourceFields field = metaSourceFieldsArray[key];
                if (!field.equals((Object)MetaSourceFields.searchid)) {
                    value.add(toUpdate.getField(field));
                }
                ++key;
            }
            values.add(value);
            keys = new ArrayList<List<Field>>();
            ArrayList<Field> key2 = new ArrayList<Field>();
            key2.add(toUpdate.getField(MetaSourceFields.searchid));
            keys.add(key2);
            int rows = session.updateOperation(sourcesTable, keys, values);
            session.commit();
            int n2 = rows;
            return n2;
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            if (session != null) {
                session.close();
            }
        }
    }

    public static Integer importFromCSVFile(ImportResourceRequestType request) throws Exception {
        DBSession session = null;
        try {
            ResourceType type = ResourceType.valueOf((String)request.getResourceType());
            session = DBSession.getInternalDBSession();
            String tableName = ServiceUtils.generateId("" + type, "").toLowerCase();
            session.createLikeTable(tableName, SourceManager.getById(SourceManager.getDefaultId(type)).getTableName());
            Resource toRegister = new Resource(type, 0);
            toRegister.setAuthor(request.getUser());
            toRegister.setDefaultSource(Boolean.valueOf(false));
            toRegister.setGenerationTime(Long.valueOf(System.currentTimeMillis()));
            toRegister.setDescription("Imported csv file ");
            toRegister.setTableName(tableName);
            toRegister.setTitle("Import_" + request.getUser());
            toRegister.setStatus(ResourceStatus.Importing);
            toRegister.setRowCount(Long.valueOf(0L));
            toRegister = SourceManager.registerSource(toRegister);
            ExportCSVSettings settings = request.getCsvSettings();
            SourceImporter t = new SourceImporter(request.getRsLocator(), toRegister, SourceManager.getDefaultId(type), settings.getDelimiter().charAt(0), settings.getFieldsMask(), settings.isHasHeader(), settings.getEncoding());
            t.start();
            Integer n = toRegister.getSearchId();
            return n;
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            if (session != null) {
                session.close();
            }
        }
    }

    public static void checkTables() throws Exception {
        DBSession session = null;
        Set<Resource> list = SourceManager.getList(new ArrayList<Field>());
        try {
            session = DBSession.getInternalDBSession();
            for (Resource r : list) {
                try {
                    logger.trace((Object)("Checking " + r));
                    boolean existing = true;
                    try {
                        session.executeQuery("SELECT * FROM " + r.getTableName() + " LIMIT 1 OFFSET 0");
                    }
                    catch (Exception e) {
                        logger.trace((Object)("Unable to detect table " + r.getTableName() + ", going to delete resource"));
                        SourceManager.deleteSource(r.getSearchId(), false);
                        existing = false;
                    }
                    if (!existing) continue;
                    if (r.getRowCount() == 0L) {
                        logger.trace((Object)"Updateing row count");
                        r.setRowCount(session.getCount(r.getTableName(), new ArrayList<Field>()));
                    }
                    HashMap sourcesLists = new HashMap();
                    sourcesLists.put(ResourceType.HCAF, new ArrayList(r.getSourceHCAFIds()));
                    sourcesLists.put(ResourceType.HSPEN, new ArrayList(r.getSourceHSPENIds()));
                    sourcesLists.put(ResourceType.HSPEC, new ArrayList(r.getSourceHSPECIds()));
                    sourcesLists.put(ResourceType.OCCURRENCECELLS, new ArrayList(r.getSourceOccurrenceCellsIds()));
                    boolean checkTableNames = false;
                    ResourceType[] resourceTypeArray = ResourceType.values();
                    int n = resourceTypeArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        ResourceType type = resourceTypeArray[n2];
                        for (Integer id : (ArrayList)sourcesLists.get(type)) {
                            Resource toCheck = SourceManager.getById(id);
                            if (toCheck == null) {
                                logger.trace((Object)("Unable to find source , id was " + id));
                                r.removeSourceId(id);
                                checkTableNames = true;
                                continue;
                            }
                            r.removeSource(toCheck);
                            r.addSource(toCheck);
                        }
                        ++n2;
                    }
                    if (checkTableNames) {
                        HashMap tableLists = new HashMap();
                        tableLists.put(ResourceType.HCAF, new ArrayList(r.getSourceHCAFTables()));
                        tableLists.put(ResourceType.HSPEN, new ArrayList(r.getSourceHSPENTables()));
                        tableLists.put(ResourceType.HSPEC, new ArrayList(r.getSourceHSPECTables()));
                        tableLists.put(ResourceType.OCCURRENCECELLS, new ArrayList(r.getSourceOccurrenceCellsTables()));
                        ResourceType[] resourceTypeArray2 = ResourceType.values();
                        int n3 = resourceTypeArray2.length;
                        n = 0;
                        while (n < n3) {
                            ResourceType type = resourceTypeArray2[n];
                            for (String table : (ArrayList)tableLists.get(type)) {
                                if (session.checkTableExist(table)) continue;
                                logger.trace((Object)("Found non existing table reference : " + table));
                                r.removeSourceTableName(table);
                            }
                            ++n;
                        }
                    }
                    SourceManager.update(r);
                }
                catch (Exception e) {
                    logger.warn((Object)("Unable to check resource " + r.getSearchId()), (Throwable)e);
                }
            }
        }
        finally {
            if (session != null) {
                session.close();
            }
        }
    }

    public static final String getToUseTableStore() throws Exception {
        DBSession session = null;
        try {
            session = DBSession.getInternalDBSession();
            ResultSet rs = session.executeFilteredQuery(new ArrayList<Field>(), sourcesTable, "" + MetaSourceFields.searchid, OrderDirection.DESC);
            int lastId = 0;
            if (rs.next()) {
                lastId = rs.getInt("" + MetaSourceFields.searchid);
                rs.close();
            }
            DBDescriptor dbDescr = ConfigurationManager.getVODescriptor().getInternalDB();
            int numTableSpaces = Integer.parseInt(dbDescr.getProperty(DBDescriptor.TABLESPACE_COUNT));
            int toUseTableSpace = (lastId + 1) % numTableSpaces + 1;
            String toReturn = String.valueOf(dbDescr.getProperty(DBDescriptor.TABLESPACE_PREFIX)) + toUseTableSpace;
            logger.debug((Object)("TableSpace to use : " + toReturn));
            String string = toReturn;
            return string;
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            if (session != null) {
                session.close();
            }
        }
    }

    public static final String getMaxMinTable(Resource Hspen) throws Exception {
        if (!Hspen.getType().equals((Object)ResourceType.HSPEN)) {
            throw new Exception("Passed Resource is not HSPEN, resource was " + Hspen);
        }
        DBSession session = null;
        try {
            session = DBSession.getInternalDBSession();
            String candidateMaxMin = "maxminlat_" + Hspen.getTableName();
            if (session.checkTableExist(candidateMaxMin)) {
                logger.debug((Object)("Found " + candidateMaxMin + " for HSPEN table " + Hspen.getTableName()));
                String string = candidateMaxMin;
                return string;
            }
            Resource defaultHSPEN = SourceManager.getById(SourceManager.getDefaultId(ResourceType.HSPEN));
            if (defaultHSPEN == null) {
                throw new Exception("Unable to evaluate default HSPEN Table");
            }
            candidateMaxMin = "maxminlat_" + defaultHSPEN.getTableName();
            if (session.checkTableExist(candidateMaxMin)) {
                logger.debug((Object)("Found " + candidateMaxMin + " (From Default HSPEN Table ID : " + defaultHSPEN.getSearchId() + ")for HSPEN table " + Hspen.getTableName()));
                String string = candidateMaxMin;
                return string;
            }
            throw new Exception("Unable to find default Max Min Hspen Table ");
        }
        finally {
            if (session != null) {
                session.close();
            }
        }
    }
}

