/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.application.aquamaps.aquamapsservice.impl.db.managers.threads;

import java.util.ArrayList;
import java.util.List;
import org.gcube.application.aquamaps.aquamapsservice.impl.ServiceContext;
import org.gcube.application.aquamaps.aquamapsservice.impl.db.managers.CustomQueryManager;
import org.gcube.application.aquamaps.aquamapsservice.impl.db.managers.SubmittedManager;
import org.gcube.application.aquamaps.aquamapsservice.impl.publishing.Generator;
import org.gcube.application.aquamaps.aquamapsservice.impl.util.ServiceUtils;
import org.gcube.application.aquamaps.aquamapsservice.stubs.datamodel.enhanced.Field;
import org.gcube.application.aquamaps.aquamapsservice.stubs.datamodel.enhanced.Submitted;
import org.gcube.application.aquamaps.aquamapsservice.stubs.datamodel.fields.SubmittedFields;
import org.gcube.application.aquamaps.aquamapsservice.stubs.datamodel.types.FieldType;
import org.gcube.application.aquamaps.publisher.Publisher;
import org.gcube.application.aquamaps.publisher.impl.model.FileSet;
import org.gcube.application.aquamaps.publisher.impl.model.Layer;
import org.gcube.application.aquamaps.publisher.impl.model.WMSContext;
import org.gcube.common.core.utils.logging.GCUBELog;

public class DeletionMonitor
extends Thread {
    private static GCUBELog logger = new GCUBELog(DeletionMonitor.class);
    private long interval;
    static final Publisher publisher = ServiceContext.getContext().getPublisher();
    private static Generator<FileSet> fileSetDestroyer = new Generator<FileSet>(null, FileSet.class);
    private static Generator<Layer> layerDestroyer = new Generator<Layer>(null, Layer.class);
    private static Generator<WMSContext> wmsContextDestroyer = new Generator<WMSContext>(null, WMSContext.class);

    public DeletionMonitor(long interval) {
        super("DELETION");
        this.interval = interval;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        while (true) {
            try {
                ArrayList<Field> toDeleteFilter = new ArrayList<Field>();
                toDeleteFilter.add(new Field(SubmittedFields.todelete + "", "true", FieldType.BOOLEAN));
                List<Submitted> foundList = SubmittedManager.getList(toDeleteFilter);
                if (foundList.size() > 0) {
                    logger.trace((Object)("Found " + foundList.size() + " to deleteObjects"));
                }
                for (Submitted toDeleteSubmitted : foundList) {
                    try {
                        long start = System.currentTimeMillis();
                        logger.debug((Object)("Deleting submitted " + toDeleteSubmitted));
                        if (toDeleteSubmitted.getIsAquaMap().booleanValue()) {
                            boolean deleteLayer = toDeleteSubmitted.getGisEnabled();
                            boolean deleteFileSet = true;
                            if (!toDeleteSubmitted.getIsCustomized().booleanValue()) {
                                ArrayList<Field> fileSetFilter = new ArrayList<Field>();
                                fileSetFilter.add(new Field(SubmittedFields.filesetid + "", toDeleteSubmitted.getFileSetId(), FieldType.STRING));
                                for (Submitted found : SubmittedManager.getList(fileSetFilter)) {
                                    if (found.getSearchId().equals(toDeleteSubmitted.getSearchId())) continue;
                                    deleteFileSet = false;
                                    break;
                                }
                                ArrayList<Field> gisFilter = new ArrayList<Field>();
                                gisFilter.add(new Field(SubmittedFields.gispublishedid + "", toDeleteSubmitted.getGisPublishedId(), FieldType.STRING));
                                for (Submitted found : SubmittedManager.getList(gisFilter)) {
                                    if (found.getSearchId().equals(toDeleteSubmitted.getSearchId())) continue;
                                    deleteLayer = false;
                                    break;
                                }
                            }
                            if (deleteFileSet && toDeleteSubmitted.getFileSetId() != null && !toDeleteSubmitted.getFileSetId().equalsIgnoreCase("null")) {
                                try {
                                    publisher.deleteById(FileSet.class, fileSetDestroyer, toDeleteSubmitted.getFileSetId());
                                }
                                catch (Exception e) {
                                    logger.warn((Object)("Unable to delete FileSet " + toDeleteSubmitted.getFileSetId()), (Throwable)e);
                                }
                            }
                            if (deleteLayer && toDeleteSubmitted.getGisPublishedId() != null && !toDeleteSubmitted.getGisPublishedId().equalsIgnoreCase("null")) {
                                try {
                                    publisher.deleteById(Layer.class, layerDestroyer, toDeleteSubmitted.getGisPublishedId());
                                }
                                catch (Exception e) {
                                    logger.warn((Object)("Unable to delete Layer " + toDeleteSubmitted.getGisPublishedId()), (Throwable)e);
                                }
                            }
                        } else {
                            try {
                                publisher.deleteById(WMSContext.class, wmsContextDestroyer, toDeleteSubmitted.getGisPublishedId());
                            }
                            catch (Exception e) {
                                logger.warn((Object)("Unable to delete WMS " + toDeleteSubmitted.getGisPublishedId()), (Throwable)e);
                            }
                        }
                        try {
                            ServiceUtils.deleteFile(toDeleteSubmitted.getSerializedRequest());
                        }
                        catch (Exception e) {
                            logger.warn((Object)("Unable to delete File " + toDeleteSubmitted.getSerializedRequest()));
                        }
                        try {
                            ServiceUtils.deleteFile(toDeleteSubmitted.getSerializedObject());
                        }
                        catch (Exception e) {
                            logger.warn((Object)("Unable to delete File " + toDeleteSubmitted.getSerializedObject()));
                        }
                        SubmittedManager.deleteFromTables(toDeleteSubmitted.getSearchId());
                        logger.debug((Object)("Deleted in " + (System.currentTimeMillis() - start)));
                    }
                    catch (Exception e) {
                        logger.warn((Object)("Unable to delete submitted " + toDeleteSubmitted), (Throwable)e);
                    }
                }
                if (!ServiceContext.getContext().getPropertyAsBoolean("CUSTOM_QUERY_DELETION").booleanValue()) continue;
                try {
                    int deletedCustomQueries = CustomQueryManager.clean();
                    if (deletedCustomQueries <= 0) continue;
                    logger.trace((Object)("Deleted " + deletedCustomQueries + " custom queries"));
                }
                catch (Exception e) {
                    logger.warn((Object)"Unable to clean custom queries");
                    logger.debug((Object)"Exception was ", (Throwable)e);
                }
                continue;
            }
            catch (Exception e) {
                logger.warn((Object)"UNEXPECTED EXCEPTION", (Throwable)e);
                continue;
            }
            finally {
                try {
                    Thread.sleep(this.interval);
                }
                catch (InterruptedException interruptedException) {}
                continue;
            }
            break;
        }
    }
}

