/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.application.aquamaps.aquamapsservice.impl.db.managers;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.List;
import org.gcube.application.aquamaps.aquamapsservice.impl.ServiceContext;
import org.gcube.application.aquamaps.aquamapsservice.impl.db.DBSession;
import org.gcube.application.aquamaps.aquamapsservice.impl.util.ServiceUtils;
import org.gcube.application.aquamaps.aquamapsservice.stubs.ExportCSVSettings;
import org.gcube.application.aquamaps.aquamapsservice.stubs.ExportOperation;
import org.gcube.application.aquamaps.aquamapsservice.stubs.ExportStatus;
import org.gcube.application.aquamaps.aquamapsservice.stubs.ExportTableStatusType;
import org.gcube.application.aquamaps.aquamapsservice.stubs.datamodel.enhanced.Field;
import org.gcube.application.aquamaps.aquamapsservice.stubs.datamodel.types.FieldType;
import org.gcube.application.aquamaps.aquamapsservice.stubs.datamodel.xstream.AquaMapsXStream;
import org.gcube.application.aquamaps.aquamapsservice.stubs.wrapper.utils.RSWrapper;
import org.gcube.common.core.scope.GCUBEScope;
import org.gcube.common.core.utils.logging.GCUBELog;
import org.gcube.portlets.user.homelibrary.home.HomeLibrary;
import org.gcube.portlets.user.homelibrary.home.HomeManagerFactory;
import org.gcube.portlets.user.homelibrary.home.workspace.Workspace;
import org.gcube_system.namespaces.application.aquamaps.types.OrderDirection;

public class ExportManager
extends Thread {
    private static final GCUBELog logger = new GCUBELog(ExportManager.class);
    private static final String EXPORT_REFERENCE_TABLE = "exports";
    private static final String EXPORT_ID = "id";
    private static final String EXPORT_TABLE = "toexporttable";
    private static final String EXPORT_SETTINGS = "settings";
    private static final String EXPORT_STATUS = "status";
    private static final String EXPORT_ERROR_MSG = "errors";
    private static final String EXPORT_LOCAL_PATH = "localpath";
    private static final String EXPORT_TIME = "time";
    private static final String EXPORT_LOCATOR = "locator";
    private static final String EXPORT_SCOPE = "scope";
    private static final String EXPORT_OPERATION = "operation";
    private static final String EXPORT_USER = "username";
    private static final String EXPORT_BASKET = "basket";
    private static final String EXPORT_NAME = "name";
    private String referenceId;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String submitExportOperation(String tableName, String user, String basket, String name, ExportOperation operation, ExportCSVSettings settings) throws Exception {
        DBSession session = null;
        try {
            session = DBSession.getInternalDBSession();
            String referenceId = ServiceUtils.generateId("EXPORT", "").toLowerCase();
            ArrayList<Field> row = new ArrayList<Field>();
            row.add(new Field(EXPORT_ID, referenceId, FieldType.STRING));
            row.add(new Field(EXPORT_TABLE, tableName, FieldType.STRING));
            row.add(new Field(EXPORT_SETTINGS, AquaMapsXStream.getXMLInstance().toXML((Object)settings), FieldType.STRING));
            row.add(new Field(EXPORT_STATUS, "PENDING", FieldType.STRING));
            row.add(new Field(EXPORT_SCOPE, ServiceContext.getContext().getScope() + "", FieldType.STRING));
            row.add(new Field(EXPORT_OPERATION, operation.toString(), FieldType.STRING));
            row.add(new Field(EXPORT_USER, user, FieldType.STRING));
            row.add(new Field(EXPORT_BASKET, basket, FieldType.STRING));
            row.add(new Field(EXPORT_NAME, name, FieldType.STRING));
            ArrayList<List<Field>> rows = new ArrayList<List<Field>>();
            rows.add(row);
            session.insertOperation(EXPORT_REFERENCE_TABLE, rows);
            ExportManager thread = new ExportManager(referenceId);
            thread.start();
            String string = referenceId;
            return string;
        }
        finally {
            if (session != null) {
                session.close();
            }
        }
    }

    public static ExportTableStatusType getStatus(String requestId) throws Exception {
        DBSession session = null;
        try {
            session = DBSession.getInternalDBSession();
            ArrayList<Field> field = new ArrayList<Field>();
            field.add(new Field(EXPORT_ID, requestId, FieldType.STRING));
            ResultSet rs = session.executeFilteredQuery(field, EXPORT_REFERENCE_TABLE, EXPORT_ID, OrderDirection.ASC);
            if (rs.next()) {
                ExportTableStatusType status = new ExportTableStatusType();
                status.setCsvSettings((ExportCSVSettings)AquaMapsXStream.getXMLInstance().fromXML(rs.getString(EXPORT_SETTINGS)));
                status.setStatus(ExportStatus.fromValue((String)rs.getString(EXPORT_STATUS)));
                status.setRsLocator(rs.getString(EXPORT_LOCATOR));
                status.setTableName(rs.getString(EXPORT_TABLE));
                status.setErrors(rs.getString(EXPORT_ERROR_MSG));
                logger.debug((Object)("Found export status [refID:" + requestId + "] : " + status.getStatus() + "," + status.getTableName() + "," + status.getRsLocator()));
                ExportTableStatusType exportTableStatusType = status;
                return exportTableStatusType;
            }
            throw new Exception("Reference " + requestId + " not found");
        }
        finally {
            if (session != null) {
                session.close();
            }
        }
    }

    private static int updateField(String id, String field, FieldType objectType, Object value) throws Exception {
        DBSession session = null;
        try {
            session = DBSession.getInternalDBSession();
            ArrayList<List<Field>> keys = new ArrayList<List<Field>>();
            ArrayList<Field> filter = new ArrayList<Field>();
            filter.add(new Field(EXPORT_ID, id, FieldType.STRING));
            keys.add(filter);
            ArrayList<List<Field>> values = new ArrayList<List<Field>>();
            ArrayList<Field> valueList = new ArrayList<Field>();
            valueList.add(new Field(field + "", value + "", objectType));
            values.add(valueList);
            int n = session.updateOperation(EXPORT_REFERENCE_TABLE, keys, values);
            return n;
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            if (session != null) {
                session.close();
            }
        }
    }

    private ExportManager(String referenceId) {
        this.referenceId = referenceId;
        this.setName("EXPORTER_" + this.getId());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        block18: {
            DBSession session = null;
            boolean found = false;
            try {
                ExportManager.updateField(this.referenceId, EXPORT_STATUS, FieldType.STRING, "ONGOING");
                session = DBSession.getInternalDBSession();
                ArrayList<Field> field = new ArrayList<Field>();
                field.add(new Field(EXPORT_ID, this.referenceId, FieldType.STRING));
                ResultSet rs = session.executeFilteredQuery(field, EXPORT_REFERENCE_TABLE, EXPORT_ID, OrderDirection.ASC);
                if (rs.next()) {
                    found = true;
                    ExportCSVSettings settings = (ExportCSVSettings)AquaMapsXStream.getXMLInstance().fromXML(rs.getString(EXPORT_SETTINGS));
                    String fileName = session.exportTableToCSV(rs.getString(EXPORT_TABLE), settings.isHasHeader(), settings.getDelimiter().charAt(0));
                    ExportManager.updateField(this.referenceId, EXPORT_LOCAL_PATH, FieldType.STRING, fileName);
                    GCUBEScope scope = GCUBEScope.getScope((String)rs.getString(EXPORT_SCOPE));
                    ExportOperation operation = ExportOperation.fromString((String)rs.getString(EXPORT_OPERATION));
                    if (operation.equals((Object)ExportOperation.SAVE)) {
                        String owner = rs.getString(EXPORT_USER);
                        String destinationBasketId = rs.getString(EXPORT_BASKET);
                        String toSaveName = rs.getString(EXPORT_NAME);
                        HomeManagerFactory factory = HomeLibrary.getHomeManagerFactory();
                        Workspace workspace = factory.getHomeManager().getHome(owner, GCUBEScope.getScope((String)scope.toString())).getWorkspace();
                        workspace.createExternalFile(toSaveName, "Exported table", "text/csv", (InputStream)new FileInputStream(fileName), destinationBasketId);
                    } else {
                        RSWrapper wrapper = new RSWrapper(scope);
                        wrapper.add(new File(fileName));
                        String locator = wrapper.getLocator().toString();
                        logger.trace((Object)("Added file to locator " + locator));
                        ExportManager.updateField(this.referenceId, EXPORT_LOCATOR, FieldType.STRING, locator);
                    }
                    ExportManager.updateField(this.referenceId, EXPORT_TIME, FieldType.LONG, System.currentTimeMillis());
                    ExportManager.updateField(this.referenceId, EXPORT_STATUS, FieldType.STRING, ExportStatus.COMPLETED);
                    break block18;
                }
                throw new Exception("Reference " + this.referenceId + " not found");
            }
            catch (Exception e) {
                if (found) {
                    try {
                        ExportManager.updateField(this.referenceId, EXPORT_ERROR_MSG, FieldType.STRING, e.getMessage());
                        ExportManager.updateField(this.referenceId, EXPORT_STATUS, FieldType.STRING, "ERROR");
                    }
                    catch (Exception e1) {
                        logger.fatal((Object)("Unable to update export reference id  " + this.referenceId), (Throwable)e);
                    }
                }
            }
            finally {
                if (session != null) {
                    try {
                        session.close();
                    }
                    catch (Exception exception) {}
                }
            }
        }
    }
}

