/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.application.aquamaps.aquamapsservice.impl.db.managers;

import java.io.File;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.gcube.application.aquamaps.aquamapsservice.impl.db.DBSession;
import org.gcube.application.aquamaps.aquamapsservice.impl.db.DBUtils;
import org.gcube.application.aquamaps.aquamapsservice.impl.db.managers.SourceManager;
import org.gcube.application.aquamaps.aquamapsservice.impl.util.ServiceUtils;
import org.gcube.application.aquamaps.aquamapsservice.stubs.datamodel.enhanced.Field;
import org.gcube.application.aquamaps.aquamapsservice.stubs.datamodel.enhanced.Filter;
import org.gcube.application.aquamaps.aquamapsservice.stubs.datamodel.enhanced.Perturbation;
import org.gcube.application.aquamaps.aquamapsservice.stubs.datamodel.enhanced.Resource;
import org.gcube.application.aquamaps.aquamapsservice.stubs.datamodel.enhanced.Species;
import org.gcube.application.aquamaps.aquamapsservice.stubs.datamodel.fields.HspenFields;
import org.gcube.application.aquamaps.aquamapsservice.stubs.datamodel.fields.SpeciesOccursumFields;
import org.gcube.application.aquamaps.aquamapsservice.stubs.datamodel.types.FieldType;
import org.gcube.application.aquamaps.aquamapsservice.stubs.datamodel.utils.CSVUtils;
import org.gcube.common.core.utils.logging.GCUBELog;
import org.gcube_system.namespaces.application.aquamaps.types.PagedRequestSettings;

public class SpeciesManager {
    private static GCUBELog logger = new GCUBELog(SpeciesManager.class);
    public static final String speciesOccurSum = "speciesoccursum";

    public static Species getSpeciesById(boolean fetchStatic, boolean fetchEnvelope, String id, int hspenId) throws Exception {
        DBSession session = null;
        try {
            String hspenTable;
            List row;
            List row2;
            session = DBSession.getInternalDBSession();
            ArrayList<Field> filters = new ArrayList<Field>();
            filters.add(new Field("" + SpeciesOccursumFields.speciesid, id, FieldType.STRING));
            Species toReturn = new Species(id);
            if (fetchStatic && (row2 = (List)Field.loadResultSet((ResultSet)session.executeFilteredQuery(filters, speciesOccurSum, null, null)).get(0)) != null) {
                toReturn.getAttributesList().addAll(row2);
            }
            if (fetchEnvelope && (row = (List)Field.loadResultSet((ResultSet)session.executeFilteredQuery(filters, hspenTable = SourceManager.getSourceName(hspenId), null, null)).get(0)) != null) {
                toReturn.getAttributesList().addAll(row);
            }
            Species species = toReturn;
            return species;
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            if (session != null) {
                session.close();
            }
        }
    }

    public static Set<Species> getList(List<Field> filters) throws Exception {
        DBSession session = null;
        try {
            session = DBSession.getInternalDBSession();
            Set<Species> set = SpeciesManager.loadRS(session.executeFilteredQuery(filters, speciesOccurSum, null, null));
            return set;
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            if (session != null) {
                session.close();
            }
        }
    }

    public static Set<Species> getList(List<Field> filters, Resource hspen) throws Exception {
        DBSession session = null;
        try {
            session = DBSession.getInternalDBSession();
            String app = ServiceUtils.generateId("spec", "");
            String query = "CREATE TABLE " + app + " AS (SELECT * FROM " + speciesOccurSum + " WHERE " + SpeciesOccursumFields.speciesid + " IN (SELECT " + SpeciesOccursumFields.speciesid + " FROM " + hspen.getTableName() + "))";
            logger.debug((Object)("QUERY IS : " + query));
            session.executeUpdate(query);
            Set<Species> toReturn = SpeciesManager.loadRS(session.executeFilteredQuery(filters, app, null, null));
            session.dropTable(app);
            Set<Species> set = toReturn;
            return set;
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            if (session != null) {
                session.close();
            }
        }
    }

    public static String getFilteredHSPEN(String sourceHSPEN, Set<Species> toInsert) throws Exception {
        DBSession session = null;
        String tmpHspen = null;
        logger.trace((Object)("Filtering " + sourceHSPEN));
        try {
            session = DBSession.getInternalDBSession();
            tmpHspen = ServiceUtils.generateId("filteredhspen", "");
            session.createLikeTable(tmpHspen, sourceHSPEN);
            logger.trace((Object)("going to fill table " + tmpHspen));
            ArrayList<Field> condition = new ArrayList<Field>();
            condition.add(new Field("" + SpeciesOccursumFields.speciesid, "", FieldType.STRING));
            PreparedStatement ps = session.getPreparedStatementForInsertFromSelect(condition, tmpHspen, sourceHSPEN);
            int count = 0;
            for (Species s : toInsert) {
                ps.setString(1, s.getId());
                int inserted = ps.executeUpdate();
                if (inserted == 0) {
                    logger.warn((Object)("Species ID : " + s.getId() + " hasn't been inserted"));
                    continue;
                }
                count += inserted;
            }
            logger.trace((Object)("Inserted " + count + "/" + toInsert.size() + " species"));
            String string = tmpHspen;
            return string;
        }
        catch (Exception e) {
            logger.error((Object)"Unable to filter against species selection");
            if (tmpHspen != null) {
                session.dropTable(tmpHspen);
            }
            throw e;
        }
        finally {
            if (session != null) {
                session.close();
            }
        }
    }

    public static String getJSONList(PagedRequestSettings settings, List<Filter> genericSearch, List<Filter> specificSearch, int HSPENId) throws Exception {
        String selHspen = SourceManager.getSourceName(HSPENId);
        String[] queries = SpeciesManager.formFilterQueries(genericSearch, specificSearch, selHspen);
        DBSession session = null;
        try {
            session = DBSession.getInternalDBSession();
            ResultSet rs = session.executeQuery(queries[1]);
            rs.next();
            Long totalCount = rs.getLong(1);
            String string = DBUtils.toJSon(session.executeQuery(String.valueOf(queries[0]) + (settings.getOrderField() != null ? " order by " + SpeciesManager.getCompleteName(selHspen, settings.getOrderField()) + " " + settings.getOrderDirection() : "") + " LIMIT " + settings.getLimit() + " OFFSET " + settings.getOffset()), totalCount);
            return string;
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            if (session != null) {
                session.close();
            }
        }
    }

    public static File getCSVList(List<Filter> genericSearch, List<Filter> specificSearch, int HSPENId) throws Exception {
        String selHspen = SourceManager.getSourceName(HSPENId);
        String[] queries = SpeciesManager.formFilterQueries(genericSearch, specificSearch, selHspen);
        DBSession session = null;
        try {
            session = DBSession.getInternalDBSession();
            File out = File.createTempFile("speciesSelection", ".csv");
            CSVUtils.resultSetToCSVFile((ResultSet)session.executeQuery(queries[0]), (String)out.getAbsolutePath(), (boolean)true);
            File file = out;
            return file;
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            if (session != null) {
                session.close();
            }
        }
    }

    private static String[] formFilterQueries(List<Filter> ORGroup, List<Filter> specificFilters, String selectedHSPEN) throws Exception {
        StringBuilder orCondition = SpeciesManager.getCondition(ORGroup, "OR", selectedHSPEN);
        StringBuilder andCondition = SpeciesManager.getCondition(specificFilters, "AND", selectedHSPEN);
        StringBuilder filter = new StringBuilder(orCondition.length() > 0 ? "( " + orCondition.toString() + " )" : "");
        if (andCondition.length() > 0) {
            filter.append(filter.length() > 0 ? " AND " : "");
            filter.append("( " + andCondition.toString() + ")");
        }
        boolean includeHSPEN = filter.indexOf(selectedHSPEN) > -1;
        String fromString = " from speciesoccursum" + (includeHSPEN ? " INNER JOIN " + selectedHSPEN + " ON " + speciesOccurSum + "." + SpeciesOccursumFields.speciesid + " = " + selectedHSPEN + "." + SpeciesOccursumFields.speciesid : "");
        String query = "Select speciesoccursum.* " + (includeHSPEN ? " , " + selectedHSPEN + "." + HspenFields.pelagic : "") + fromString + " " + (filter.length() > 0 ? " where " : "") + filter.toString();
        String count = "Select count(speciesoccursum." + SpeciesOccursumFields.speciesid + ") " + fromString + " " + (filter.length() > 0 ? " where " : "") + filter.toString();
        logger.debug((Object)("filterSpecies: " + query));
        logger.debug((Object)("filterSpecies: " + count));
        return new String[]{query, count};
    }

    private static StringBuilder getCondition(List<Filter> filters, String operator, String selHSPEN) throws Exception {
        StringBuilder toReturn = new StringBuilder();
        if (filters.size() > 0) {
            for (Filter filter : filters) {
                toReturn.append(String.valueOf(SpeciesManager.getCompleteName(selHSPEN, filter.getField().getName())) + filter.toSQLString() + " " + operator + " ");
            }
            int index = toReturn.lastIndexOf(operator);
            toReturn.delete(index, index + 3);
        }
        return toReturn;
    }

    public static String getCompleteName(String hspenName, String fieldName) throws Exception {
        try {
            return "speciesoccursum." + SpeciesOccursumFields.valueOf((String)fieldName);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return String.valueOf(hspenName) + "." + HspenFields.valueOf((String)fieldName);
        }
    }

    public static String perturbationUpdate(String hspenTable, Map<String, Perturbation> toSetPerturbations, String speciesId) throws Exception {
        StringBuilder toReturn = new StringBuilder();
        toReturn.append("UPDATE " + hspenTable + " SET ");
        for (Map.Entry<String, Perturbation> settings : toSetPerturbations.entrySet()) {
            toReturn.append(String.valueOf(settings.getKey()) + " = " + settings.getValue().getPerturbationValue() + " , ");
        }
        toReturn.deleteCharAt(toReturn.lastIndexOf(","));
        toReturn.append(" WHERE " + SpeciesOccursumFields.speciesid + "= '" + speciesId + "'");
        return toReturn.toString();
    }

    private static Set<Species> loadRS(ResultSet rs) throws SQLException {
        HashSet<Species> toReturn = new HashSet<Species>();
        List rows = Field.loadResultSet((ResultSet)rs);
        for (List row : rows) {
            Species toAdd = new Species("***");
            toAdd.getAttributesList().addAll(row);
            toAdd.setId(toAdd.getFieldbyName("" + SpeciesOccursumFields.speciesid).getValue());
            toReturn.add(toAdd);
        }
        return toReturn;
    }

    public static String getJSONTaxonomy(Field toSelect, List<Field> filters, PagedRequestSettings settings) throws Exception {
        DBSession session = null;
        try {
            session = DBSession.getInternalDBSession();
            String string = DBUtils.toJSon(session.getDistinct(toSelect, filters, speciesOccurSum, settings.getOrderField(), settings.getOrderDirection()), settings.getOffset(), settings.getLimit() + settings.getOffset());
            return string;
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            if (session != null) {
                session.close();
            }
        }
    }

    public static String getCommonTaxonomy(Set<Species> species) throws Exception {
        logger.info((Object)("Chcking common taxonomy, to analyze species count : " + species.size()));
        logger.info((Object)"loading species static info..");
        long start = System.currentTimeMillis();
        HashSet<Species> enrichedSpecies = new HashSet<Species>();
        for (Species s : species) {
            enrichedSpecies.add(SpeciesManager.getSpeciesById(true, false, s.getId(), 0));
        }
        logger.info((Object)("Loaded in " + (System.currentTimeMillis() - start) + " ms"));
        HashMap<SpeciesOccursumFields, String> commonLevels = new HashMap<SpeciesOccursumFields, String>();
        SpeciesOccursumFields[] toCheckValues = new SpeciesOccursumFields[]{SpeciesOccursumFields.kingdom, SpeciesOccursumFields.phylum, SpeciesOccursumFields.classcolumn, SpeciesOccursumFields.ordercolumn, SpeciesOccursumFields.familycolumn};
        boolean continueCheck = true;
        SpeciesOccursumFields[] speciesOccursumFieldsArray = toCheckValues;
        int n = toCheckValues.length;
        int n2 = 0;
        while (n2 < n) {
            SpeciesOccursumFields toCheck = speciesOccursumFieldsArray[n2];
            if (continueCheck) {
                for (Species s : enrichedSpecies) {
                    if (!commonLevels.containsKey(toCheck)) {
                        commonLevels.put(toCheck, s.getFieldbyName("" + toCheck).getValue());
                        continue;
                    }
                    if (s.getFieldbyName("" + toCheck).getValue().equalsIgnoreCase((String)commonLevels.get(toCheck))) continue;
                    continueCheck = false;
                    commonLevels.remove(toCheck);
                }
            }
            ++n2;
        }
        StringBuilder toReturn = new StringBuilder();
        SpeciesOccursumFields[] speciesOccursumFieldsArray2 = toCheckValues;
        int n3 = toCheckValues.length;
        n = 0;
        while (n < n3) {
            SpeciesOccursumFields level = speciesOccursumFieldsArray2[n];
            if (commonLevels.containsKey(level)) {
                toReturn.append(String.valueOf((String)commonLevels.get(level)) + File.separator);
            }
            ++n;
        }
        if (toReturn.length() > 0) {
            toReturn.deleteCharAt(toReturn.lastIndexOf(File.separator));
        }
        logger.info((Object)("Found common taxonomy in " + (System.currentTimeMillis() - start) + " ms"));
        return toReturn.toString();
    }
}

