/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.application.aquamaps.aquamapsservice.impl.engine.tables;

import java.util.ArrayList;
import java.util.Iterator;
import org.gcube.application.aquamaps.aquamapsservice.impl.db.managers.SourceGenerationRequestsManager;
import org.gcube.application.aquamaps.aquamapsservice.impl.db.managers.SubmittedManager;
import org.gcube.application.aquamaps.aquamapsservice.impl.engine.predictions.BatchGeneratorObjectFactory;
import org.gcube.application.aquamaps.aquamapsservice.stubs.datamodel.enhanced.Field;
import org.gcube.application.aquamaps.aquamapsservice.stubs.datamodel.enhanced.Submitted;
import org.gcube.application.aquamaps.aquamapsservice.stubs.datamodel.environments.SourceGenerationRequest;
import org.gcube.application.aquamaps.aquamapsservice.stubs.datamodel.fields.SourceGenerationRequestFields;
import org.gcube.application.aquamaps.aquamapsservice.stubs.datamodel.fields.SubmittedFields;
import org.gcube.application.aquamaps.aquamapsservice.stubs.datamodel.types.FieldType;
import org.gcube.application.aquamaps.aquamapsservice.stubs.datamodel.types.SourceGenerationPhase;
import org.gcube.application.aquamaps.aquamapsservice.stubs.datamodel.types.SubmittedStatus;
import org.gcube.common.core.utils.logging.GCUBELog;

public class EnvironmentalStatusUpdateThread
extends Thread {
    private static final GCUBELog logger = new GCUBELog(EnvironmentalStatusUpdateThread.class);
    private long millis;

    public EnvironmentalStatusUpdateThread(long millis) {
        super("Environmental status updater");
        this.millis = millis;
    }

    @Override
    public void run() {
        block15: while (true) {
            try {
                try {
                    ArrayList<Object> filter = new ArrayList<Field>();
                    filter.add(new Field("" + SourceGenerationRequestFields.phase, "" + SourceGenerationPhase.datageneration, FieldType.STRING));
                    for (SourceGenerationRequest request : SourceGenerationRequestsManager.getList(filter)) {
                        try {
                            int completedSteps = request.getGeneratedSources().size() / (request.getToGenerateTableCount() / request.getEvaluatedComputationCount());
                            Double percent = (double)completedSteps / (double)request.getEvaluatedComputationCount().intValue() * 100.0;
                            StringBuilder logBuilder = new StringBuilder("completed steps = " + completedSteps);
                            logBuilder.append("computation count = " + request.getEvaluatedComputationCount());
                            for (Integer reportId : request.getReportID()) {
                                Double reportStatus = BatchGeneratorObjectFactory.getReport(reportId, false).getPercent();
                                percent = percent + reportStatus / (double)request.getEvaluatedComputationCount().intValue();
                                logBuilder.append("reportId " + reportId + " status " + reportStatus);
                            }
                            logger.trace((Object)("Updateing reference " + request.getId() + ", percent " + percent + ", formula details " + logBuilder));
                            SourceGenerationRequestsManager.setPhasePercent(percent, request.getId());
                        }
                        catch (Exception e) {
                            logger.warn((Object)("Skipping percent update for execution id " + request.getId() + ", report id was " + request.getReportID()), (Throwable)e);
                            logger.debug((Object)("Request data were : Generated sources size : " + request.getGeneratedSources().size() + "To generate count : " + request.getToGenerateTableCount() + "Computation count : " + request.getEvaluatedComputationCount()));
                        }
                    }
                    filter = new ArrayList();
                    filter.add(new Field("" + SourceGenerationRequestFields.phase, "" + SourceGenerationPhase.mapgeneration, FieldType.STRING));
                    Iterator<SourceGenerationRequest> iterator = SourceGenerationRequestsManager.getList(filter).iterator();
                    while (true) {
                        SourceGenerationRequest request;
                        if (!iterator.hasNext()) continue block15;
                        request = iterator.next();
                        try {
                            boolean completed = true;
                            SourceGenerationPhase toSetCompletedPhase = SourceGenerationPhase.completed;
                            for (Integer id : request.getJobIds()) {
                                Submitted job = SubmittedManager.getSubmittedById(id);
                                if (!job.getStatus().equals((Object)SubmittedStatus.Completed) && !job.getStatus().equals((Object)SubmittedStatus.Error)) {
                                    completed = false;
                                }
                                if (!job.getStatus().equals((Object)SubmittedStatus.Error)) continue;
                                toSetCompletedPhase = SourceGenerationPhase.error;
                            }
                            if (completed) {
                                logger.info((Object)("All jobs completed for source generation " + request.getId() + ", to set phase : " + toSetCompletedPhase));
                                SourceGenerationRequestsManager.setPhase(toSetCompletedPhase, request.getId());
                                continue;
                            }
                            double sumPartials = 0.0;
                            ArrayList<Field> completedFilter = null;
                            ArrayList<Field> toCompleteFilter = null;
                            StringBuilder logBuilder = new StringBuilder();
                            for (Integer id : request.getJobIds()) {
                                completedFilter = new ArrayList<Field>();
                                completedFilter.add(new Field("" + SubmittedFields.jobid, "" + id, FieldType.INTEGER));
                                completedFilter.add(new Field("" + SubmittedFields.status, "" + SubmittedStatus.Completed, FieldType.STRING));
                                toCompleteFilter = new ArrayList<Field>();
                                toCompleteFilter.add(new Field("" + SubmittedFields.jobid, "" + id, FieldType.INTEGER));
                                long totalObjectCount = SubmittedManager.getCount(toCompleteFilter);
                                if (totalObjectCount <= 0L) continue;
                                long completedObjects = SubmittedManager.getCount(completedFilter);
                                double partial = (double)completedObjects / (double)totalObjectCount / (double)request.getJobIds().size();
                                logBuilder.append("Job [" + id + "] partial progress " + partial + " (" + completedObjects + "/" + totalObjectCount + ")");
                                sumPartials += partial;
                            }
                            Double percent = 100.0 * sumPartials;
                            logger.debug((Object)("Progress for " + request.getId() + " : " + percent + " forumla details : " + logBuilder));
                            SourceGenerationRequestsManager.setPhasePercent(percent, request.getId());
                        }
                        catch (Exception e) {
                            logger.warn((Object)("Skipping percent update for execution id " + request.getId()), (Throwable)e);
                        }
                    }
                }
                catch (Exception e) {
                    logger.error((Object)"Unexpected exception ", (Throwable)e);
                    try {
                        Thread.sleep(this.millis);
                    }
                    catch (InterruptedException interruptedException) {}
                }
                continue;
            }
            finally {
                try {
                    Thread.sleep(this.millis);
                }
                catch (InterruptedException interruptedException) {}
                continue;
            }
            break;
        }
    }
}

