/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.application.aquamaps.publisher.impl.model;

import java.util.ArrayList;
import java.util.Iterator;
import org.gcube.application.aquamaps.aquamapsservice.stubs.fw.model.gis.LayerType;
import org.gcube.application.aquamaps.publisher.MetaInformations;
import org.gcube.application.aquamaps.publisher.impl.model.ContextLayerPair;
import org.gcube.application.aquamaps.publisher.impl.model.CoverageDescriptor;
import org.gcube.application.aquamaps.publisher.impl.model.Storable;
import org.gcube.application.aquamaps.publisher.impl.model.searchsupport.LayerSpeciesIdPair;
import org.gcube.common.core.utils.logging.GCUBELog;
import org.gcube.common.dbinterface.Specification;
import org.gcube.common.dbinterface.persistence.ObjectNotFoundException;
import org.gcube.common.dbinterface.persistence.ObjectPersistency;
import org.gcube.common.dbinterface.persistence.PersistencyCallback;
import org.gcube.common.dbinterface.persistence.annotations.FieldDefinition;
import org.gcube.common.dbinterface.persistence.annotations.TableRootDefinition;
import org.gcube.common.gis.datamodel.enhanced.LayerInfo;

@TableRootDefinition
public class Layer
extends CoverageDescriptor
implements Storable {
    public static GCUBELog logger = new GCUBELog(Layer.class);
    @FieldDefinition(precision={200}, specifications={Specification.NOT_NULL, Specification.PRIMARY_KEY})
    private String id;
    @FieldDefinition(specifications={Specification.NOT_NULL})
    private LayerType type;
    @FieldDefinition(specifications={Specification.NOT_NULL})
    private LayerInfo layerInfo;
    @FieldDefinition(specifications={Specification.NOT_NULL})
    private MetaInformations metaInfo;
    private String[] speciesIds;
    private ArrayList<String> wmsContextsId;

    static {
        try {
            ObjectPersistency.get(Layer.class).addCallback((PersistencyCallback)new PersistencyCallback<Layer>(){

                public void onObjectLoaded(Layer obj) {
                    Iterator it;
                    ArrayList<String> toSet = new ArrayList<String>();
                    try {
                        it = ObjectPersistency.get(ContextLayerPair.class).getObjectByField("layerId", (Object)obj.getId()).iterator();
                        while (it.hasNext()) {
                            toSet.add(((ContextLayerPair)it.next()).getWmsContextId());
                        }
                    }
                    catch (Exception e) {
                        toSet = new ArrayList();
                    }
                    obj.setWmsContextsId(toSet);
                    toSet = new ArrayList();
                    try {
                        it = ObjectPersistency.get(LayerSpeciesIdPair.class).getObjectByField("id", (Object)obj.getId()).iterator();
                        while (it.hasNext()) {
                            toSet.add(((LayerSpeciesIdPair)it.next()).getSpeciesId());
                        }
                    }
                    catch (Exception e) {
                        toSet = new ArrayList();
                    }
                    obj.setSpeciesIds(toSet.toArray(new String[toSet.size()]));
                }

                public void onObjectUpdated(Layer obj) {
                    try {
                        ObjectPersistency.get(ContextLayerPair.class).deleteByValue("layerId", (Object)obj.getId());
                        for (String contextId : obj.getWmsContextsId()) {
                            ObjectPersistency.get(ContextLayerPair.class).insert((Object)new ContextLayerPair(contextId, obj.getId()));
                        }
                    }
                    catch (Exception e) {
                        logger.warn((Object)"error updating layer WMSContext relation", (Throwable)e);
                    }
                    try {
                        ObjectPersistency.get(LayerSpeciesIdPair.class).deleteByValue("id", (Object)obj.getId());
                        String[] stringArray = obj.getSpeciesIds();
                        int n = stringArray.length;
                        int n2 = 0;
                        while (n2 < n) {
                            String speciesId = stringArray[n2];
                            ObjectPersistency.get(LayerSpeciesIdPair.class).insert((Object)new LayerSpeciesIdPair(speciesId, obj.getId()));
                            ++n2;
                        }
                    }
                    catch (Exception e) {
                        logger.warn((Object)"error updating layer speciesId relation", (Throwable)e);
                    }
                }

                public void onObjectStored(Layer obj) {
                    try {
                        String[] stringArray = obj.getSpeciesIds();
                        int n = stringArray.length;
                        int n2 = 0;
                        while (n2 < n) {
                            String speciesId = stringArray[n2];
                            ObjectPersistency.get(LayerSpeciesIdPair.class).insert((Object)new LayerSpeciesIdPair(speciesId, obj.getId()));
                            ++n2;
                        }
                    }
                    catch (Exception e) {
                        logger.warn((Object)"error storing layer speciesId relation", (Throwable)e);
                    }
                }

                public void onObjectDeleted(Layer obj) {
                    try {
                        ObjectPersistency.get(ContextLayerPair.class).deleteByValue("layerId", (Object)obj.getId());
                    }
                    catch (Exception e) {
                        logger.warn((Object)"error deleting layer WMSContext relation", (Throwable)e);
                    }
                    try {
                        ObjectPersistency.get(LayerSpeciesIdPair.class).deleteByValue("id", (Object)obj.getId());
                    }
                    catch (Exception e) {
                        logger.warn((Object)"error deleting layer speciesId relation", (Throwable)e);
                    }
                }
            });
        }
        catch (Exception e) {
            logger.error((Object)"error adding callback", (Throwable)e);
        }
    }

    public Layer(LayerType type, boolean customized, LayerInfo layerInfo, CoverageDescriptor coverage, MetaInformations metaInfo, String ... speciesIds) {
        super(coverage.getTableId(), coverage.getParameters());
        this.id = layerInfo.getName();
        this.type = type;
        this.layerInfo = layerInfo;
        this.metaInfo = metaInfo;
        this.wmsContextsId = new ArrayList();
        this.speciesIds = speciesIds != null ? speciesIds : new String[0];
    }

    private Layer() {
    }

    @Override
    public String getId() {
        return this.id;
    }

    public ArrayList<String> getWmsContextsId() {
        return this.wmsContextsId;
    }

    public void setWmsContextsId(ArrayList<String> wmsContextsId) {
        this.wmsContextsId = wmsContextsId;
    }

    public MetaInformations getMetaInfo() {
        return this.metaInfo;
    }

    @Override
    public void setId(String id) {
        this.id = id;
    }

    public LayerType getType() {
        return this.type;
    }

    public void setType(LayerType type) {
        this.type = type;
    }

    public LayerInfo getLayerInfo() {
        return this.layerInfo;
    }

    public String[] getSpeciesIds() {
        return this.speciesIds;
    }

    public void setSpeciesIds(String[] speciesIds) {
        this.speciesIds = speciesIds;
    }

    protected static Layer get(String id) throws ObjectNotFoundException, Exception {
        return (Layer)ObjectPersistency.get(Layer.class).getByKey((Object)id);
    }

    protected static void remove(String id) throws ObjectNotFoundException, Exception {
        ObjectPersistency.get(Layer.class).deleteByKey((Object)id);
    }
}

