/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.application.aquamaps.publisher.impl.model;

import java.util.ArrayList;
import java.util.Iterator;
import org.gcube.application.aquamaps.publisher.impl.model.ContextLayerPair;
import org.gcube.application.aquamaps.publisher.impl.model.Storable;
import org.gcube.common.core.utils.logging.GCUBELog;
import org.gcube.common.dbinterface.Specification;
import org.gcube.common.dbinterface.persistence.ObjectPersistency;
import org.gcube.common.dbinterface.persistence.PersistencyCallback;
import org.gcube.common.dbinterface.persistence.annotations.FieldDefinition;
import org.gcube.common.dbinterface.persistence.annotations.TableRootDefinition;
import org.gcube.common.gis.datamodel.enhanced.WMSContextInfo;

@TableRootDefinition
public class WMSContext
implements Storable {
    public static GCUBELog logger = new GCUBELog(WMSContext.class);
    @FieldDefinition(precision={40}, specifications={Specification.NOT_NULL, Specification.PRIMARY_KEY})
    private String id;
    @FieldDefinition
    private WMSContextInfo wmsContextInfo;
    private ArrayList<String> layersId;

    static {
        try {
            ObjectPersistency.get(WMSContext.class).addCallback((PersistencyCallback)new PersistencyCallback<WMSContext>(){

                public void onObjectLoaded(WMSContext obj) {
                    ArrayList<String> toSet = new ArrayList<String>();
                    try {
                        Iterator it = ObjectPersistency.get(ContextLayerPair.class).getObjectByField("wmsContextId", (Object)obj.getId()).iterator();
                        while (it.hasNext()) {
                            toSet.add(((ContextLayerPair)it.next()).getLayerId());
                        }
                    }
                    catch (Exception e) {
                        toSet = new ArrayList();
                    }
                    obj.setLayersId(toSet);
                }

                public void onObjectStored(WMSContext obj) {
                    try {
                        for (String layerId : obj.getLayersId()) {
                            ObjectPersistency.get(ContextLayerPair.class).insert((Object)new ContextLayerPair(obj.getId(), layerId));
                        }
                    }
                    catch (Exception e) {
                        logger.warn((Object)"error storin layer WMSContext relation", (Throwable)e);
                    }
                }

                public void onObjectUpdated(WMSContext obj) {
                    try {
                        ObjectPersistency.get(ContextLayerPair.class).deleteByValue("wmsContextId", (Object)obj.getId());
                        for (String layerId : obj.getLayersId()) {
                            ObjectPersistency.get(ContextLayerPair.class).insert((Object)new ContextLayerPair(obj.getId(), layerId));
                        }
                    }
                    catch (Exception e) {
                        logger.warn((Object)"error storin layer WMSContext relation", (Throwable)e);
                    }
                }

                public void onObjectDeleted(WMSContext obj) {
                    try {
                        ObjectPersistency.get(ContextLayerPair.class).deleteByValue("wmsContextId", (Object)obj.getId());
                    }
                    catch (Exception e) {
                        logger.warn((Object)"error deleting layer WMSContext relation", (Throwable)e);
                    }
                }
            });
        }
        catch (Exception e) {
            logger.error((Object)"error adding callback", (Throwable)e);
        }
    }

    private WMSContext() {
    }

    public WMSContext(WMSContextInfo wmsContextInfo, ArrayList<String> layersId) {
        this.id = wmsContextInfo.getName();
        this.wmsContextInfo = wmsContextInfo;
        this.layersId = layersId;
    }

    public ArrayList<String> getLayersId() {
        return this.layersId;
    }

    public void setLayersId(ArrayList<String> layersId) {
        this.layersId = layersId;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public void setId(String id) {
        this.id = id;
    }

    public WMSContextInfo getWmsContextInfo() {
        return this.wmsContextInfo;
    }
}

